package com.ejianc.business.market.mapper;

import com.ejianc.business.constructor.vo.NbzzFollowVO;
import com.ejianc.business.market.vo.CostDesktopVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.market.bean.ProjectSetEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 项目立项表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectSetMapper extends BaseCrudMapper<ProjectSetEntity> {
    @Select("SELECT COUNT(*) cbgm,\n" +
            "(SELECT COUNT(*) djg FROM `ejc_promarket_project_set`\n" +
            "where business_status = 5\n" +
            "and dr = 0\n" +
            "and bill_state in (1,3)\n" +
            ") djg,\n" +
            "(SELECT COUNT(*) jg FROM `ejc_promarket_project_set`\n" +
            "where business_status = 6\n" +
            "and dr = 0\n" +
            "and bill_state in (1,3)) jg ,\n" +
            "( SELECT count(*) FROM \n" +
            "( SELECT COUNT(*) cbgmgd FROM ejc_promarket_close_cost \n" +
            "WHERE dr = 0 AND bill_state IN ( 1, 3 ) GROUP BY project_id ) AS y \n" +
            ") cbgmgd" +
            " FROM `ejc_promarket_project_set`\n" +
            "where capital_status = 16\n" +
            "and dr = 0\n" +
            "and bill_state in (1,3)")
    CostDesktopVO queryProjectNumCostDesktop();




    @Select("SELECT\n" +
            "\t* \n" +
            "FROM\n" +
            "\t`ejc-companypfm`.t_companypfm_nbzz_follow \n" +
            "WHERE\n" +
            "\tdr = 0 \n" +
            "\tAND source_type = \"PM\" \n" +
            "\tAND project_id = #{project}")
    List<NbzzFollowVO> queryFollowListByProjectId(Long projectId);
}
