/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.danger.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.ZjlzfaVO;
import com.ejianc.business.danger.bean.DangerProjectEntity;
import com.ejianc.business.danger.service.IDangerProjectService;
import com.ejianc.business.danger.vo.DangerProjectDesktopDTO;
import com.ejianc.business.danger.vo.DangerProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dangerProject"})
public class DangerProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "WDGC";
    @Autowired
    private IDangerProjectService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DangerProjectVO> saveOrUpdate(@RequestBody DangerProjectVO saveOrUpdateVO) {
        DangerProjectEntity entity = (DangerProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DangerProjectEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        DangerProjectVO vo = (DangerProjectVO)BeanMapper.map((Object)((Object)entity), DangerProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DangerProjectVO> queryDetail(Long id) {
        DangerProjectEntity entity = (DangerProjectEntity)((Object)this.service.selectById(id));
        DangerProjectVO vo = (DangerProjectVO)BeanMapper.map((Object)((Object)entity), DangerProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DangerProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DangerProjectVO dangerProjectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DangerProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("zjlzfzName");
        fuzzyFields.add("dutyPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        List orgVOList = null;
        if (param.getParams().containsKey("orgId")) {
            String orgId = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            param.getParams().remove("orgId");
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(orgId)), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DangerProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        for (DangerProjectEntity dangerProjectEntity : list) {
            if (dangerProjectEntity.getDangerType() != null) {
                if ("1".equals(dangerProjectEntity.getDangerType())) {
                    dangerProjectEntity.setDangerType("\u8d85\u5371\u5de5\u7a0b\uff08\u8bba\u8bc1\uff09");
                } else if ("2".equals(dangerProjectEntity.getDangerType())) {
                    dangerProjectEntity.setDangerType("\u5371\u5927\u5de5\u7a0b");
                }
            }
            if (dangerProjectEntity.getIsFinish() == null) continue;
            if ("1".equals(dangerProjectEntity.getIsFinish())) {
                dangerProjectEntity.setIsFinish("\u662f");
                continue;
            }
            if (!"2".equals(dangerProjectEntity.getIsFinish())) continue;
            dangerProjectEntity.setIsFinish("\u5426");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DangerProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDangerProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DangerProjectVO>> refDangerProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DangerProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryFaByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ZjlzfaVO> queryFaByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("gcxmmcId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        LinkedHashMap orderMap = queryParam.getOrderMap();
        orderMap.clear();
        orderMap.put("createTime", "desc");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<ZjlzfaVO> zjlzfaVOS = this.service.queryFaByProjectId(wrapper);
        if (ListUtil.isNotEmpty(zjlzfaVOS)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)zjlzfaVOS.get(0));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u65e0\u5ba1\u6279\u901a\u8fc7\u7684\u4e13\u5bb6\u8bba\u8bc1\u65b9\u6848\uff01");
    }

    @RequestMapping(value={"/queryDesktopList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Page<DangerProjectDesktopDTO>> queryDesktopList(@RequestBody QueryParam param) {
        Long orgId = null;
        if (param.getParams().containsKey("orgId")) {
            param.getParams().remove("orgId");
        }
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List<Long> orgIdList = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<DangerProjectDesktopDTO> dangerProjectDesktopDTOS = this.service.queryDesktopList((Page<DangerProjectDesktopDTO>)page, orgIdList);
        page.setRecords(dangerProjectDesktopDTOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryDesktopDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Page<DangerProjectDesktopDTO>> queryDesktopDetail(Long orgId) {
        QueryParam param = new QueryParam();
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List orgIdList = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        ArrayList<DangerProjectDesktopDTO> dangerProjectDesktopDTOS = new ArrayList<DangerProjectDesktopDTO>();
        List<DangerProjectVO> dangerProjectVOS = this.service.queryStatus(null, wrapper);
        DangerProjectDesktopDTO dto1 = this.getDto("\u5df2\u65bd\u5b8c\u5de5", dangerProjectVOS);
        DangerProjectDesktopDTO dto2 = this.getDto("\u672c\u5e74\u5728\u65bd", dangerProjectVOS);
        DangerProjectDesktopDTO dto3 = this.getDto("\u672c\u5e74\u5f85\u65bd", dangerProjectVOS);
        DangerProjectDesktopDTO dto4 = this.getDto("\u8d85\u671f\u672a\u65bd", dangerProjectVOS);
        DangerProjectDesktopDTO dto5 = this.getDto("\u8d85\u671f\u672a\u5b8c\u6210", dangerProjectVOS);
        dangerProjectDesktopDTOS.add(dto1);
        dangerProjectDesktopDTOS.add(dto2);
        dangerProjectDesktopDTOS.add(dto3);
        dangerProjectDesktopDTOS.add(dto4);
        dangerProjectDesktopDTOS.add(dto5);
        page.setRecords(dangerProjectDesktopDTOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private DangerProjectDesktopDTO getDto(String name, List<DangerProjectVO> dangerProjectVOS) {
        List<Object> finishCw = new ArrayList();
        List<Object> finishWd = new ArrayList();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        SimpleDateFormat getYearFormat = new SimpleDateFormat("yyyy");
        if (name.equals("\u672c\u5e74\u5728\u65bd")) {
            finishCw = dangerProjectVOS.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getStatus()) && s.getStatus().equals("\u5728\u65bd") && s.getDangerType().equals("1") && s.getImplDate() != null && getYearFormat.format(s.getImplDate()).equals(year + "")).collect(Collectors.toList());
            finishWd = dangerProjectVOS.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getStatus()) && s.getStatus().equals("\u5728\u65bd") && s.getDangerType().equals("2") && s.getImplDate() != null && getYearFormat.format(s.getImplDate()).equals(year + "")).collect(Collectors.toList());
        } else if (name.equals("\u672c\u5e74\u5f85\u65bd")) {
            finishCw = dangerProjectVOS.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getStatus()) && s.getStatus().equals("\u5f85\u65bd") && s.getDangerType().equals("1") && s.getEstimateImplDate() != null && getYearFormat.format(s.getEstimateImplDate()).equals(year + "")).collect(Collectors.toList());
            finishWd = dangerProjectVOS.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getStatus()) && s.getStatus().equals("\u5f85\u65bd") && s.getDangerType().equals("2") && s.getEstimateImplDate() != null && getYearFormat.format(s.getEstimateImplDate()).equals(year + "")).collect(Collectors.toList());
        } else {
            finishCw = dangerProjectVOS.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getStatus()) && s.getStatus().equals(name) && s.getDangerType().equals("1")).collect(Collectors.toList());
            finishWd = dangerProjectVOS.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getStatus()) && s.getStatus().equals(name) && s.getDangerType().equals("2")).collect(Collectors.toList());
        }
        DangerProjectDesktopDTO dto = new DangerProjectDesktopDTO();
        dto.setName(name);
        dto.setCw(Integer.valueOf(finishCw.size()));
        dto.setWd(Integer.valueOf(finishWd.size()));
        return dto;
    }

    @RequestMapping(value={"/queryStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DangerProjectVO>> queryStatus(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("zjlzfzName");
        fuzzyFields.add("dutyPerson");
        fuzzyFields.add("billCode");
        List orgVOList = null;
        ArrayList commonOrgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        page.setRecords(this.service.queryStatus((Page<DangerProjectVO>)page, wrapper));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

