package com.ejianc.business.market.mapper;

import com.ejianc.business.market.vo.CostDesktopDTO;
import com.ejianc.business.market.vo.CostDesktopVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.market.bean.AdjustApplicationEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工程状态调整申请
 *
 * @author baipengyan
 */
@Mapper
public interface AdjustApplicationMapper extends BaseCrudMapper<AdjustApplicationEntity> {

    @Select("SELECT\n" +
            "t1.id,t1.project_id ,t1.project_name name,t1.finish_work_date,DATEDIFF(now(),finish_work_date) value\n" +
            "FROM\n" +
            "ejc_promarket_adjust_application t1\n" +
            "INNER JOIN ( \n" +
            "SELECT MAX( id ) AS id FROM ejc_promarket_adjust_application where dr = 0 \n" +
            "and bill_state in (1,3)\n" +
            "GROUP BY project_id \n" +
            ") t2 ON t1.id = t2.id\n" +
            "where t1.state_after_adjustment  = 5\n" +
            "and t1.project_id not in (\n" +
            "SELECT project_id FROM ejc_promarket_close_cost\n" +
            "where dr = 0\n" +
            "and bill_state in (1,3))")
    List<CostDesktopDTO> queryFinishWorkBill();//工程状态调整申请单每个项目最新一条数据->为待竣工->没有成本关门归档
}
