package com.ejianc.business.market.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.business.market.vo.CloseCostVO;
import com.ejianc.business.market.vo.TargetCostFitDTO;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.market.bean.CloseCostEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 成本关门
 * 
 * @author generator
 * 
 */
@Mapper
public interface CloseCostMapper extends BaseCrudMapper<CloseCostEntity> {
    /**
     * 查询施工合同
     */
    List<ContractRegisterVO> queryProIncome(Long project);
    /**
     * 查询工程定案
     */
    FinalizedVO queryFinalized(Long project);
    /**
     * 查询成本关门台账信息
     */
    List<CloseCostReportVO> queryReportList(Page<CloseCostReportVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper);

    //获取目标、分析利润率
    TargetCostFitDTO getTargetReportFit(Long projectId);
}
