/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectOverView.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.outputvalcount.vo.MonthlyStatisticsVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.business.projectOverView.service.IProjectOverViewService;
import com.ejianc.business.projectOverView.vo.AchieveData;
import com.ejianc.business.projectOverView.vo.FaDataVO;
import com.ejianc.business.projectOverView.vo.ImageDataVO;
import com.ejianc.business.projectOverView.vo.ImageListVO;
import com.ejianc.business.projectOverView.vo.LogDataVO;
import com.ejianc.business.projectOverView.vo.MeetingMinutesDataVO;
import com.ejianc.business.projectOverView.vo.PaymentRegisterData;
import com.ejianc.business.projectOverView.vo.PlanDataVO;
import com.ejianc.business.projectOverView.vo.QualityAndSafeDataVO;
import com.ejianc.business.projectOverView.vo.RectificationVO;
import com.ejianc.business.projectmanage.vo.PracticeVO;
import com.ejianc.business.quality.vo.GccymbsdVO;
import com.ejianc.business.riskManage.vo.RiskAssessLatestVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectOverView"})
public class ProjectOverViewController
implements Serializable {
    @Autowired
    private IProjectOverViewService projectOverViewService;
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final BigDecimal FIVE_MILLION = new BigDecimal(5000000);
    private static final BigDecimal TEN_MILLION = new BigDecimal(10000000);

    @RequestMapping(value={"/queryFaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FaDataVO> queryFaData(Long projectId) {
        FaDataVO faDataVO = this.projectOverViewService.queryFaData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6280\u672f\u7ba1\u7406\u65b9\u6848\u6570\u91cf\u6570\u636e\u6210\u529f\uff01", (Object)faDataVO);
    }

    @RequestMapping(value={"/queryCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QualityAndSafeDataVO> queryCheckData(Long projectId) {
        QualityAndSafeDataVO qualityAndSafeDataVO = this.projectOverViewService.queryCheckData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8d28\u91cf\u68c0\u67e5\u6253\u5206\u60c5\u51b5\u6570\u636e\u6210\u529f\uff01", (Object)qualityAndSafeDataVO);
    }

    @RequestMapping(value={"/queryMeetingMinutesData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MeetingMinutesDataVO> queryMeetingMinutesData(Long projectId) {
        MeetingMinutesDataVO meetingMinutesDataVO = this.projectOverViewService.queryMeetingMinutesData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u76d1\u7406\u4f1a\u8bae\u7eaa\u8981\u6570\u636e\u6210\u529f\uff01", (Object)meetingMinutesDataVO);
    }

    @RequestMapping(value={"/queryTargetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GccymbsdVO> queryTargetData(Long projectId) {
        GccymbsdVO gccymbsdVO = this.projectOverViewService.queryTarget(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u5de5\u7a0b\u521b\u4f18\u76ee\u6807\u5ba1\u5b9a\u6570\u636e\u6210\u529f\uff01", (Object)gccymbsdVO);
    }

    @RequestMapping(value={"/queryImageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ImageDataVO> queryImageData(Long projectId, String dateStr) {
        ImageDataVO imageDataVO = this.projectOverViewService.queryImageData(projectId, dateStr);
        return CommonResponse.success((String)"\u6309\u6708\u67e5\u8be2\u9879\u76ee\u5f71\u50cf\u7ba1\u7406\u56fe\u7247\u6210\u529f\uff01", (Object)imageDataVO);
    }

    @RequestMapping(value={"/queryAllImageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ImageDataVO> queryImageData(Long projectId) {
        ImageDataVO imageDataVO = this.projectOverViewService.queryAllImageData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6240\u6709\u9879\u76ee\u5f71\u50cf\u7ba1\u7406\u56fe\u7247\u6210\u529f\uff01", (Object)imageDataVO);
    }

    @RequestMapping(value={"/queryImageList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ImageListVO>> queryImageList(Long projectId, String startDate, String endDate) {
        List<ImageListVO> imageListVOS = this.projectOverViewService.queryImageList(projectId, startDate, endDate);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u5f71\u50cf\u5217\u8868\u6570\u636e\u6210\u529f\uff01", imageListVOS);
    }

    @RequestMapping(value={"/queryLogInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LogDataVO> queryLogInfo(Long projectId, Long orgId) {
        LogDataVO logDataVO = this.projectOverViewService.queryLogInfo(projectId, orgId);
        return CommonResponse.success((String)"\u67e5\u8be2\u65bd\u5de5\u65e5\u5fd7\u6570\u91cf\u6570\u636e\u6210\u529f\uff01", (Object)logDataVO);
    }

    @RequestMapping(value={"/queryPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanDataVO> queryPlanData(Long projectId) {
        PlanDataVO planDataVO = this.projectOverViewService.queryPlanData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8ba1\u5212\u6570\u636e\u6210\u529f\uff01", (Object)planDataVO);
    }

    @RequestMapping(value={"/queryUserInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserInfoVO>> queryUserInfo(@RequestBody QueryParam param) {
        QueryParam projectParam = new QueryParam();
        if (param.getParams().containsKey("orgId")) {
            projectParam.getParams().put("projectDepartmentId", new Parameter("eq", ((Parameter)param.getParams().get("orgId")).getValue()));
            param.getParams().remove("orgId");
        }
        projectParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        projectParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List projectSetEntities = this.projectSetService.queryList(projectParam);
        if (ListUtil.isNotEmpty((List)projectSetEntities)) {
            param.getParams().put("xmlxId", new Parameter("eq", (Object)((ProjectSetEntity)((Object)projectSetEntities.get(0))).getId()));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<UserInfoVO> userInfoVO = this.projectOverViewService.queryUserInfo((Page<UserInfoVO>)page, param);
        page.setRecords(userInfoVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u62a5\u5907\u4eba\u5458\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryAchieveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AchieveData> queryAchieveData(Long projectId) {
        AchieveData achieveData = this.projectOverViewService.queryAchieveData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u679c\u7ba1\u7406\u5956\u9879\u6570\u636e\u6210\u529f\uff01", (Object)achieveData);
    }

    @RequestMapping(value={"/queryPaymentRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentRegisterData> queryPaymentRegisterData(Long projectId) {
        PaymentRegisterData paymentRegisterData = this.projectOverViewService.queryPaymentRegisterData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u67e5\u8be2\u5404\u7c7b\u652f\u4ed8\u6570\u636e\u6210\u529f\uff01", (Object)paymentRegisterData);
    }

    @RequestMapping(value={"/queryStartDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryStartDate(Long projectId) {
        Map<String, String> map = this.projectOverViewService.queryStartDate(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8fdb\u5ea6\u7ba1\u7406\u603b\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3001\u7ed3\u675f\u65f6\u95f4\u3001\u9879\u76ee\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/queryRectificationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RectificationVO> queryRectificationData(Long projectId) {
        RectificationVO rectificationVO = this.projectOverViewService.queryRectificationData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6574\u6539\u901a\u77e5\u5355\u3001\u56de\u590d\u5355\u6570\u636e\u6210\u529f\uff01", (Object)rectificationVO);
    }

    @RequestMapping(value={"/queryProjectRelateInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryProjectRelateInfo(Long projectId) {
        Map<String, Object> map = this.projectOverViewService.queryProjectRelateInfo(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u76f8\u5173\u65b9\u6bcf\u65e5\u4fe1\u606f\u586b\u62a5\u6570\u636e\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/queryProjectRiskLevel"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RiskAssessLatestVO> queryProjectRiskLevel(Long projectId) {
        RiskAssessLatestVO latestVO = this.projectOverViewService.queryProjectRiskLevel(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u65bd\u5de5\u98ce\u9669\u7efc\u5408\u8bc4\u4ef7\u98ce\u9669\u7ea7\u522b\u6210\u529f\uff01", (Object)latestVO);
    }

    @RequestMapping(value={"/queryDangerProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryDangerProjectData(Long projectId) {
        Map<String, String> map = this.projectOverViewService.queryDangerProjectData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u65bd\u5de5\u98ce\u9669\u7efc\u5408\u8bc4\u4ef7\u98ce\u9669\u7ea7\u522b\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/querySettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse querySettleData(Long projectId) {
        Map<String, String> map = this.projectOverViewService.querySettleData(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u65bd\u5de5\u98ce\u9669\u7efc\u5408\u8bc4\u4ef7\u98ce\u9669\u7ea7\u522b\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/queryStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> queryStatistics(@RequestParam(value="orgId") Long orgId, @RequestParam(value="dateIn") Integer dateIn) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("projectId", new Parameter("ne", (Object)643021352342790201L));
        String startDatePlan = DateFormatUtils.format((java.util.Date)DateUtil.beginOfMonth((java.util.Date)new java.util.Date()), (String)"yyyy-MM-dd");
        String endDatePlan = DateFormatUtils.format((java.util.Date)DateUtil.endOfMonth((java.util.Date)new java.util.Date()), (String)"yyyy-MM-dd");
        param.getParams().put("statDatePlan", new Parameter("between", (Object)(startDatePlan + "," + endDatePlan)));
        List<MonthlyStatisticsVO> monthlyStatistics = this.projectOverViewService.getStatisticsByOrgIdUnder(param);
        List<MonthlyStatisticsVO> G9OutputPlanList = this.getG9OutputPlanList(startDatePlan, endDatePlan);
        monthlyStatistics.addAll(G9OutputPlanList);
        ArrayList resultList = new ArrayList();
        BigDecimal rangeMny = monthlyStatistics.stream().map(MonthlyStatisticsVO::getByjhwcczPlan).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "\u603b\u8ba1\u5212\u4ea7\u503c");
        map.put("num", monthlyStatistics.size() + "");
        map.put("mny", rangeMny + "");
        resultList.add(map);
        List listRange1 = monthlyStatistics.stream().filter(s -> s.getByjhwcczPlan() != null && s.getByjhwcczPlan().compareTo(BigDecimal.ZERO) >= 0 && s.getByjhwcczPlan().compareTo(FIVE_MILLION) < 0).collect(Collectors.toList());
        BigDecimal rangeMny1 = listRange1.stream().map(MonthlyStatisticsVO::getByjhwcczPlan).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "0\u5230500\u4e07");
        map1.put("num", listRange1.size() + "");
        map1.put("mny", rangeMny1 + "");
        resultList.add(map1);
        List listRange2 = monthlyStatistics.stream().filter(s -> s.getByjhwcczPlan() != null && s.getByjhwcczPlan().compareTo(FIVE_MILLION) >= 0 && s.getByjhwcczPlan().compareTo(TEN_MILLION) < 0).collect(Collectors.toList());
        BigDecimal rangeMny2 = listRange2.stream().map(MonthlyStatisticsVO::getByjhwcczPlan).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "500\u52301000\u4e07");
        map2.put("num", listRange2.size() + "");
        map2.put("mny", rangeMny2 + "");
        resultList.add(map2);
        List listRange3 = monthlyStatistics.stream().filter(s -> s.getByjhwcczPlan() != null && s.getByjhwcczPlan().compareTo(TEN_MILLION) >= 0).collect(Collectors.toList());
        BigDecimal rangeMny3 = listRange3.stream().map(MonthlyStatisticsVO::getByjhwcczPlan).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("name", "1000\u4e07\u4ee5\u4e0a");
        map3.put("num", listRange3.size() + "");
        map3.put("mny", rangeMny3 + "");
        resultList.add(map3);
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u8fdb\u5ea6\u660e\u7ec6\u6210\u529f\uff01", resultList);
    }

    public List<MonthlyStatisticsVO> getG9OutputPlanList(String startDate, String endDate) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.logger.info("\u8fde\u63a5\u6210\u529f1");
        }
        catch (Exception e) {
            this.logger.info("\u8fde\u63a5\u5931\u8d251");
        }
        String connectionUrl = "jdbc:sqlserver://172.16.1.242:1433;databaseName=master;user=sa;password=Zzyj2015;";
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<MonthlyStatisticsVO> G9MonthlyPlanVOS = new ArrayList<MonthlyStatisticsVO>();
        try {
            Connection con = DriverManager.getConnection(connectionUrl);
            this.logger.info("\u8fde\u63a5\u6210\u529f2");
            Calendar date = Calendar.getInstance();
            String SQL = "SELECT\n* \nFROM\n(\nSELECT\nDATEADD( mm, ( F_TJNF - 1900 ) * 12+F_YF - 1, 0 ) AS stat_date_plan,\nF_JE AS byjhwccz_plan \nFROM\n[gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZJH] \nWHERE\nF_DEPT_ID NOT IN ( 22754 ) \nAND F_STATE IN ( 1, 3 ) \n) as x where stat_date_plan between '" + startDate + "' and '" + endDate + "'";
            stmt = con.createStatement();
            rs = stmt.executeQuery(SQL);
            while (rs.next()) {
                MonthlyStatisticsVO G9MonthlyPlanVO = new MonthlyStatisticsVO();
                BigDecimal byjhwcczPlan = rs.getBigDecimal("byjhwccz_plan");
                Date statDatePlan = rs.getDate("stat_date_plan");
                G9MonthlyPlanVO.setByjhwcczPlan(byjhwcczPlan);
                G9MonthlyPlanVO.setStatDatePlan((java.util.Date)statDatePlan);
                G9MonthlyPlanVOS.add(G9MonthlyPlanVO);
            }
            con.close();
        }
        catch (SQLException e) {
            this.logger.info("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8868\u540d" + e + ".\u8fde\u63a5\u5931\u8d252");
        }
        return G9MonthlyPlanVOS;
    }

    @RequestMapping(value={"/queryOutPutValueByQuarter"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> queryOutPutValueByQuarter(@RequestParam(value="orgId") Long orgId, @RequestParam(value="dateIn") Integer dateIn) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("projectId", new Parameter("ne", (Object)643021352342790201L));
        String startMonth = "-01-01";
        String endMonth = "-12-31";
        String startDate = dateIn + startMonth;
        String endDate = dateIn + endMonth;
        param.getParams().put("statDate", new Parameter("between", (Object)(startDate + "," + endDate)));
        List<MonthlyStatisticsVO> monthlyStatistics = this.projectOverViewService.getStatisticsByOrgIdUnder(param);
        List<MonthlyStatisticsVO> G9OutputValueList = this.getG9OutputValueList(startDate, endDate);
        monthlyStatistics.addAll(G9OutputValueList);
        ArrayList resultList = new ArrayList();
        BigDecimal rangeMny = monthlyStatistics.stream().map(MonthlyStatisticsVO::getBywccz).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "\u5b9e\u9645\u4ea7\u503c");
        map.put("num", monthlyStatistics.size() + "");
        map.put("mny", rangeMny + "");
        resultList.add(map);
        List listRange1 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null && ProjectOverViewController.getYearQuarterIndex(s.getStatDate()) == 1).collect(Collectors.toList());
        BigDecimal rangeMny1 = listRange1.stream().map(MonthlyStatisticsVO::getBywccz).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "\u7b2c1\u5b63\u5ea6");
        map1.put("num", listRange1.size() + "");
        map1.put("mny", rangeMny1 + "");
        resultList.add(map1);
        List listRange2 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null && ProjectOverViewController.getYearQuarterIndex(s.getStatDate()) == 2).collect(Collectors.toList());
        BigDecimal rangeMny2 = listRange2.stream().map(MonthlyStatisticsVO::getBywccz).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "\u7b2c2\u5b63\u5ea6");
        map2.put("num", listRange2.size() + "");
        map2.put("mny", rangeMny2 + "");
        resultList.add(map2);
        List listRange3 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null && ProjectOverViewController.getYearQuarterIndex(s.getStatDate()) == 3).collect(Collectors.toList());
        BigDecimal rangeMny3 = listRange3.stream().map(MonthlyStatisticsVO::getBywccz).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("name", "\u7b2c3\u5b63\u5ea6");
        map3.put("num", listRange3.size() + "");
        map3.put("mny", rangeMny3 + "");
        resultList.add(map3);
        List listRange4 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null && ProjectOverViewController.getYearQuarterIndex(s.getStatDate()) == 4).collect(Collectors.toList());
        BigDecimal rangeMny4 = listRange4.stream().map(MonthlyStatisticsVO::getBywccz).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map4 = new HashMap<String, String>();
        map4.put("name", "\u7b2c4\u5b63\u5ea6");
        map4.put("num", listRange4.size() + "");
        map4.put("mny", rangeMny4 + "");
        resultList.add(map4);
        return CommonResponse.success((String)"\u6839\u636e\u5b63\u5ea6\u67e5\u8be2\u5b9e\u9645\u4ea7\u503c\u6210\u529f\uff01", resultList);
    }

    public List<MonthlyStatisticsVO> getG9OutputValueList(String startDate, String endDate) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.logger.info("\u8fde\u63a5\u6210\u529f1");
        }
        catch (Exception e) {
            this.logger.info("\u8fde\u63a5\u5931\u8d251");
        }
        String connectionUrl = "jdbc:sqlserver://172.16.1.242:1433;databaseName=master;user=sa;password=Zzyj2015;";
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<MonthlyStatisticsVO> G9MonthlyPlanVOS = new ArrayList<MonthlyStatisticsVO>();
        try {
            Connection con = DriverManager.getConnection(connectionUrl);
            this.logger.info("\u8fde\u63a5\u6210\u529f2");
            Calendar date = Calendar.getInstance();
            String SQL = "SELECT\n* \nFROM\n(\nSELECT\nDATEADD( mm, ( F_TJNF - 1900 ) * 12+F_YF - 1, 0 ) AS stat_date,\nF_JE AS bywccz \nFROM\n[gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZTJ] \nWHERE\nF_DEPT_ID NOT IN ( 22754 ) \nAND F_STATE IN ( 1, 3 ) \n) as x where stat_date between '" + startDate + "' and '" + endDate + "'";
            stmt = con.createStatement();
            rs = stmt.executeQuery(SQL);
            while (rs.next()) {
                MonthlyStatisticsVO G9MonthlyPlanVO = new MonthlyStatisticsVO();
                BigDecimal byjhwcczPlan = rs.getBigDecimal("bywccz");
                Date statDate = rs.getDate("stat_date");
                G9MonthlyPlanVO.setBywccz(byjhwcczPlan);
                G9MonthlyPlanVO.setStatDate((java.util.Date)statDate);
                G9MonthlyPlanVOS.add(G9MonthlyPlanVO);
            }
            con.close();
        }
        catch (SQLException e) {
            this.logger.info("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8868\u540d" + e + ".\u8fde\u63a5\u5931\u8d252");
        }
        return G9MonthlyPlanVOS;
    }

    public static int getYearQuarterIndex(java.util.Date date) {
        int month = ProjectOverViewController.getYearMonthIndex(date);
        if (month <= 3) {
            return 1;
        }
        if (month <= 6) {
            return 2;
        }
        if (month <= 9) {
            return 3;
        }
        return 4;
    }

    public static int getYearMonthIndex(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    @RequestMapping(value={"/queryPracticeImgList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPracticeImgList(Long projectId) {
        ImageDataVO imageDataVO = new ImageDataVO();
        JSONObject resJSON = new JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
        List<PracticeVO> practiceList = this.projectOverViewService.getPracticeList(queryParam);
        List ids = practiceList.stream().map(BaseVO::getId).collect(Collectors.toList());
        Map voMap = practiceList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceIds", ids);
        CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(jsonObject);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            ArrayList pathData = new ArrayList();
            for (PracticeVO vo : practiceList) {
                for (AttachmentVO attachmentVO : data) {
                    if (!vo.getId().equals(attachmentVO.getSourceId()) || !"practicePhotoFile".equals(attachmentVO.getSourceType())) continue;
                    this.logger.info("\u5f71\u50cfid{},\u56fe\u7247id{}", (Object)vo.getId(), (Object)attachmentVO.getSourceId());
                    String suffix = attachmentVO.getFileName().substring(attachmentVO.getFileName().lastIndexOf(".") + 1);
                    if (!"jpg".equals(suffix) && !"png".equals(suffix) && !"JPG".equals(suffix) && !"PNG".equals(suffix)) continue;
                    HashMap<String, String> pathMap = new HashMap<String, String>();
                    pathMap.put("name", ((PracticeVO)voMap.get(attachmentVO.getSourceId())).getId().toString());
                    pathMap.put("path", attachmentVO.getTruePath());
                    pathData.add(pathMap);
                }
            }
            imageDataVO.setPathMap(pathData);
        }
        resJSON.put("imgData", (Object)imageDataVO);
        resJSON.put("total", (Object)practiceList.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u65bd\u5de5\u98ce\u9669\u7efc\u5408\u8bc4\u4ef7\u98ce\u9669\u7ea7\u522b\u6210\u529f\uff01", (Object)resJSON);
    }
}

