/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.IHomePortalApi;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.enums.CapitalStatusEnum;
import com.ejianc.business.market.bean.CloseCostEntity;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.mapper.CloseCostMapper;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.business.market.vo.TargetCostFitDTO;
import com.ejianc.business.outputvalcount.api.IOutputValueApi;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.business.receipt.api.IReceiptRegisterApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="closeCostService")
public class CloseCostServiceImpl
extends BaseServiceImpl<CloseCostMapper, CloseCostEntity>
implements ICloseCostService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IProjectPoolApi projectPoolApi;
    private final IProjectSetApi projectSetApi;
    private final IFinishWorkReportService finishWorkReportService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IHomePortalApi iHomePortalApi;
    @Autowired
    private IOutputValueApi iOutputValueApi;
    @Autowired
    private IReceiptRegisterApi iReceiptRegisterApi;
    @Autowired
    private ISettlePoolApi iSettlePoolApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi iReceiptAndPaymentRegisterApi;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private IProincomeContractApi iProincomeContractApi;
    private static final String INDEX_EX_CONTRACTT = "ex_contractt";
    private static final String INDEX_srSGHTTZYL = "srglsghttj";
    @Autowired(required=false)
    private RestHighLevelClient client;

    public CloseCostServiceImpl(IProjectPoolApi projectPoolApi, IProjectSetApi projectSetApi, IFinishWorkReportService finishWorkReportService) {
        this.projectPoolApi = projectPoolApi;
        this.projectSetApi = projectSetApi;
        this.finishWorkReportService = finishWorkReportService;
    }

    @Override
    public void autoCloseCost() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", request.getHeader("authority"));
        headers.put("ejc-token", request.getHeader("ejc-token"));
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        CompletableFuture.runAsync(() -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            QueryParam param = new QueryParam();
            param.setPageIndex(1);
            param.setPageSize(-1);
            param.getParams().put("capitalStatus", new Parameter("ne", (Object)CapitalStatusEnum.\u6210\u672c\u5173\u95e8.getCode()));
            String body = ((HttpRequest)HttpRequest.post((String)(this.BaseHost + "ejc-share-web/api/projectPool/queryProjectIPage")).addHeaders((Map)headers)).body(JSON.toJSONString((Object)param)).timeout(60000).execute().body();
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)body, JSONObject.class);
            JSONObject data = (JSONObject)jsonObject.get((Object)"data");
            JSONArray records = (JSONArray)data.get((Object)"records");
            this.logger.info("\u67e5\u8be2\u9879\u76ee\u6c60\u7528\u65f6\u300c{}\u300d\u79d2", (Object)stopwatch.stop().elapsed(TimeUnit.SECONDS));
            stopwatch.reset().start();
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                ArrayList<Long> projectIds = new ArrayList<Long>();
                for (Object record : records) {
                    JSONObject json = (JSONObject)record;
                    projectIds.add(Long.parseLong(String.valueOf(json.get((Object)"id"))));
                }
                List<Long> ids = this.finishWorkReportService.queryCanCloseCostProjectIds(projectIds);
                if (CollectionUtils.isNotEmpty(ids)) {
                    this.logger.info("ids\uff1a{}", ids);
                    for (Long projectId : ids) {
                        HashMap<String, Object> paramMaps = new HashMap<String, Object>();
                        paramMaps.put("projectId", projectId);
                        paramMaps.put("capitalStatus", CapitalStatusEnum.\u6210\u672c\u5173\u95e8.getCode());
                        String responseBody = ((HttpRequest)HttpUtil.createGet((String)(this.BaseHost + "ejc-share-web/api/projectPoolSetApi/changeProjectStatus")).addHeaders((Map)headers)).form(paramMaps).execute().body();
                        CommonResponse res = (CommonResponse)JSON.parseObject((String)responseBody, CommonResponse.class);
                        if (!res.isSuccess()) {
                            this.logger.info("\u81ea\u52a8\u6210\u672c\u5173\u95e8\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u9879\u76ee\u3010{}\u3011\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{projectId, CapitalStatusEnum.\u6210\u672c\u5173\u95e8, res.getMsg()});
                            continue;
                        }
                        ProjectSetEntity projectSetEntity = (ProjectSetEntity)((Object)((Object)this.projectSetService.selectById(projectId)));
                        if (projectSetEntity == null) continue;
                        projectSetEntity.setCapitalStatus(CapitalStatusEnum.\u6210\u672c\u5173\u95e8.getCode());
                        this.projectSetService.saveOrUpdate((Object)projectSetEntity);
                    }
                }
            }
            this.logger.info("\u81ea\u52a8\u5173\u95e8\u5904\u7406\u5b8c\u6210\u5171\u7528\u65f6\u300c{}\u300d\u79d2", (Object)stopwatch.stop().elapsed(TimeUnit.SECONDS));
        }, executorService);
        executorService.shutdown();
    }

    @Override
    public HashMap<String, BigDecimal> getDetailByProjectId(Long projectId) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        CommonResponse outputScale = this.iHomePortalApi.queryOutputScale(projectId);
        JSONObject jsonObject = (JSONObject)outputScale.getData();
        BigDecimal proIncomeMny = BigDecimal.ZERO;
        List<ContractRegisterVO> registerVOS = ((CloseCostMapper)this.baseMapper).queryProIncome(projectId);
        if (ListUtil.isNotEmpty(registerVOS)) {
            for (ContractRegisterVO vo : registerVOS) {
                proIncomeMny = proIncomeMny.add(vo.getNicContractMny());
            }
        }
        result.put("\u5408\u540c\u603b\u4ef7(\u5408\u7ea6\u90e8)", proIncomeMny);
        List<JSONObject> totalContract = this.queryESContract(projectId, INDEX_srSGHTTZYL);
        BigDecimal totalChangeContractMny = BigDecimal.ZERO;
        BigDecimal totalQuoteMny = BigDecimal.ZERO;
        for (JSONObject contract : totalContract) {
            this.logger.info("\u65bd\u5de5\u5408\u540c\u5c65\u7ea6\u60c5\u51b5\u53f0\u8d26\u6570\u636e1==========JSONObject{}", (Object)contract);
            this.logger.info("\u65bd\u5de5\u5408\u540c\u5c65\u7ea6\u60c5\u51b5\u53f0\u8d26\u6570\u636e2==========JSONString{}", (Object)contract.toJSONString());
            BigDecimal base = contract.getBigDecimal("base");
            BigDecimal contractMny = contract.getBigDecimal("contractMny");
            BigDecimal changeContractMny = base.subtract(contractMny);
            totalChangeContractMny = totalChangeContractMny.add(changeContractMny);
            BigDecimal quoteMny = contract.getBigDecimal("quoteMny");
            totalQuoteMny = totalQuoteMny.add(quoteMny);
        }
        result.put("\u5408\u540c\u53d8\u66f4\u534f\u8bae(\u7532\u65b9\u7b7e\u7ae0)(\u5408\u7ea6\u90e8)", totalChangeContractMny);
        result.put("\u7ed9\u7532\u65b9\u62a5\u91cf(\u6216\u8005\u7ed9\u7532\u65b9\u62a5\u9001\u7684\u51b3\u7b97\u91d1\u989d)", totalQuoteMny);
        BigDecimal finalizedMny = BigDecimal.ZERO;
        FinalizedVO finalizedVO = ((CloseCostMapper)this.baseMapper).queryFinalized(projectId);
        if (finalizedVO != null) {
            finalizedMny = finalizedVO.getCheckTaxMny();
        }
        result.put("\u5de5\u7a0b\u7ed3\u7b97\u5b9a\u6848\u91d1\u989d", finalizedMny);
        BigDecimal paymentMny = BigDecimal.ZERO;
        CommonResponse queryRecMnyByProjectId = this.iReceiptRegisterApi.queryRecMnyByProjectId(projectId);
        if (queryRecMnyByProjectId.getData() != null) {
            paymentMny = (BigDecimal)queryRecMnyByProjectId.getData();
        }
        result.put("\u5df2\u6536\u5efa\u8bbe\u5355\u4f4d\u5de5\u7a0b\u6b3e(\u8d44\u91d1+\u62b5\u8d26+\u5176\u4ed6)", paymentMny);
        return result;
    }

    @Override
    public List<JSONObject> queryESContract(Long projectId, String index) {
        JSONObject result = new JSONObject();
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (INDEX_EX_CONTRACTT.equals(index)) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (Object)projectId));
        } else if (INDEX_srSGHTTZYL.equals(index)) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"pId", (Object)projectId));
        }
        searchRequest.source(sourceBuilder);
        searchRequest.source().size(1000);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u53c2\u6570   sourceBuilder------------------\uff1a" + JSON.toJSONString((Object)sourceBuilder));
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570  searchRequest------------------\uff1a", (Object)searchRequest);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                this.logger.info("----------------ES\u83b7\u53d6\u6570\u636e\u4e3a--------------\uff1a{}", (Object)sourceAsString);
                result = JSON.parseObject((String)sourceAsString);
                if (result.getBigDecimal("lu:yueqianfujine") != null) {
                    result.put("luyueqianfujine", (Object)result.getBigDecimal("lu:yueqianfujine"));
                }
                resultList.add(result);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u6839\u636e\u67e5\u8be2\u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return resultList;
    }

    @Override
    public Page<CloseCostReportVO> queryReportList(QueryParam param) {
        String[] split = null;
        if (param.getParams().containsKey("proProFitPer")) {
            String proProFitPer = ((Parameter)param.getParams().get("proProFitPer")).getValue().toString();
            split = proProFitPer.split(",");
            param.setPageSize(500);
            param.setPageIndex(1);
            param.getParams().remove("proProFitPer");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<CloseCostReportVO> closeCostReportVOS = ((CloseCostMapper)this.baseMapper).queryReportList((Page<CloseCostReportVO>)page, wrapper);
        CommonResponse apiDefDocByDefCode = this.defdocApi.getDefDocByDefCode("pro-market-project-engineeringType");
        Map<Object, Object> map = new HashMap();
        if (apiDefDocByDefCode.isSuccess()) {
            List data = (List)apiDefDocByDefCode.getData();
            map = data.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName));
        }
        ArrayList<CloseCostReportVO> closeCostReporList = new ArrayList<CloseCostReportVO>();
        for (CloseCostReportVO closeCostReportVO : closeCostReportVOS) {
            String name = (String)map.get(closeCostReportVO.getEngineeringTypeId());
            if (!StrUtil.isNotBlank((CharSequence)name)) continue;
            closeCostReportVO.setEngineeringTypeName(name);
            Long projectId = closeCostReportVO.getProjectId();
            BigDecimal proIncomeMny = BigDecimal.ZERO;
            List<ContractRegisterVO> registerVOS = ((CloseCostMapper)this.baseMapper).queryProIncome(projectId);
            if (ListUtil.isNotEmpty(registerVOS)) {
                for (ContractRegisterVO vo : registerVOS) {
                    proIncomeMny = proIncomeMny.add(vo.getNicContractMny());
                }
                closeCostReportVO.setProProFitPer(proIncomeMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).divide(proIncomeMny, 2).multiply(new BigDecimal(100)).setScale(2, 4));
                closeCostReportVO.setProProFit(proIncomeMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).setScale(2, 4));
            }
            BigDecimal finalizedMny = BigDecimal.ZERO;
            FinalizedVO finalizedVO = ((CloseCostMapper)this.baseMapper).queryFinalized(projectId);
            if (finalizedVO != null) {
                finalizedMny = finalizedVO.getCheckTaxMny();
                closeCostReportVO.setProProFitPer(finalizedMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).divide(finalizedMny, 2).multiply(new BigDecimal(100)).setScale(2, 4));
                closeCostReportVO.setProProFit(finalizedMny.subtract(closeCostReportVO.getTotalEstimatedPayMny()).setScale(2, 4));
            }
            BigDecimal recMny = BigDecimal.ZERO;
            CommonResponse queryRecMnyByProjectId = this.iReceiptRegisterApi.queryRecMnyByProjectId(projectId);
            if (queryRecMnyByProjectId.getData() != null) {
                recMny = (BigDecimal)queryRecMnyByProjectId.getData();
            }
            closeCostReportVO.setNicContractMny(proIncomeMny);
            closeCostReportVO.setFinalizedMny(finalizedMny);
            closeCostReportVO.setReceiveMny(recMny);
            if (split == null || closeCostReportVO.getProProFitPer().compareTo(new BigDecimal(split[0])) <= -1 || closeCostReportVO.getProProFitPer().compareTo(new BigDecimal(split[1])) != -1) continue;
            closeCostReporList.add(closeCostReportVO);
        }
        if (split != null) {
            page.setRecords(closeCostReporList);
            page.setTotal((long)closeCostReporList.size());
        } else {
            page.setRecords(closeCostReportVOS);
        }
        return page;
    }

    @Override
    public TargetCostFitDTO getTargetReportFit(Long projectId) {
        return ((CloseCostMapper)this.baseMapper).getTargetReportFit(projectId);
    }
}

