/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.project.mapper;

import com.ejianc.business.project.bean.ProjectInfoEntity;
import com.ejianc.business.project.vo.ProjectChangeNumVO;
import com.ejianc.business.project.vo.ProjectInfoVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface ProjectInfoMapper
extends BaseCrudMapper<ProjectInfoEntity> {
    public List<UserInfoVO> getUserInfoByProjectId(Long var1);

    public ProjectInfoVO getOutputvalueInfoByProjectId(Long var1);

    @Select(value={"SELECT count(*) FROM `ejc-technologymanage`.`v_technologymanage_all`\nwhere gcxmmc_id = #{project}"})
    public Long getTechnologyNumByProjectId(Long var1);

    @Select(value={"SELECT case when isnull(SUM(contract_tax_mny)) then 0 else SUM(contract_tax_mny) end as labsub_contract_tax_mny,COUNT(*) labsub_count FROM `ejc-prosub`.`ejc_prosub_contract`\nwhere project_id = #{project}\nand dr=0\nand bill_state in (1,3)\nand contract_type = 0"})
    public ProjectInfoVO getLabsubByProjectId(Long var1);

    @Select(value={"SELECT case when isnull(SUM(contract_tax_mny)) then 0 else SUM(contract_tax_mny) end as prosub_contract_tax_mny,COUNT(*) prosub_count FROM `ejc-prosub`.`ejc_prosub_contract`\nwhere project_id = #{project}\nand dr=0\nand bill_state in (1,3)\nand contract_type = 1"})
    public ProjectInfoVO getProsubByProjectId(Long var1);

    @Select(value={"SELECT case when isnull(SUM(contract_tax_mny)) then 0 else SUM(contract_tax_mny) end as rent_contract_tax_mny,COUNT(*) rent_count FROM `ejc-proequipment`.`ejc_proequipment_rent_contract`\nwhere project_id =  #{project}\nand dr=0\nand bill_state in (1,3)"})
    public ProjectInfoVO getRentByProjectId(Long var1);

    @Select(value={"SELECT COUNT(*) meeting_count FROM `zzyj-outputvalcount`.`t_outputvalcount_meeting_minutes`\nwhere department_id =  #{project}\nand dr=0\nand bill_state in (1,3)"})
    public ProjectInfoVO getMeetCountByProjectId(Long var1);

    @Select(value={"SELECT COUNT(*) build_person_count ,(SELECT COUNT(*) build_project_count FROM `ejc-probuilddiary`.`ejc_probuilddiary_project_log`\nwhere project_id =  #{project}\nand dr=0\nand bill_state in (1,3)) as build_project_count FROM `ejc-probuilddiary`.`ejc_probuilddiary_person`\nwhere project_id =  #{project}\nand dr=0\nand bill_state in (1,3)"})
    public ProjectInfoVO getBuildPersonCountByProjectId(Long var1);

    public ProjectChangeNumVO queryProjectStateChangeNum();

    public ProjectChangeNumVO queryProjectOutputValueInfo();

    public List<ProjectChangeNumVO> queryProjectOutputValueUnder100();

    public ProjectChangeNumVO queryProjectLogInfo();

    @Select(value={"select count(*) from `ejc-probuilddiary`.`ejc_probuilddiary_person` where dr = 0 and bill_state in (1,3)"})
    public String queryTotalPersonNum();

    @Select(value={"select count(*) from `ejc-probuilddiary`.`ejc_probuilddiary_project_log` where dr = 0 and bill_state in (1,3)"})
    public String queryTotalProjectNum();
}

