package com.ejianc.business.projectOverView.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.JsglViewVO;
import com.ejianc.business.constructor.vo.ProgramReportVO;

import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.danger.vo.DangerProjectVO;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.outputvalcount.vo.*;
import com.ejianc.business.plan.vo.TotalPlanVO;
import com.ejianc.business.probuilddiary.person.vo.PersonVO;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.business.project.mapper.ProjectInfoMapper;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.business.projectOverView.mapper.ProjectOverViewMapper;
import com.ejianc.business.projectOverView.service.IProjectOverViewService;
import com.ejianc.business.projectOverView.vo.*;
import com.ejianc.business.projectmanage.vo.PracticeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.qualisafe.vo.CheckVO;
import com.ejianc.business.qualisafe.vo.RectificationNoticeVO;
import com.ejianc.business.qualisafe.vo.RectificationRepeatVO;
import com.ejianc.business.quality.vo.GccymbsdVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.riskManage.vo.RiskAssessLatestVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.technology.vo.YjDetailVO;
import com.ejianc.business.utils.DifferentMonth;
import com.ejianc.business.worklog.vo.PersonLogVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.joda.time.format.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目一览门户
 *
 * @author generator
 */
@Service("projectOverViewService")
public class ProjectOverViewServiceImpl implements IProjectOverViewService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ProjectOverViewMapper projectOverViewMapper;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;

    @Autowired
    private IProjectSetService projectSetService;

    @Override
    public FaDataVO queryFaData(Long projectId) {

        FaDataVO faDataVO = new FaDataVO();
        //查询项目的所有方案计划及方案
        List<JsglViewVO> jsglViewVOS = projectOverViewMapper.queryFaData(projectId, null);
        List<ProgramReportVO> reportVOList = projectOverViewMapper.queryFaPlanData(projectId, null);
        //根据类型分类统计数量
        Map<String, Long> faNumMap = new HashMap<>();
        Map<String, Long> faPlanNumMap = new HashMap<>();
        if (ListUtil.isNotEmpty(jsglViewVOS)) {
            faNumMap = jsglViewVOS.stream().collect(Collectors.groupingBy(JsglViewVO::getTags, Collectors.counting()));
            faDataVO.setProgramNum(jsglViewVOS.size());
            faDataVO.setProgramNumMap(faNumMap);
        } else {
            faDataVO.setProgramNum(0);
        }
        if (ListUtil.isNotEmpty(reportVOList)) {
            faPlanNumMap = reportVOList.stream().collect(Collectors.groupingBy(ProgramReportVO::getTags, Collectors.summingLong(ProgramReportVO::getPlanNum)));
            long filterNum = reportVOList.stream().filter(s -> !(s.getTags().equals("技术中心审核方案"))).count();
            faDataVO.setProgramPlanNumMap(faPlanNumMap);
            faDataVO.setProgramPlanNum(reportVOList.size());
            faDataVO.setFilterNum(filterNum);
        } else {
            faDataVO.setProgramPlanNum(0);
        }

        return faDataVO;
    }

    @Override
    public QualityAndSafeDataVO queryCheckData(Long projectId) {
        List<CheckVO> checkVOS = projectOverViewMapper.queryQualityCheckData(projectId);
        QualityAndSafeDataVO qualityAndSafeDataVO = new QualityAndSafeDataVO();

        List<CheckVO> qualityVOS = checkVOS.stream().filter(s -> s.getCheckType().equals("质量")).collect(Collectors.toList());
        List<CheckVO> safeVOS = checkVOS.stream().filter(s -> s.getCheckType().equals("安全")).collect(Collectors.toList());

        Date date = new Date();
        if (ListUtil.isNotEmpty(qualityVOS)) {
            BigDecimal score = qualityVOS.stream()
                    .map(CheckVO::getScore)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            Integer count = qualityVOS.size();
            if (count != 0) {
                BigDecimal avgScore = score.divide(new BigDecimal(count), 2, BigDecimal.ROUND_HALF_UP);
                qualityAndSafeDataVO.setQualityScore(avgScore);
            } else {
                qualityAndSafeDataVO.setQualityScore(BigDecimal.ZERO);

            }
            qualityAndSafeDataVO.setQualityVOS(qualityVOS);
        }
        if (ListUtil.isNotEmpty(safeVOS)) {
            qualityAndSafeDataVO.setSafeVOS(safeVOS);
            BigDecimal score = safeVOS.stream()
                    .map(CheckVO::getScore)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            Integer count = safeVOS.size();
            if (count != 0) {
                BigDecimal avgScore = score.divide(new BigDecimal(count), 2, BigDecimal.ROUND_HALF_UP);
                qualityAndSafeDataVO.setSafeScore(avgScore);
            } else {
                qualityAndSafeDataVO.setSafeScore(BigDecimal.ZERO);
            }
            qualityAndSafeDataVO.setSafeVOS(safeVOS);
        }

        List<RentParameterVO> rentParameterVOS = projectOverViewMapper.queryLargeEquipment(projectId);
        if (ListUtil.isNotEmpty(rentParameterVOS)) {
            qualityAndSafeDataVO.setLargeEquipmentNum(rentParameterVOS.size());
        }
        return qualityAndSafeDataVO;
    }

    @Override
    public MeetingMinutesDataVO queryMeetingMinutesData(Long projectId) {
        List<MeetingMinutesVO> meetingMinutesVOS = projectOverViewMapper.queryMeetingMinutesData(projectId);
        MeetingMinutesDataVO meetingMinutesDataVO = new MeetingMinutesDataVO();
        if (ListUtil.isNotEmpty(meetingMinutesVOS)) {
            meetingMinutesDataVO.setNum(meetingMinutesVOS.size());
        }
        return meetingMinutesDataVO;
    }

    @Override
    public GccymbsdVO queryTarget(Long projectId) {
        return projectOverViewMapper.queryTarget(projectId);
    }

    @Override
    public ImageDataVO queryImageData(Long projectId, String dateStr) {
        List<XmyxglVO> xmyxglVOS = new ArrayList<>();
        ImageDataVO imageDataVO = new ImageDataVO();
        /**
         * 解析日期数据
         */
        try {
            Date date = new SimpleDateFormat("yyyy-MM").parse(dateStr);
            Calendar ca = Calendar.getInstance();
            ca.setTime(date);
            int year = ca.get(Calendar.YEAR);
            int month = ca.get(Calendar.MONTH) + 1;
            xmyxglVOS = projectOverViewMapper.queryImageData(projectId, year, month);
            MonthlyStatisticsVO monthlyStatistics = projectOverViewMapper.queryMonthlyStatistics(projectId, year, month);
            if (monthlyStatistics != null) {
                imageDataVO.setMonthlyStatisticsVO(monthlyStatistics);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (ListUtil.isNotEmpty(xmyxglVOS)) {
            /**
             * 获取项目影像管理的文件，并只留下jpg和png格式的路径
             */
            //图片sourceId
            List<Long> ids = xmyxglVOS.stream().map(XmyxglVO::getId).collect(Collectors.toList());
            Map<Long, XmyxglVO> voMap = xmyxglVOS.stream().collect(Collectors.toMap(XmyxglVO::getId, Function.identity()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceIds", ids);
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(jsonObject);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                List<Map<String, String>> pathData = new ArrayList<>();
                for (AttachmentVO attachmentVO : data) {
                    String suffix = attachmentVO.getFileName().substring(attachmentVO.getFileName().lastIndexOf(".") + 1);
                    if ("jpg".equals(suffix) || "png".equals(suffix) || "JPG".equals(suffix) || "PNG".equals(suffix)) {
                        HashMap<String, String> pathMap = new HashMap<>();
                        pathMap.put("name", voMap.get(attachmentVO.getSourceId()).getYxmc());
                        pathMap.put("path", attachmentVO.getTruePath());
                        pathData.add(pathMap);
                    }

                }
                imageDataVO.setPathMap(pathData);
                imageDataVO.setXmyxglVOS(xmyxglVOS);
            }
        }


        return imageDataVO;
    }

    @Override
    public ImageDataVO queryAllImageData(Long projectId) {
        List<XmyxglVO> xmyxglVOS = new ArrayList<>();
        ImageDataVO imageDataVO = new ImageDataVO();

        xmyxglVOS = projectOverViewMapper.queryAllImageData(projectId);
        if (ListUtil.isNotEmpty(xmyxglVOS)) {
            /**
             * 获取项目影像管理的文件，并只留下jpg和png格式的路径
             */
            //图片sourceId
            List<Long> ids = xmyxglVOS.stream().map(XmyxglVO::getId).collect(Collectors.toList());
            Map<Long, XmyxglVO> voMap = xmyxglVOS.stream().collect(Collectors.toMap(XmyxglVO::getId, Function.identity()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceIds", ids);
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(jsonObject);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                List<Map<String, String>> pathData = new ArrayList<>();
                for (XmyxglVO xmyxglVO : xmyxglVOS) {
                    for (AttachmentVO attachmentVO : data) {
                        if(xmyxglVO.getId().equals(attachmentVO.getSourceId())){
                            logger.info("影像id{},图片id{}",xmyxglVO.getId(),attachmentVO.getSourceId());
                            String suffix = attachmentVO.getFileName().substring(attachmentVO.getFileName().lastIndexOf(".") + 1);
                            if ("jpg".equals(suffix) || "png".equals(suffix) || "JPG".equals(suffix) || "PNG".equals(suffix)) {
                                HashMap<String, String> pathMap = new HashMap<>();
                                pathMap.put("name", voMap.get(attachmentVO.getSourceId()).getYxmc());
                                pathMap.put("path", attachmentVO.getTruePath());
                                pathData.add(pathMap);
                            }
                        }
                    }
                }
                imageDataVO.setPathMap(pathData);
                imageDataVO.setXmyxglVOS(xmyxglVOS);
            }
        }


        return imageDataVO;
    }

    @Override
    public List<ImageListVO> queryImageList(Long projectId, String startDate, String endDate) {

        List<ImageListVO> imageListVOS = new ArrayList<>();
        //获取项目起止日期之间的所有月份
        List<String> monthBetweenDate = DifferentMonth.getMonthBetweenDate(startDate, endDate);
        for (String dateStr : monthBetweenDate) {
            ImageListVO imageListVO = new ImageListVO();
            Date date = null;
            List<XmyxglVO> xmyxglVOS = new ArrayList<>();
            try {
                date = new SimpleDateFormat("yyyy-MM").parse(dateStr);
                Calendar ca = Calendar.getInstance();
                ca.setTime(date);
                int year = ca.get(Calendar.YEAR);
                int month = ca.get(Calendar.MONTH) + 1;
                xmyxglVOS = projectOverViewMapper.queryImageData(projectId, year, month);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            imageListVO.setDate(dateStr);
            if (ListUtil.isNotEmpty(xmyxglVOS)) {
                imageListVO.setCount(xmyxglVOS.size());
            } else {
                imageListVO.setCount(0);
            }
            imageListVOS.add(imageListVO);

        }
        return imageListVOS;
    }

    @Override
    public LogDataVO queryLogInfo(Long projectId, Long orgId) {

        LogDataVO logDataVO = new LogDataVO();

        /**
         * 查询组织下管人员数量、岗位数量、岗位人员数量
         */
//        List<Long> postIds = new ArrayList<>();
//        postIds.add(1502571443093770242L);//项目施工员
//        postIds.add(1502571442879860738L);//项目技术负责人
//        postIds.add(1502571443056021505L);//质检员
//        postIds.add(1502571443018272770L);//项目安全员
//        postIds.add(1502571443131518978L);//项目材料管理员
//        postIds.add(1502571443223793666L);//项目设备管理员
//        postIds.add(1502571443261542402L);//项目取送样员
//        postIds.add(1502571442980524034L);//项目资料员
        List<Long> orgIds = new ArrayList<>();
        orgIds.add(orgId);

//        if (employeeByPostAndOrg.isSuccess()) {
//            List<EmployeeVO> employeeVOS = employeeByPostAndOrg.getData();
//            if (ListUtil.isNotEmpty(employeeVOS)) {
//                logDataVO.setProjectManageNum(employeeVOS.size());
//            } else {
//                logDataVO.setProjectManageNum(0);
//            }
//        }

        CommonResponse<List<Map<String, Object>>> userApiEmployeeList = userApi.getEmployeeList(orgId);
        if (userApiEmployeeList.isSuccess()) {
            List<Map<String, Object>> maps = userApiEmployeeList.getData();
            Set<Long> userIds = new HashSet<>();
            Set<Long> postIds = new HashSet<>();
            for (Map<String, Object> map : maps) {
                if ("1".equals(map.get("state").toString())) {
                    if(map.get("userId") != null){
                        userIds.add(Long.valueOf(map.get("userId").toString()));
                    }
                    if(map.get("postId") != null){
                        postIds.add(Long.valueOf(map.get("postId").toString()));
                    }
                }

            }
            logDataVO.setPostNum(postIds.size());
            logDataVO.setUserNum(userIds.size());
            logDataVO.setUserPostNum(maps.size());

        }
        /**
         * 当天个人日志数量、个人日志总数量
         */
        List<PersonVO> personLogVOS = projectOverViewMapper.queryPersonLog(projectId);
        if (ListUtil.isNotEmpty(personLogVOS)) {
            logDataVO.setPersonLogTotalNum(personLogVOS.size());
            //筛选出当天的施工日志数量
            List<PersonVO> todayPersonLogVOS = new ArrayList<>();
            for (PersonVO personLogVO : personLogVOS) {
                Date informantDate = personLogVO.getInformantDate();
                Calendar informantCalendar = Calendar.getInstance();
                informantCalendar.setTime(informantDate);
                Date date = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);

                if (informantCalendar.get(Calendar.YEAR) == calendar.get(Calendar.YEAR) &&
                        informantCalendar.get(Calendar.MONTH) == calendar.get(Calendar.MONTH) &&
                        informantCalendar.get(Calendar.DAY_OF_MONTH) == calendar.get(Calendar.DAY_OF_MONTH)) {
                    todayPersonLogVOS.add(personLogVO);
                }
            }
            if (ListUtil.isNotEmpty(todayPersonLogVOS)) {
                logDataVO.setPersonLogTodayNum(todayPersonLogVOS.size());
            }
        } else {
            logDataVO.setPersonLogTotalNum(0);
            logDataVO.setPersonLogTodayNum(0);
        }
        /**
         *  项目日志总数量
         */
        List<ProjectLogVO> projectLogVOS = projectOverViewMapper.queryProjectLog(projectId, null);
        if (ListUtil.isNotEmpty(projectLogVOS)) {
            logDataVO.setProjectLogTotalNum(projectLogVOS.size());
        } else {
            logDataVO.setProjectLogTotalNum(0);
        }
        /**
         * 项目日志日期条，显示是否有项目日志
         */
        List<Map<String, String>> projectLogListMap = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

        //当前月有几天
        int days = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        for (int i = 0; i < days; i++) {
            //遍历当月日期
            Calendar monthDay = Calendar.getInstance();
            monthDay.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), i + 1);
            String formatDate = simpleDateFormat.format(monthDay.getTime());
            //根据项目id和日期取查询项目日志
            List<ProjectLogVO> toDayProjectLogVO = projectOverViewMapper.queryProjectLog(projectId, formatDate);
            Map<String, String> map = new HashMap<>();
            map.put("date", formatDate);
            if (ListUtil.isNotEmpty(toDayProjectLogVO)) {
                map.put("id", toDayProjectLogVO.get(0).getId().toString());
            } else {
                map.put("id", null);
            }
            projectLogListMap.add(map);
        }
        logDataVO.setProjectLogList(projectLogListMap);
        return logDataVO;
    }

    @Override
    public PlanDataVO queryPlanData(Long projectId) {
        Integer totalPlanData = projectOverViewMapper.queryTotalPlanData(projectId);
        Integer yearPlanData = projectOverViewMapper.queryYearPlanData(projectId);
        Integer monthPlanData = projectOverViewMapper.queryMonthPlanData(projectId);
        Integer weekPlanData = projectOverViewMapper.queryWeekPlanData(projectId);
        PlanDataVO planDataVO = new PlanDataVO();
        planDataVO.setTotalPlanNum(totalPlanData);
        planDataVO.setYearPlanNum(yearPlanData);
        planDataVO.setMonthPlanNum(monthPlanData);
        planDataVO.setWeekPlanNum(weekPlanData);
        return planDataVO;
    }

    @Override
    public List<ZjllVO> queryUserInfo(Page<ZjllVO> page, QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        return projectOverViewMapper.getUserInfoByProjectId(page, wrapper);
    }

    @Override
    public AchieveData queryAchieveData(Long projectId) {
        List<YjDetailVO> yjDetailVOS = projectOverViewMapper.queryYjDetailList(projectId);
        AchieveData achieveData = new AchieveData();
        if (ListUtil.isNotEmpty(yjDetailVOS)) {
            Map<String, Long> collect = yjDetailVOS.stream().collect(Collectors.groupingBy(YjDetailVO::getTags, Collectors.counting()));
            achieveData.setAchieveNumMap(collect);
        }
        return achieveData;
    }

    @Override
    public PaymentRegisterData queryPaymentRegisterData(Long projectId) {
        PaymentRegisterData paymentRegisterData = new PaymentRegisterData();


        CommonResponse<JSONObject> subResponse = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.劳务分包合同.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setLaborSub(subResponse.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> contractAC = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.安拆合同.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractAC(contractAC.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> contractConcrete = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.混凝土合同.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractConcrete(contractConcrete.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> contractMaterial = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.物资采购合同.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractMaterial(contractMaterial.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> contractOther = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.其他支出.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractOther(contractOther.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> equipmentPurchase = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.设备采购.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setEquipmentPurchase(equipmentPurchase.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> equipmentRent = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.设备租赁.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setEquipmentRent(equipmentRent.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> equipmentTemp = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.临时设备.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setEquipmentTemp(equipmentTemp.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> proSub = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.专业分包合同.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setProSub(proSub.getData().getBigDecimal("payMny"));
        }
        CommonResponse<JSONObject> rmat = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.周转材合同.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setRmat(rmat.getData().getBigDecimal("payMny"));
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        CommonResponse<JSONObject> mny = receiptAndPaymentRegisterApi.queryReceiptAndPaymentMny(queryParam);
        if (mny.isSuccess()) {
            JSONObject mnyData = mny.getData();
            paymentRegisterData.setTotalPayment(mnyData.getBigDecimal("payMny"));
            paymentRegisterData.setTotalReceive(mnyData.getBigDecimal("sumReceivedMny"));
        }
        return paymentRegisterData;
    }

    @Override
    public Map<String, String> queryStartDate(Long projectId) {
        Map<String, String> map = new HashMap<>();
        ProjectSetEntity projectSetEntity = projectSetService.selectById(projectId);
        TotalPlanVO totalPlanVO = projectOverViewMapper.queryTotalPlanVO(projectId);
        //如果有开工时间则以开工时间为准，否则使用实际开始施工时间
        Date trueStartDate = projectSetEntity.getStartWorkDate() != null ? projectSetEntity.getStartWorkDate() : projectSetEntity.getTrueStartDate();
        Date nowDate = new Date();

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (trueStartDate != null) {
            map.put("trueStartDate", sdf.format(trueStartDate));
            int trueDays = DateUtil.daysBetween(trueStartDate, nowDate);
            map.put("trueDays", trueDays + "");
        }
        if (totalPlanVO != null) {
            map.put("planBeginDate", sdf.format(totalPlanVO.getPlanBeginDate()));
            map.put("planEndDate", sdf.format(totalPlanVO.getPlanEndDate()));
            int totalDays = DateUtil.daysBetween(totalPlanVO.getPlanBeginDate(), totalPlanVO.getPlanEndDate());
            int planDays = DateUtil.daysBetween(totalPlanVO.getPlanBeginDate(), nowDate);
            map.put("totalDays", totalDays + "");
            map.put("planDays", planDays + "");
            map.put("finishFlag", totalPlanVO.getFinishFlag() != null ?
                    totalPlanVO.getFinishFlag().toString() : "");
        }
        return map;
    }

    @Override
    public RectificationVO queryRectificationData(Long projectId) {
        List<RectificationNoticeVO> noticeVOS = projectOverViewMapper.queryNoticeList(projectId);
        RectificationVO rectificationVO = new RectificationVO();
        if (ListUtil.isNotEmpty(noticeVOS)) {
            rectificationVO.setQualityNoticeNum(noticeVOS.stream().filter(s -> s.getRectificationType().equals("1")).count());
            rectificationVO.setSafeNoticeNum(noticeVOS.stream().filter(s -> s.getRectificationType().equals("2")).count());
        }
        List<RectificationRepeatVO> repeatVOS = projectOverViewMapper.queryRepeatList(projectId);
        if (ListUtil.isNotEmpty(repeatVOS)) {
            rectificationVO.setQualityRepeatNum(repeatVOS.stream().filter(s -> s.getRectificationType().equals("1")).count());
            rectificationVO.setSafeRepeatNum(repeatVOS.stream().filter(s -> s.getRectificationType().equals("2") && s.getRepeatStatus().equals("2")).count());
        }
        return rectificationVO;
    }

    @Override
    public Map<String, Object> queryProjectRelateInfo(Long projectId) {
        Map<String, Object> map = new HashMap<>();
        List<ProjectInfoRegisterVO> registerVOS = projectOverViewMapper.queryProjectInfoRegisterList(projectId);
        List<Long> ids = registerVOS.stream().map(ProjectInfoRegisterVO::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(ids)) {
            //上级单位检查
            List<ProjectInfoRegisterExamineVO> examineVOS = projectOverViewMapper.queryProjectInfoExamineList(ids);
            //合同纠纷异常
            List<ProjectInfoRegisterDisputeVO> disputeVOS = projectOverViewMapper.queryProjectInfoDisputeList(ids);
            //其他协同异常
            List<ProjectInfoRegisterCommunicationVO> communicationVOS = projectOverViewMapper.queryProjectInfoCommunicationList(ids);

            long examineNoticeNum = examineVOS.stream().filter(s -> "1".equals(s.getExamineState())).count();
            long examineRepeatNum = examineVOS.stream().filter(s -> "1".equals(s.getExamineState()) &&
                    "结束".equals(s.getTreatmentProgress())).count();
            long communicationEnd = communicationVOS.stream().filter(s -> "结束".equals(s.getComplaintProgress())).count();
            map.put("relateNoticeNum", examineNoticeNum + communicationVOS.size());
            map.put("relateRepeatNum", examineRepeatNum + communicationEnd);
            long examineEnd = examineVOS.stream().filter(s -> "结束".equals(s.getTreatmentProgress())).count();
            long disputeEnd = disputeVOS.stream().filter(s -> "结束".equals(s.getDisputeProgress())).count();
            long relateTotalRepeatNum = examineEnd+disputeEnd+communicationEnd;
            long relateTotalNoticeNum = examineVOS.size()+disputeVOS.size()+communicationVOS.size();
            map.put("relateTotalNoticeNum",  relateTotalNoticeNum - relateTotalRepeatNum);
            map.put("relateTotalRepeatNum", relateTotalRepeatNum);
        }
        return map;
    }

    @Override
    public RiskAssessLatestVO queryProjectRiskLevel(Long projectId) {
        //默认施工风险
//        Long indexId = 700359149730537529L;
        Long indexId = 700358634707755064L;
        RiskAssessLatestVO latestVO = projectOverViewMapper.queryProjectRiskLevel(projectId, indexId);
        return latestVO;
    }

    @Override
    public Map<String, String> queryDangerProjectData(Long projectId) {
        List<DangerProjectVO> dangerProjectList = projectOverViewMapper.getDangerProjectList(projectId);
        Map<String, String> map = new HashMap<>();
        map.put("totalDangerNum","0");
        map.put("finishDangerNum","0");
        if(ListUtil.isNotEmpty(dangerProjectList)){
            long finishDangerNum = dangerProjectList.stream().filter(s -> "1".equals(s.getIsFinish())).count();
            map.put("totalDangerNum",dangerProjectList.size()+"");//总数量
            map.put("finishDangerNum", Long.toString(finishDangerNum));//完成数量
//            map.put("otherDangerNum", Long.toString(otherDangerNum));//超出计划完成时间仍未完成的数量
            /**
             * 2024-4-29 更改为计划范围内未完成的数量
             */
            long otherDangerNum = dangerProjectList.stream()
                    .filter(s -> "2".equals(s.getIsFinish())
                            && s.getEstimateImplDate().before(new Date())
//                            && s.getEstimateFinishDate().after(new Date())
                    )
                    .count();
            map.put("otherDangerNum", Long.toString(otherDangerNum));//计划完成时间仍未完成的数量
        }
        return map;
    }

    @Override
    public Map<String, String> querySettleData(Long projectId) {
        /**
         * 劳务分包结算
         */
        List<SettleVO> laborSubSettleList = projectOverViewMapper.queryLaborSubSettle(projectId, null);
        //月度结算
        List<SettleVO> progressSettleList = laborSubSettleList.stream().filter(s -> s.getSettleType() == 0).collect(Collectors.toList());
        //节点结算
        List<SettleVO> nodeSettleList = laborSubSettleList.stream().filter(s -> s.getSettleType() == 2).collect(Collectors.toList());
        //最终结算
        List<SettleVO> finalSettleList = laborSubSettleList.stream().filter(s -> s.getSettleType() == 1).collect(Collectors.toList());;

        /**
         * 物资、混凝土结算
         */
        List<SettlementVO> materialSettleList = projectOverViewMapper.queryMaterialSettle(projectId, null);

        //物资过程结算
        List<SettlementVO> materialProgressSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 0
                && s.getSettlementType() == 0).collect(Collectors.toList());
        //物资最终结算
        List<SettlementVO> materialFinalSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 1
                && s.getSettlementType() == 0).collect(Collectors.toList());


        //混凝土过程结算
        List<SettlementVO> concreteProgressSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 0
                && s.getSettlementType() == 1).collect(Collectors.toList());
        //混凝土节点结算
        List<SettlementVO> concreteFinalSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 1
                && s.getSettlementType() == 1).collect(Collectors.toList());

        /**
         * 周转材结算
         */
        List<com.ejianc.business.pro.rmat.vo.SettleVO> rmatSettleList = projectOverViewMapper.queryRmatSettle(projectId, null);
        //周转材过程结算
        List<com.ejianc.business.pro.rmat.vo.SettleVO> rmatProgressSettleList = rmatSettleList.stream().filter(s -> "0".equals(s.getSettleType())).collect(Collectors.toList());
        //周转材最终结算
        List<com.ejianc.business.pro.rmat.vo.SettleVO> rmatFinalSettleList = rmatSettleList.stream().filter(s -> "1".equals(s.getSettleType())).collect(Collectors.toList());

        Map<String, String> map = new HashMap<>();

        /**
         * 劳务结算金额
         */
        BigDecimal laborSettleTaxMny = laborSubSettleList.stream().filter(s -> s.getTaxMny() != null).map(SettleVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        /**
         * 材料结算金额
         */
        BigDecimal materialTaxMny = materialSettleList.stream().filter(s -> s.getSettlementTaxMny() != null).map(SettlementVO::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal rmatTaxMny = rmatSettleList.stream().filter(s -> s.getSettleTaxMny() != null).map(com.ejianc.business.pro.rmat.vo.SettleVO::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        map.put("progressSettleNum",progressSettleList.size()+"");
        map.put("nodeSettleNum",nodeSettleList.size()+"");
        map.put("finalSettleNum",finalSettleList.size()+"");
        map.put("laborSettleTaxMny",laborSettleTaxMny.toString());


        map.put("materialProgressSettleNum",materialProgressSettleList.size()+"");
        map.put("materialFinalSettleNum",materialFinalSettleList.size()+"");
        map.put("materialTaxMny",materialTaxMny.toString());

        map.put("concreteProgressSettleNum",concreteProgressSettleList.size()+"");
        map.put("concreteFinalSettleNum",concreteFinalSettleList.size()+"");

        map.put("rmatProgressSettleNum",rmatProgressSettleList.size()+"");
        map.put("rmatFinalSettleNum",rmatFinalSettleList.size()+"");
        map.put("rmatTaxMny",rmatTaxMny.toString());

        return map;
    }

    @Override
    public List<MonthlyStatisticsVO> getStatisticsByOrgIdUnder(QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        return projectOverViewMapper.getStatisticsByOrgIdUnder(wrapper);
    }
    @Override
    public List<PracticeVO> getPracticeList(QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        return projectOverViewMapper.getPracticeList(wrapper);
    }
}
