package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.bean.StartWorkReportEntity;
import com.ejianc.business.enums.BusinessStatusEnum;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.service.IStartWorkReportService;
import com.ejianc.foundation.share.api.IProjectSetApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("startWorkReport")
public class StartWorkReportBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IStartWorkReportService service;

	@Autowired
	private IProjectSetApi iProjectSetApi;

	@Autowired
	private IProjectSetService projectSetService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**
		 * 根据登记类型推送项目基本信息：
		 * 		0.业务状态改为在施，记录开工报告来源id
		 * 		1.实际开始施工
		 * 			1.1推送实际开始施工日期，
		 * 			1.2推送开工手续进展为无
		 * 		2.开工令
		 * 			2.1推送开工日期
		 * 			2.3推送开工手续进展为开工令
		 * 		3.施工许可证
		 * 			3.1推送开工手续详情为进展描述
		 * 			3.2办理状态
		 * 				3.2.1已办理-推送开工手续进展为施工许可证
		 * 				3.2.2其他-推送开工手续进展为无
		 */
		StartWorkReportEntity entity = service.selectById(billId);
		iProjectSetApi.changeProjectBusinessStatus(entity.getProjectId(), BusinessStatusEnum.在施.getCode());
		logger.info("推送项目基本信息开始------------");
		ProjectSetEntity projectSetEntity = projectSetService.selectById(entity.getProjectId());
		logger.info("开工报告信息为entity{}------------",JSON.toJSONString(entity));
		if(projectSetEntity != null){
			projectSetEntity.setBusinessStatus(BusinessStatusEnum.在施.getCode());
			projectSetEntity.setStartReportId(entity.getId());
			if("1".equals(entity.getStartWorkType())){
				projectSetEntity.setTrueStartDate(entity.getTrueStartDate());
				projectSetEntity.setChangeStatusDate(entity.getTrueStartDate());//状态改变时间
				projectSetEntity.setStartReportProgress("1");
			} else if("2".equals(entity.getStartWorkType())){
				projectSetEntity.setStartWorkDate(entity.getStartWorkDate());
				projectSetEntity.setChangeStatusDate(entity.getStartWorkDate());//状态改变时间
				projectSetEntity.setStartReportProgress("2");
			} else if("3".equals(entity.getStartWorkType())){
				projectSetEntity.setStartReportDetail(entity.getPermitProgressDescription());
				if("3".equals(entity.getPermitProgress())){
					projectSetEntity.setStartReportProgress("3");
					//是否办理四库、目标业绩等级
					projectSetEntity.setLibFlag("是");
					projectSetEntity.setPlanLibLevel(entity.getPlanLibLevel());
				} else {
					projectSetEntity.setStartReportProgress("1");
				}
			}


		}
		projectSetService.saveOrUpdate(projectSetEntity);
		logger.info("推送项目基本信息为projectSetEntity{}------------", JSON.toJSONString(projectSetEntity));
		logger.info("推送项目基本信息结束------------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("开工报告不允许撤回！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseProjectUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息
			StartWorkReportEntity entity = service.selectById(billId);

			ProjectSetEntity projectSetEntity = projectSetService.selectById(entity.getProjectId());

			Long patrolManager = projectSetEntity.getPatrolManager();
			String patrolManagerName = projectSetEntity.getPatrolManagerName();

			logger.info("userId:{}",patrolManager);
			logger.info("userName:{}",patrolManagerName);

			JSONObject jsonObject = new JSONObject();
			jsonObject.put("userId",patrolManager);
			jsonObject.put("userName",patrolManagerName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}
}
