package com.ejianc.business.project.controller;

import java.io.Serializable;

import com.ejianc.business.project.mapper.ProjectInfoMapper;
import com.ejianc.business.project.service.IProjectInfoService;
import com.ejianc.business.project.vo.ProjectChangeNumVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.project.bean.ProjectInfoEntity;
import com.ejianc.business.project.vo.ProjectInfoVO;

/**
 * 项目信息统计表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectInfo")
public class ProjectInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IProjectInfoService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectInfoVO> saveOrUpdate(@RequestBody ProjectInfoVO saveOrUpdateVO) {
    	ProjectInfoEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectInfoEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                //entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ProjectInfoVO vo = BeanMapper.map(entity, ProjectInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectInfoVO> queryDetail(Long id) {
    	ProjectInfoEntity entity = service.selectById(id);
    	ProjectInfoVO vo = BeanMapper.map(entity, ProjectInfoVO.class);
    	//报备人员信息
        List<UserInfoVO> userInfoByProjectId = service.getUserInfoByProjectId(id);
        vo.setUserInfoVOS(userInfoByProjectId);
        //产值进度信息
        ProjectInfoVO outputvalueInfoByProjectId = service.getOutputvalueInfoByProjectId(id);
        if (outputvalueInfoByProjectId!= null) {
            vo.setKgwccz(outputvalueInfoByProjectId.getKgwccz());
            vo.setYxId(outputvalueInfoByProjectId.getYxId());
        }else {
            vo.setKgwccz("0");
            vo.setYxId(0L);
        }

        //方案信息
        Long technologyNumByProjectId = service.getTechnologyNumByProjectId(id);
        vo.setTechnologyNum(technologyNumByProjectId);
        //工程造价
        //劳务专业分包合同金额,份数
        ProjectInfoVO labsubByProjectId = service.getLabsubByProjectId(id);
        ProjectInfoVO prosubByProjectId = service.getProsubByProjectId(id);
        vo.setLabsubContractTaxMny(labsubByProjectId.getLabsubContractTaxMny());
        vo.setLabsubCount(labsubByProjectId.getLabsubCount());
        vo.setProsubContractTaxMny(prosubByProjectId.getProsubContractTaxMny());
        vo.setProsubCount(prosubByProjectId.getProsubCount());
        //设备租赁合同金额，份数
        ProjectInfoVO rentByProjectId = service.getRentByProjectId(id);
        vo.setRentContractTaxMny(rentByProjectId.getRentContractTaxMny());
        vo.setRentCount(rentByProjectId.getRentCount());
        //监理纪要个数
        ProjectInfoVO meetCountByProjectId = service.getMeetCountByProjectId(id);
        vo.setMeetingCount(meetCountByProjectId.getMeetingCount());
        //施工日志个人个数，施工日志项目个数
        ProjectInfoVO buildPersonCountByProjectId = service.getBuildPersonCountByProjectId(id);
        vo.setBuildPersonCount(buildPersonCountByProjectId.getBuildPersonCount());
        vo.setBuildProjectCount(buildPersonCountByProjectId.getBuildProjectCount());

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectInfoVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectInfoVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ProjectInfoEntity> page = service.queryPage(param,false);
        IPage<ProjectInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
       List<ProjectInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjecInfo-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjecInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectInfoVO>> refProjecInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                  String condition,
                                                                  String searchObject,
                                                                  String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectInfoEntity> page = service.queryPage(param,false);
        IPage<ProjectInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectInfoVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




@Autowired
private ProjectInfoMapper mapper;
    /**
     * @Description queryDetail 工程部门户获取近一个月项目状态变化个数 projectInfo
     * @param
     */
    @RequestMapping(value = "/queryProjectStateChangeNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectChangeNumVO> queryProjectStateChangeNum() {
        ProjectChangeNumVO projectChangeNumVO = mapper.queryProjectStateChangeNum();
        ProjectChangeNumVO projectChangeNumVO1 = mapper.queryProjectOutputValueInfo();
        ProjectChangeNumVO projectChangeNumVO2 = mapper.queryProjectLogInfo();

        projectChangeNumVO.setMonthValue(projectChangeNumVO1.getMonthValue());
        projectChangeNumVO.setMonthProjectNum(projectChangeNumVO1.getMonthProjectNum());
        projectChangeNumVO.setMonthProjectNumUnder80(projectChangeNumVO1.getMonthProjectNumUnder80());

        projectChangeNumVO.setProjectNum(projectChangeNumVO2.getProjectNum());
        projectChangeNumVO.setLeaderNum(projectChangeNumVO2.getLeaderNum());
        projectChangeNumVO.setNoUpload(projectChangeNumVO2.getNoUpload());
        projectChangeNumVO.setPersonMonth(projectChangeNumVO2.getPersonMonth());
        projectChangeNumVO.setProjectMonth(projectChangeNumVO2.getProjectMonth());
        projectChangeNumVO.setPersonTotal(mapper.queryTotalPersonNum());
        projectChangeNumVO.setPersonTotal(mapper.queryTotalProjectNum());
        return CommonResponse.success("查询详情数据成功！",projectChangeNumVO);
    }
    /**
     * @Description queryDetail 当月产值100万以下项目清单 projectInfo
     * @param
     */
    @RequestMapping(value = "/queryProjectOutputValueUnder100", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse< List<ProjectChangeNumVO>> queryProjectOutputValueUnder100() {
        List<ProjectChangeNumVO> projectChangeNumVOS = mapper.queryProjectOutputValueUnder100();

        return CommonResponse.success("查询详情数据成功！",projectChangeNumVOS);
    }
}
