package com.ejianc.business.market.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author sunxy
 * @date 2023/4/14
 * @description 业务状态
 */
public enum BusinessStatusNewEnum {
	未开工("0"),
	在施("1"),
	停工("2"),
	复工("3"),
	待竣工("4"),
	项目中止("5"),
	竣工("6"),
	未决算("7"),
	决算中("8"),
	已决算("9"),
	资料未归档("10"),
	资料已归档("11"),
	缺陷责任期("12"),
	缺陷责任期结束("13"),
	开账正常("14"),
	资金冻结("15"),
	成本关门("16"),
	已销账("17");

	private final String code;

	BusinessStatusNewEnum(String code) {
		this.code = code;
	}

	public static Object getNameByCode(String businessStatus) {
		switch (businessStatus) {
			case "0":
				return "未开工";
			case "1":
				return "在施";
			case "2":
				return "停工";
			case "3":
				return "复工";
			case "4":
				return "待竣工";
			case "5":
				return "项目中止";
			case "6":
				return "竣工";
			case "7":
				return "未决算";
			case "8":
				return "决算中";
			case "9":
				return "已决算";
			case "10":
				return "资料未归档";
			case "11":
				return "资料已归档";
			case "12":
				return "缺陷责任期";
			case "13":
				return "缺陷责任期结束";
			case "14":
				return "开账正常";
			case "15":
				return "资金冻结";
			case "16":
				return "成本关门";
			case "17":
				return "已销账";
			default:
				return null;
		}

	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (BusinessStatusNewEnum businessStatusEnum : BusinessStatusNewEnum.values()) {
			if (name.equals(businessStatusEnum.toString())) {
				return businessStatusEnum.getCode();
			}
		}
		return null;
	}
}
