package com.ejianc.business.market.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.business.market.vo.TargetCostFitDTO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.market.bean.CloseCostEntity;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

/**
 * 成本关门
 *
 * @author baipengyan
 */
public interface ICloseCostService extends IBaseService<CloseCostEntity> {

	void autoCloseCost();

	HashMap<String, BigDecimal> getDetailByProjectId(Long projectId);

	List<JSONObject> queryESContract(Long projectId , String index);

	/**
	 * 查询成本关门台账
	 * @param param
	 * @return
	 */
	Page<CloseCostReportVO> queryReportList(QueryParam param);

	//获取目标、分析利润率
	TargetCostFitDTO getTargetReportFit(Long projectId);
}
