package com.ejianc.business.project.service;

import com.ejianc.business.project.vo.ProjectInfoVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.project.bean.ProjectInfoEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 项目信息统计表
 * 
 * @author generator
 * 
 */
public interface IProjectInfoService extends IBaseService<ProjectInfoEntity> {
    //查询报别人员情况
    List<UserInfoVO> getUserInfoByProjectId(Long project);

    //查询产值进度数据
    ProjectInfoVO getOutputvalueInfoByProjectId(Long project);

    //方案信息
    Long getTechnologyNumByProjectId(Long project);

    ProjectInfoVO getLabsubByProjectId(Long project);
    //专业分包合同金额,份数
    ProjectInfoVO getProsubByProjectId(Long project);
    //设备租赁合同金额，份数
    ProjectInfoVO getRentByProjectId(Long project);
    //监理纪要个数
    ProjectInfoVO getMeetCountByProjectId(Long project);
    //施工日志个人个数，施工日志项目个数
    ProjectInfoVO getBuildPersonCountByProjectId(Long project);
}
