/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.costplan.api.ICostPlanApi;
import com.ejianc.business.enums.CapitalStatusEnum;
import com.ejianc.business.market.bean.CloseCostEntity;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="closeCost")
public class CloseCostBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IProjectSetApi projectSetApi;
    private final IWarnCenterApi warnCenterApi;
    private final ICloseCostService service;
    @Value(value="${warning.code}")
    private String WARN_CODE;
    @Autowired
    private ICostPlanApi costPlanApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CloseCostBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, IProjectSetApi projectSetApi, IWarnCenterApi warnCenterApi, ICloseCostService service) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.projectSetApi = projectSetApi;
        this.warnCenterApi = warnCenterApi;
        this.service = service;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        CloseCostEntity entity = (CloseCostEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        CommonResponse res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), null, null, null, null, CapitalStatusEnum.\u6210\u672c\u5173\u95e8.getCode());
        if (!res.isSuccess()) {
            this.logger.info("\u6210\u672c\u5173\u95e8\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{entity.getBillCode(), CapitalStatusEnum.\u6210\u672c\u5173\u95e8, res.getMsg()});
            throw new BusinessException("\u6210\u672c\u5173\u95e8\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010" + CapitalStatusEnum.\u6210\u672c\u5173\u95e8 + "\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        this.sendMsg(entity);
        if (entity != null) {
            this.costPlanApi.updateFinishStateCostClose(entity.getProjectId(), entity.getId(), Integer.valueOf(1));
        }
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }

    private void sendMsg(CloseCostEntity entity) {
        CommonResponse response = this.warnCenterApi.getWarnSet(this.WARN_CODE, entity.getOrgId());
        this.logger.info("\u67e5\u8be2\u9884\u8b66\u4e2d\u5fc3\u8bbe\u7f6e\uff1a{}", (Object)JSONObject.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!response.isSuccess() || null == response.getData()) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u9884\u8b66\u4e2d\u5fc3\u8bbe\u7f6e\uff0c\u4e0d\u53d1\u9884\u8b66\uff01");
        } else {
            WarningDTO warningDTO = (WarningDTO)response.getData();
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setSourceId(String.valueOf(entity.getProjectId()));
            vo.setTenantId(entity.getTenantId());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setSendOrgId(String.valueOf(entity.getOrgId()));
            vo.setEarlywarnName(warningDTO.getName());
            vo.setBillName(entity.getBillName());
            vo.setEarlywarnContent(warningDTO.getWarningContentTemplate().replaceAll("#projectName#", entity.getProjectName()));
            vo.setWarnSetId(warningDTO.getId());
            vo.setWarnSetParamId(CollectionUtils.isNotEmpty((Collection)warningDTO.getWarningSetings()) ? ((CustomWarnSettingVO)warningDTO.getWarningSetings().get(0)).getId() : null);
            vo.setPcUrl("/ejc-promarket-frontend/#/closeCost/card");
            vo.setPcTitle("\u6210\u672c\u5173\u95e8");
            vo.setWarnLevel(CollectionUtils.isNotEmpty((Collection)warningDTO.getWarningSetings()) ? ((CustomWarnSettingVO)warningDTO.getWarningSetings().get(0)).getWarningLevel() : "\u4e2d");
            vo.setWarnType(String.valueOf(warningDTO.getWarnType()));
            ArrayList<EarlyWarnTransVO> warnTransVO = new ArrayList<EarlyWarnTransVO>();
            warnTransVO.add(vo);
            CommonResponse res = this.warnCenterApi.sendToWarnCenterByCode(warnTransVO, this.WARN_CODE);
            if (!res.isSuccess()) {
                this.logger.info("\u9884\u8b66\u5185\u5bb9\u53d1\u9001\u81f3\u9884\u8b66\u4e2d\u5fc3\u5931\u8d25\uff0c\u5177\u4f53\u53c2\u6570\uff1a{},\u9884\u8b66\u53c2\u6570\u7f16\u7801\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{JSONObject.toJSONString(warnTransVO), this.WARN_CODE, res.getMsg()});
            }
            this.logger.info("\u9884\u8b66\u4e2d\u5fc3\u54cd\u5e94\uff1a{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        }
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CloseCostEntity entity = (CloseCostEntity)((Object)this.service.selectById(billId));
        this.costPlanApi.updateFinishStateCostClose(entity.getProjectId(), entity.getId(), Integer.valueOf(0));
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            CloseCostEntity entity = (CloseCostEntity)((Object)this.service.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

