package com.ejianc.business.market.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.market.bean.G9ProjectDetailEntity;
/**
 * G9关门项目
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promarket_g9_project")
public class G9ProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="name")
    private String name; // 名称
    @TableField(value="bbh")
    private String bbh; // 版本号
    @TableField(value="sfqy")
    private Integer sfqy; // 是否启用
    @TableField(value="new_id")
    private Long newId; // 上级单位id
    @TableField(value="new_name")
    private String newName; // 上级单位名称
    @TableField(value="year")
    private Integer year; // 检查年份
    @TableField(value="season")
    private Integer season; // 检查季度
    @TableField(value="start_time")
    private Date startTime; // 开始时间
    @TableField(value="end_time")
    private Date endTime; // 结束时间
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="g9ProjectDetailService",pidName = "zhuId")
    private List<G9ProjectDetailEntity> g9ProjectDetailList = new ArrayList<>(); // G9关门项目明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getBbh() {
        return bbh;
    }

    public void setBbh(String bbh) {
        this.bbh = bbh;
    }
    public Integer getSfqy() {
        return sfqy;
    }

    public void setSfqy(Integer sfqy) {
        this.sfqy = sfqy;
    }
    public Long getNewId() {
        return newId;
    }

    public void setNewId(Long newId) {
        this.newId = newId;
    }
    public String getNewName() {
        return newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }
    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }
    public Integer getSeason() {
        return season;
    }

    public void setSeason(Integer season) {
        this.season = season;
    }
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    

    public List<G9ProjectDetailEntity> getG9ProjectDetailList() {
        return g9ProjectDetailList;
    }

    public void setG9ProjectDetailList(List<G9ProjectDetailEntity> g9ProjectDetailList) {
        this.g9ProjectDetailList = g9ProjectDetailList;
    }
}
