package com.ejianc.business.promaterial.contract.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 记录-合同其他费用实体
 * 
 * @author generator
 * 
 */
@ApiModel("记录-合同其他费用实体")
public class ContractRecordFeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("记录合同主键")
    private Long recordId;
    @ApiModelProperty("原合同子表主键")
    private Long contractFeeId;
    @ApiModelProperty("费用名称")
    private String feeName;
    @ApiModelProperty("是否来源补充协议(1:是，0：否)")
    private Integer srcSupplementFlag;
    @ApiModelProperty("来源补充协议主表ID")
    private Long srcSupplementId;
    @ApiModelProperty("来源补充协议明细ID")
    private Long srcSupplementDetailId;
    @ApiModelProperty("数量")
    private BigDecimal freeNum;
    @ApiModelProperty("单价")
    private BigDecimal freePrice;
    @ApiModelProperty("金额")
    private BigDecimal freeMoney;
    @ApiModelProperty("备注")
    private String freeMemo;
    @ApiModelProperty("税率")
    private BigDecimal freeTaxRate;
    @ApiModelProperty("税额")
    private BigDecimal freeTax;
    @ApiModelProperty("金额(含税)")
    private BigDecimal freeTaxMny;
    @ApiModelProperty("单价(含税)")
    private BigDecimal freeTaxPrice;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更子表主键")
    private Long changeBid;
    @ApiModelProperty("变更类型")
    private String changeType;
    private Long srcTblId; // 来源子表主键



    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }

    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 记录合同主键
     */
    public Long getRecordId() {
        return recordId;
    }

    /**
     * 记录合同主键
     */
    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    /**
     * 原合同子表主键
     */
    public Long getContractFeeId() {
        return contractFeeId;
    }

    /**
     * 原合同子表主键
     */
    public void setContractFeeId(Long contractFeeId) {
        this.contractFeeId = contractFeeId;
    }
    /**
     * 费用名称
     */
    public String getFeeName() {
        return feeName;
    }

    /**
     * 费用名称
     */
    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }
    /**
     * 来源补充协议主表ID
     */
    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    /**
     * 来源补充协议主表ID
     */
    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }
    /**
     * 来源补充协议明细ID
     */
    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    /**
     * 来源补充协议明细ID
     */
    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }
    /**
     * 数量
     */
    public BigDecimal getFreeNum() {
        return freeNum;
    }

    /**
     * 数量
     */
    public void setFreeNum(BigDecimal freeNum) {
        this.freeNum = freeNum;
    }
    /**
     * 单价
     */
    public BigDecimal getFreePrice() {
        return freePrice;
    }

    /**
     * 单价
     */
    public void setFreePrice(BigDecimal freePrice) {
        this.freePrice = freePrice;
    }
    /**
     * 金额
     */
    public BigDecimal getFreeMoney() {
        return freeMoney;
    }

    /**
     * 金额
     */
    public void setFreeMoney(BigDecimal freeMoney) {
        this.freeMoney = freeMoney;
    }
    /**
     * 备注
     */
    public String getFreeMemo() {
        return freeMemo;
    }

    /**
     * 备注
     */
    public void setFreeMemo(String freeMemo) {
        this.freeMemo = freeMemo;
    }
    /**
     * 税率
     */
    public BigDecimal getFreeTaxRate() {
        return freeTaxRate;
    }

    /**
     * 税率
     */
    public void setFreeTaxRate(BigDecimal freeTaxRate) {
        this.freeTaxRate = freeTaxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getFreeTax() {
        return freeTax;
    }

    /**
     * 税额
     */
    public void setFreeTax(BigDecimal freeTax) {
        this.freeTax = freeTax;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getFreeTaxMny() {
        return freeTaxMny;
    }

    /**
     * 金额(含税)
     */
    public void setFreeTaxMny(BigDecimal freeTaxMny) {
        this.freeTaxMny = freeTaxMny;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getFreeTaxPrice() {
        return freeTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setFreeTaxPrice(BigDecimal freeTaxPrice) {
        this.freeTaxPrice = freeTaxPrice;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 变更类型
     */
    public String getChangeType() {
        return changeType;
    }

    /**
     * 变更类型
     */
    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
    
}
