package com.ejianc.business.promaterial.out.vo;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 领料出库明细
 * 
 * @author generator
 * 
 */
@ApiModel("领料出库明细")
public class SubOutStoreDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表id")
    private Long outStoreId;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资分类id")
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialTypeCode")
    private Long materialCategoryId;
    @ApiModelProperty("材料分类编码")
    private String materialTypeCode;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("单位主键")
    private Long unitId;
    @ApiModelProperty("出库数量")
    private BigDecimal num;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("金额")
    private BigDecimal money;
    @ApiModelProperty("单价(含税)")
    private BigDecimal taxPrice;
    @ApiModelProperty("金额(含税)")
    private BigDecimal taxMoney;
    @ApiModelProperty("税额")
    private BigDecimal outTax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("库存可用数量")
    private BigDecimal storeNum;
    private Long sourceId; // 来源主键ID
    private Long sourceDetailId; // 来源明细主键ID
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    private BigDecimal surplusMny; // 上期结存金额
    private BigDecimal surplusTaxMny; // 上期结存金额(含税)
    private BigDecimal surplusPrice; // 库存均价
    private BigDecimal surplusTaxPrice; // 库存均价(含税)
    private BigDecimal stockNum; // 盘点数量
    private BigDecimal stockMoney; // 盘点金额
    private BigDecimal stockTaxMoney; // 盘点金额(含税)
    private BigDecimal subPrice; // 分包出库单价
    private BigDecimal subTaxMrice; // 分包出库单价(含税)
    private BigDecimal subMoney; // 分包出库金额
    private BigDecimal subTaxMoney; // 分包出库金额(含税)

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public BigDecimal getSurplusTaxMny() {
        return surplusTaxMny;
    }

    public void setSurplusTaxMny(BigDecimal surplusTaxMny) {
        this.surplusTaxMny = surplusTaxMny;
    }

    public BigDecimal getSurplusPrice() {
        return surplusPrice;
    }

    public void setSurplusPrice(BigDecimal surplusPrice) {
        this.surplusPrice = surplusPrice;
    }

    public BigDecimal getSurplusTaxPrice() {
        return surplusTaxPrice;
    }

    public void setSurplusTaxPrice(BigDecimal surplusTaxPrice) {
        this.surplusTaxPrice = surplusTaxPrice;
    }

    public BigDecimal getStockNum() {
        return stockNum;
    }

    public void setStockNum(BigDecimal stockNum) {
        this.stockNum = stockNum;
    }

    public BigDecimal getStockMoney() {
        return stockMoney;
    }

    public void setStockMoney(BigDecimal stockMoney) {
        this.stockMoney = stockMoney;
    }

    public BigDecimal getStockTaxMoney() {
        return stockTaxMoney;
    }

    public void setStockTaxMoney(BigDecimal stockTaxMoney) {
        this.stockTaxMoney = stockTaxMoney;
    }

    public BigDecimal getSubPrice() {
        return subPrice;
    }

    public void setSubPrice(BigDecimal subPrice) {
        this.subPrice = subPrice;
    }

    public BigDecimal getSubTaxMrice() {
        return subTaxMrice;
    }

    public void setSubTaxMrice(BigDecimal subTaxMrice) {
        this.subTaxMrice = subTaxMrice;
    }

    public BigDecimal getSubMoney() {
        return subMoney;
    }

    public void setSubMoney(BigDecimal subMoney) {
        this.subMoney = subMoney;
    }

    public BigDecimal getSubTaxMoney() {
        return subTaxMoney;
    }

    public void setSubTaxMoney(BigDecimal subTaxMoney) {
        this.subTaxMoney = subTaxMoney;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    /**
     * 主表id
     */
    public Long getOutStoreId() {
        return outStoreId;
    }

    /**
     * 主表id
     */
    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资分类id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 出库数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 出库数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 金额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 金额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    /**
     * 金额(含税)
     */
    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    /**
     * 税额
     */
    public BigDecimal getOutTax() {
        return outTax;
    }

    /**
     * 税额
     */
    public void setOutTax(BigDecimal outTax) {
        this.outTax = outTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 库存可用数量
     */
    public BigDecimal getStoreNum() {
        return storeNum;
    }

    /**
     * 库存可用数量
     */
    public void setStoreNum(BigDecimal storeNum) {
        this.storeNum = storeNum;
    }
    
}
