package com.ejianc.business.promaterial.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.promaterial.plan.vo.ApplyDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目材料申请
 * 
 * @author generator
 * 
 */
public class ApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String memo; // 备注
    private Integer addMaterialFlag; // 是否新增材料编码：0 否、1 是
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date billDate; // 编制日期
    private String deptName; // 经办部门名称
    private Long deptId; // 经办部门
    private String employeeName; // 编制人名称
    private Long employeeId; // 编制人
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long projectId; // 项目id
    private String parentOrgCode; // 组织编码
    private String parentOrgName; // 组织名称
    private Long parentOrgId; // 组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目部名称/区域名称
    private Long orgId; // 项目部主键
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    
    private List<ApplyDetailVO> detailList = new ArrayList<>(); // 项目材料申请-子表

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getAddMaterialFlag() {
        return addMaterialFlag;
    }

    public void setAddMaterialFlag(Integer addMaterialFlag) {
        this.addMaterialFlag = addMaterialFlag;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<ApplyDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ApplyDetailVO> detailList) {
        this.detailList = detailList;
    }
}
