package com.ejianc.business.promaterial.out.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 月度消耗汇总
 * 
 * @author generator
 * 
 */
public class MonthSumVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date sumDate; // 汇总月份
    private BigDecimal projectOutMny; // 项目消耗金额（无税）
    private BigDecimal projectOutTaxMny; // 项目消耗金额
    private BigDecimal outMny; // 本月消耗金额（无税）
    private BigDecimal outTaxMny; // 本月消耗金额
    private BigDecimal subOutMny; // 分包消耗金额（无税）
    private BigDecimal subOutTaxMny; // 分包消耗金额
    private String memo; // 备注
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private String projectName; // 
    private Long projectId; // 项目id
    private String projectCode; // 所属项目编码
    private Long orgId; // 组织id
    private String orgName; // 
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String parentOrgCode; // 项目部上级组织编码
    private String orgCode; // 项目部编码
    @TableField(value="business_type")
    private Long businessType; //业务类型
    @TableField(value="business_type_name")
    private String businessTypeName; //业务类型
    private List<MonthSumDetailVO> monthSumDetailList = new ArrayList<>(); // 月度消耗汇总-详情
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBusinessType() {
        return businessType;
    }
    @ReferDeserialTransfer
    public void setBusinessType(Long businessType) {
        this.businessType = businessType;
    }

    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getSumDate() {
        return sumDate;
    }

    public void setSumDate(Date sumDate) {
        this.sumDate = sumDate;
    }
    public BigDecimal getProjectOutMny() {
        return projectOutMny;
    }

    public void setProjectOutMny(BigDecimal projectOutMny) {
        this.projectOutMny = projectOutMny;
    }
    public BigDecimal getProjectOutTaxMny() {
        return projectOutTaxMny;
    }

    public void setProjectOutTaxMny(BigDecimal projectOutTaxMny) {
        this.projectOutTaxMny = projectOutTaxMny;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    public BigDecimal getSubOutMny() {
        return subOutMny;
    }

    public void setSubOutMny(BigDecimal subOutMny) {
        this.subOutMny = subOutMny;
    }
    public BigDecimal getSubOutTaxMny() {
        return subOutTaxMny;
    }

    public void setSubOutTaxMny(BigDecimal subOutTaxMny) {
        this.subOutTaxMny = subOutTaxMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    
     public List<MonthSumDetailVO> getMonthSumDetailList() {
        return monthSumDetailList;
     }

     public void setMonthSumDetailList(List<MonthSumDetailVO> monthSumDetailList) {
        this.monthSumDetailList = monthSumDetailList;
     }
}
