package com.ejianc.business.promaterial.contract.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 合同解除表
 * 
 * @author generator
 * 
 */
@ApiModel("合同解除表")
public class ContractRelieveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("项目部id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部所属组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门id")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("经办部门编码")
    private String departmentCode;
    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编码")
    private String contractCode;
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("甲方id")
    private Long firstPartyId;
    @ApiModelProperty("甲方名称")
    private String firstPartyName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("解除日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date relieveDate;
    @ApiModelProperty("解除原因")
    private String relieveCause;
    @ApiModelProperty("起草方式 1、上传解除协议，2、已签章；")
    private Integer draftType;
    @ApiModelProperty("附件协议")
    private Long attachmentFileId;
    @ApiModelProperty("附件协议名称")
    private String attachmentFileName;
    @ApiModelProperty("合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结")
    private String performanceStatus;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private String signatureStatus;
    @ApiModelProperty("提交日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    @ApiModelProperty("生效日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate;
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目部id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部所属组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部所属组织id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门id
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 经办部门编码
     */
    public String getDepartmentCode() {
        return departmentCode;
    }

    /**
     * 经办部门编码
     */
    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目Id
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 甲方id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    /**
     * 甲方id
     */
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    /**
     * 甲方名称
     */
    public String getFirstPartyName() {
        return firstPartyName;
    }

    /**
     * 甲方名称
     */
    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    /**
     * 供应商id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 解除日期
     */
    public Date getRelieveDate() {
        return relieveDate;
    }

    /**
     * 解除日期
     */
    public void setRelieveDate(Date relieveDate) {
        this.relieveDate = relieveDate;
    }
    /**
     * 解除原因
     */
    public String getRelieveCause() {
        return relieveCause;
    }

    /**
     * 解除原因
     */
    public void setRelieveCause(String relieveCause) {
        this.relieveCause = relieveCause;
    }
    /**
     * 起草方式 1、上传解除协议，2、已签章；
     */
    public Integer getDraftType() {
        return draftType;
    }

    /**
     * 起草方式 1、上传解除协议，2、已签章；
     */
    public void setDraftType(Integer draftType) {
        this.draftType = draftType;
    }
    /**
     * 附件协议
     */
    public Long getAttachmentFileId() {
        return attachmentFileId;
    }

    /**
     * 附件协议
     */
    public void setAttachmentFileId(Long attachmentFileId) {
        this.attachmentFileId = attachmentFileId;
    }
    /**
     * 附件协议名称
     */
    public String getAttachmentFileName() {
        return attachmentFileName;
    }

    /**
     * 附件协议名称
     */
    public void setAttachmentFileName(String attachmentFileName) {
        this.attachmentFileName = attachmentFileName;
    }
    /**
     * 合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结
     */
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    /**
     * 合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结
     */
    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public String getSignatureStatus() {
        return signatureStatus;
    }

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    /**
     * 提交日期
     */
    public Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 生效日期
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
}
