package com.ejianc.business.promaterial.plan.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModelProperty;


/**
 * 物资月计划子表
 * 
 * @author generator
 * 
 */
public class MonthPlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Long materialMonthPlanId; // 所属总计划Id
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialTypeCode")
    private java.lang.Long materialCategoryId; // 物资分类Id
    private java.lang.String materialCategoryName; // 物资分类名称
    @ApiModelProperty("材料分类编码")
    private String materialTypeCode;
    private java.lang.Long materialId; // 物资Id
    private java.lang.String materialName; // 物资名称
    private java.lang.String spec; // 规格型号
    private java.lang.String unit; // 计量单位
    private java.math.BigDecimal monthPlanNum; // 月计划数量
    private java.math.BigDecimal monthPlanPrice; // 月计划单价
    private java.math.BigDecimal monthPlanMny; // 月计划金额
    private Integer sourceType; // 来源类型 1：总计划，2：物料档案
    private Integer sourceName; // 来源名称 1：总计划，2：物料档案
    private java.lang.String remark; // 备注
    @ApiModelProperty("参照树名称(月份+编码)")
    private java.lang.String name;
    private String materialCode; // 物料编码
    private java.math.BigDecimal surplusNums; // 剩余数量
    private Long sourceId; // 来源Id
    private Long unitId; // 计量单位

    public Long getUnitId() {
        return unitId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public BigDecimal getSurplusNums() {
        return surplusNums;
    }

    public void setSurplusNums(BigDecimal surplusNums) {
        this.surplusNums = surplusNums;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Integer getSourceName() {
        return sourceName;
    }

    public void setSourceName(Integer sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 参照树名称
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    /**
     * 所属总计划Id
     */
    public java.lang.Long getMaterialMonthPlanId() {
        return materialMonthPlanId;
    }

    /**
     * 所属总计划Id
     */
    public void setMaterialMonthPlanId(java.lang.Long materialMonthPlanId) {
        this.materialMonthPlanId = materialMonthPlanId;
    }
    /**
     * 物资分类Id
     */
    public java.lang.Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialCategoryId(java.lang.Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类名称
     */
    public java.lang.String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(java.lang.String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资Id
     */
    @ReferSerialTransfer(referCode = "Material001")
    public java.lang.Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资Id
     */
    @ReferDeserialTransfer
    public void setMaterialId(java.lang.Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public java.lang.String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(java.lang.String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public java.lang.String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(java.lang.String unit) {
        this.unit = unit;
    }
    /**
     * 月计划数量
     */
    public java.math.BigDecimal getMonthPlanNum() {
        return monthPlanNum;
    }

    /**
     * 月计划数量
     */
    public void setMonthPlanNum(java.math.BigDecimal monthPlanNum) {
        this.monthPlanNum = monthPlanNum;
    }
    /**
     * 月计划单价
     */
    public java.math.BigDecimal getMonthPlanPrice() {
        return monthPlanPrice;
    }

    /**
     * 月计划单价
     */
    public void setMonthPlanPrice(java.math.BigDecimal monthPlanPrice) {
        this.monthPlanPrice = monthPlanPrice;
    }
    /**
     * 月计划金额
     */
    public java.math.BigDecimal getMonthPlanMny() {
        return monthPlanMny;
    }

    /**
     * 月计划金额
     */
    public void setMonthPlanMny(java.math.BigDecimal monthPlanMny) {
        this.monthPlanMny = monthPlanMny;
    }

    /**
     * 物资来源
     */
    public Integer getSourceType() {
        return sourceType;
    }
    /**
     * 物资来源
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
}
