package com.ejianc.business.promaterial.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 消耗材-需用计划子表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材-需用计划子表")
public class PlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private java.lang.Long parentId; // parent_id
    private Long tid;
    @ApiModelProperty("主表主键")
    private Long planId;
    @ApiModelProperty("物资分类Id")
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialTypeCode")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("材料分类编码")
    private String materialTypeCode;
    @ApiModelProperty("物料Id")
    private Long materialId;
    @ApiModelProperty("物料名称")
    private String materialName;
    @ApiModelProperty("物料编码")
    private String materialCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("计量单位Id")
    private Long unitId;
    @ApiModelProperty("来源类型 0：总计划，1：月计划 2:物料档案")
    private Long sourceType;
    @ApiModelProperty("来源Id")
    private Long sourceId;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("占用数量")
    private java.math.BigDecimal occupyNums; // 占用数量
    @ApiModelProperty("剩余数量")
    private java.math.BigDecimal surplusNums; // 剩余数量
    @ApiModelProperty("需用数量")
    private java.math.BigDecimal nums; // 需用数量
    private java.math.BigDecimal planNumsSum; // 所有需求数量
    private java.math.BigDecimal occupyNumsAll; // 所有占用数量
    private java.math.BigDecimal surplusNumsSum; // 所有剩余数量
    @ApiModelProperty("累计进场数量")
    private java.math.BigDecimal checkNum; // 累计进场数量
    private java.math.BigDecimal planSurplusNums; // 计划剩余数量（总计划/月计划-数量）

    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public BigDecimal getPlanSurplusNums() {
        return planSurplusNums;
    }

    public void setPlanSurplusNums(BigDecimal planSurplusNums) {
        this.planSurplusNums = planSurplusNums;
    }

    private List<PlanDetailRefVO> planDetail = new ArrayList<>();

    public List<PlanDetailRefVO> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<PlanDetailRefVO> planDetail) {
        this.planDetail = planDetail;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public BigDecimal getPlanNumsSum() {
        return planNumsSum;
    }

    public void setPlanNumsSum(BigDecimal planNumsSum) {
        this.planNumsSum = planNumsSum;
    }

    public BigDecimal getOccupyNumsAll() {
        return occupyNumsAll;
    }

    public void setOccupyNumsAll(BigDecimal occupyNumsAll) {
        this.occupyNumsAll = occupyNumsAll;
    }

    public BigDecimal getSurplusNumsSum() {
        return surplusNumsSum;
    }

    public void setSurplusNumsSum(BigDecimal surplusNumsSum) {
        this.surplusNumsSum = surplusNumsSum;
    }

    public BigDecimal getOccupyNums() {
        return occupyNums;
    }

    public void setOccupyNums(BigDecimal occupyNums) {
        this.occupyNums = occupyNums;
    }

    public BigDecimal getSurplusNums() {
        return surplusNums;
    }

    public void setSurplusNums(BigDecimal surplusNums) {
        this.surplusNums = surplusNums;
    }

    public BigDecimal getNums() {
        return nums;
    }

    public void setNums(BigDecimal nums) {
        this.nums = nums;
    }

    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }

    /**
     * 主表主键
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 主表主键
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物料Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 计量单位Id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位Id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 来源类型 0：总计划，1：月计划 2:物料档案
     */
    public Long getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型 0：总计划，1：月计划 2:物料档案
     */
    public void setSourceType(Long sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源Id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源Id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
