package com.ejianc.business.promaterial.plan.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailVO;

/**
 * 消耗材总计划
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材总计划")
public class MasterPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 总计划变更状态：未变更
     */
    public static final Integer PLAN_CHANGE_STATE_UNCHANGED = 0;

    /**
     * 总计划变更状态：变更中
     */
    public static final Integer PLAN_CHANGE_STATE_CHANGING = 1;

    /**
     * 总计划变更状态：已变更
     */
    public static final Integer PLAN_CHANGE_STATE_CHANGED = 2;

    @ApiModelProperty("所属项目Id")
    private Long projectId;
    @ApiModelProperty("所属项目名称")
    private String projectName;
    @ApiModelProperty("所属项目编码")
    private String projectCode;
    @ApiModelProperty("计划编码")
    private String planCode;
    @ApiModelProperty("总计划金额")
    private java.math.BigDecimal totalPlanAmt;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("变更状态")
    private Integer changeState;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("当前对应的变更计划Id")
    private Long curChangingPlanId;
    @ApiModelProperty("创建人名称")
    private String createUserName;
    @ApiModelProperty("修改人名称")
    private String modifyUserName;
    @ApiModelProperty("提交日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    @ApiModelProperty("生效日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date effectiveDate;
    @ApiModelProperty("变更版本")
    private Integer changeVersion;
    @ApiModelProperty("编制人")
    private Long operatorId;
    @ApiModelProperty("编制人")
    private String operatorName;
    @ApiModelProperty("编制日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate;
    @ApiModelProperty("上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("计划类型")
    private java.lang.Integer planType; // 计划类型（0-消耗材，1-混泥土）
    @ApiModelProperty("消耗材总计划子表")
    @SubEntity
    private List<MasterPlanDetailVO> masterPlanDetailList = new ArrayList<>();
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planDate; // 计划日期
    private Long sourcePlanId;
    private java.lang.String orgCode; // 所属项目部编码

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }


    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    /**
     * 变更历史列表
     */
    private List<MasterPlanChangeHisVO> masterPlanChangeHisList = new ArrayList<>();
    /**
     * 计划类型
     */
    public Integer getPlanType() {
        return planType;
    }

    public void setPlanType(Integer planType) {
        this.planType = planType;
    }
    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 所属项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 计划编码
     */
    public String getPlanCode() {
        return planCode;
    }

    /**
     * 计划编码
     */
    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    /**
     * 总计划金额
     */
    public java.math.BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    /**
     * 总计划金额
     */
    public void setTotalPlanAmt(java.math.BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 所属项目部Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 变更状态
     */
    public Integer getChangeState() {
        return changeState;
    }

    /**
     * 变更状态
     */
    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 当前对应的变更计划Id
     */
    public Long getCurChangingPlanId() {
        return curChangingPlanId;
    }

    /**
     * 当前对应的变更计划Id
     */
    public void setCurChangingPlanId(Long curChangingPlanId) {
        this.curChangingPlanId = curChangingPlanId;
    }
    /**
     * 创建人名称
     */
    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 修改人名称
     */
    public String getModifyUserName() {
        return modifyUserName;
    }

    /**
     * 修改人名称
     */
    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    /**
     * 提交日期
     */
    public java.util.Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(java.util.Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 生效日期
     */
    public java.util.Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(java.util.Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getOperatorId() {
        return operatorId;
    }
    @ReferDeserialTransfer
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 上级组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

     /**
      * 消耗材总计划子表
      */
    public List<MasterPlanDetailVO> getMasterPlanDetailList() {
        return masterPlanDetailList;
    }

    /**
     * 消耗材总计划子表
     */
    public void setMasterPlanDetailList(List<MasterPlanDetailVO> masterPlanDetailList) {
        this.masterPlanDetailList = masterPlanDetailList;
    }

    public List<MasterPlanChangeHisVO> getMasterPlanChangeHisList() {
        return masterPlanChangeHisList;
    }

    public void setMasterPlanChangeHisList(List<MasterPlanChangeHisVO> masterPlanChangeHisList) {
        this.masterPlanChangeHisList = masterPlanChangeHisList;
    }
}
