package com.ejianc.business.promaterial.pricelib.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 价格库-历史价明细
 * 
 * @author generator
 * 
 */
@ApiModel("价格库-历史价明细")
public class MaterialCostPriceApiVO {
    private static final long serialVersionUID = 1L;
    /*
     * 明细预警用字段*/
    @ApiModelProperty("主键（与物资主键一样）")
    private Long id;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资分类Id")
    private Long materialTypeId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("分类内码")
    private String innerCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;
    @ApiModelProperty("单价（无税）")
    private BigDecimal price;
    @ApiModelProperty("单价（含税）")
    private BigDecimal taxPrice;
    @ApiModelProperty("价格取值类型：1-合同 2-结算 3-验收")
    private Integer historyType;
    /*
    * 表头预警用字段*/
    @ApiModelProperty("预警单据类型")
    private Integer priceCheckType;
    private Long orgId;
    private Long projectId;

    /*
     * 预警明细列表*/
    List<MaterialCostPriceApiVO>  materialCostPriceApiVOList = new ArrayList<MaterialCostPriceApiVO>();

    public List<MaterialCostPriceApiVO> getMaterialCostPriceApiVOList() {
        return materialCostPriceApiVOList;
    }

    public void setMaterialCostPriceApiVOList(List<MaterialCostPriceApiVO> materialCostPriceApiVOList) {
        this.materialCostPriceApiVOList = materialCostPriceApiVOList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public Integer getHistoryType() {
        return historyType;
    }

    public void setHistoryType(Integer historyType) {
        this.historyType = historyType;
    }

    public Integer getPriceCheckType() {
        return priceCheckType;
    }

    public void setPriceCheckType(Integer priceCheckType) {
        this.priceCheckType = priceCheckType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
}
