package com.ejianc.business.promaterial.order.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.promaterial.order.vo.ConcreteOrderDetailVO;

/**
 * 混凝土-订单实体
 * 
 * @author generator
 * 
 */
@ApiModel("混凝土-订单实体")
public class ConcreteOrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    private Long commitId; // 提交人
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("设备供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("联系人")
    private Long linkId;
    @ApiModelProperty("联系人名称")
    private String linkName;
    @ApiModelProperty("联系人电话")
    private String linkTelephone;
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    @ApiModelProperty("订单日期")
    private Date orderCreateDate;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty("到货日期")
    private Date orderExpiryDate;
    @ApiModelProperty("施工部位")
    private String construction;
    @ApiModelProperty("送货要求")
    private String orderNote;
    @ApiModelProperty("送货地址")
    private String orderAddress;
    @ApiModelProperty("接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）")
    private Integer receiveState;
    @ApiModelProperty("接收原因")
    private String receiveReason;
    @ApiModelProperty("发货状态（0-待发货，1-部分送货，2-已送货）")
    private Integer deliverState;
    @ApiModelProperty("关闭状态（0-正常，1-已关闭）")
    private Integer orderFlag;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    private String orgCode; // 组织编码
    private String parentOrgCode; // 项目部上级组织编码
    @ApiModelProperty("混凝土-订单明细子实体")
    private List<ConcreteOrderDetailVO> concreteOrderDetailList = new ArrayList<>();
    private Integer automaticWeigh; //自动称重设置（0：自动称重，1非自动称重）

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    public String getReceiveReason() {
        return receiveReason;
    }

    public void setReceiveReason(String receiveReason) {
        this.receiveReason = receiveReason;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode="contractMaterial")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 设备供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 联系人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    @ReferDeserialTransfer
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 订单日期
     */
    public Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 订单日期
     */
    public void setOrderCreateDate(Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    /**
     * 到货日期
     */
    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    /**
     * 到货日期
     */
    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 送货要求
     */
    public String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-待发货，1-部分送货，2-已送货）
     */
    public Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-待发货，1-部分送货，2-已送货）
     */
    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 关闭状态（0-正常，1-已关闭）
     */
    public Integer getOrderFlag() {
        return orderFlag;
    }

    /**
     * 关闭状态（0-正常，1-已关闭）
     */
    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    
     /**
      * 混凝土-订单明细子实体
      */
      public List<ConcreteOrderDetailVO> getConcreteOrderDetailList() {
         return concreteOrderDetailList;
      }
     /**
      * 混凝土-订单明细子实体
      */
     public void setConcreteOrderDetailList(List<ConcreteOrderDetailVO> concreteOrderDetailList) {
         this.concreteOrderDetailList = concreteOrderDetailList;
     }
}
