package com.ejianc.business.promaterial.pricelib.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 价格库-合同明细
 * 
 * @author generator
 * 
 */
public class PriceLibVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private String memo; // 备注
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private String area; // 项目地区
    private String areaName; // 项目地区
    private Long supplierId; // 乙方Id
    private String supplierName; // 乙方名称
    private Date signDate; // 合同签订日期
    private Long sourceId; // 来源主表id
    private String contractName; //合同名称
    private Long sourceDetailId; // 来源子表id
    private String performanceStatus; // 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)（穿透使用）
    private String settlementPayment; // 结算付款
    private String priceFloatType; // 单价浮动方式
    private Long materialId; // 物料Id
    private String materialCode; // 物资编码
    private String materialName; // 物资名称
    private Long materialTypeId; // 物资分类Id
    private String materialTypeName; // 物资分类名称
    private String innerCode; // 分类内码
    private String spec; // 规则/型号
    private Long unitId; // 计量单位主键
    private String unitName; // 计量单位
    private String brand; // 品牌

    private BigDecimal contractNum; // 数量
    private BigDecimal contractPrice; // 单价(无税)
    private BigDecimal contractMny; // 金额(无税)
    private BigDecimal contractTaxRate; // 税率
    private BigDecimal contractTaxMny; // 金额(含税)
    private BigDecimal contractTaxPrice; // 单价(含税)
    private BigDecimal contractHigjFrequencyPrice; // 高频单价
    private BigDecimal contractHigjFrequencyTaxPrice; // 高频单价（含税）
    private BigDecimal contractTax; // 税额

    private BigDecimal checkNum; // 数量
    private BigDecimal checkPrice; // 单价(无税)
    private BigDecimal checkMny; // 金额(无税)
    private BigDecimal checkTaxRate; // 税率
    private BigDecimal checkTaxMny; // 金额(含税)
    private BigDecimal checkTaxPrice; // 单价(含税)
    private BigDecimal checkHigjFrequencyPrice; // 高频单价
    private BigDecimal checkHigjFrequencyTaxPrice; // 高频单价（含税）
    private BigDecimal checkTax; // 税额

    private BigDecimal settleNum; // 数量
    private BigDecimal settlePrice; // 单价(无税)
    private BigDecimal settleMny; // 金额(无税)
    private BigDecimal settleTaxRate; // 税率
    private BigDecimal settleTaxMny; // 金额(含税)
    private BigDecimal settleTaxPrice; // 单价(含税)
    private BigDecimal settleHigjFrequencyPrice; // 高频单价
    private BigDecimal settleHigjFrequencyTaxPrice; // 高频单价（含税）
    private BigDecimal settleTax; // 税额

    private String marketPriceArea; // 市场价（无税）
    private String guidePriceArea; // 公司指导价（无税）
    private String contractPriceArea; // 合同价格区间（无税）
    private BigDecimal contractAvgPrice; // 合同均价(无税)
    private BigDecimal contractMaxPrice; // 合同最高价(无税)
    private BigDecimal contractMinPrice; // 合同最低价(无税)
    private String checkPriceArea; // 验收价格区间（无税）
    private BigDecimal checkAvgPrice; // 验收均价(无税)
    private BigDecimal checkMaxPrice; // 验收最高价(无税)
    private BigDecimal checkMinPrice; // 验收最低价(无税)
    private String settlePriceArea; // 结算价格区间（无税）
    private BigDecimal settleAvgPrice; // 结算均价(无税)
    private BigDecimal settleMaxPrice; // 结算最高价(无税)
    private BigDecimal settleMinPrice; // 结算最低价(无税)

    private String marketTaxPriceArea; // 市场价（含税）
    private String guideTaxPriceArea; // 公司指导价（含税）
    private String contractTaxPriceArea; // 合同价格区间（含税）
    private BigDecimal contractTaxAvgPrice; // 合同均价（含税）
    private BigDecimal contractTaxMaxPrice; // 合同最高价（含税）
    private BigDecimal contractTaxMinPrice; // 合同最低价（含税）
    private String checkTaxPriceArea; // 验收价格区间（含税）
    private BigDecimal checkTaxAvgPrice; // 验收均价（含税）
    private BigDecimal checkTaxMaxPrice; // 验收最高价（含税）
    private BigDecimal checkTaxMinPrice; // 验收最低价（含税）
    private String settleTaxPriceArea; // 结算价格区间（含税）
    private BigDecimal settleTaxAvgPrice; // 结算均价（含税）
    private BigDecimal settleTaxMaxPrice; // 结算最高价（含税）
    private BigDecimal settleTaxMinPrice; // 结算最低价（含税）

    List<PriceContractVO> priceContractList = new ArrayList<>();
    List<PriceCheckVO> priceCheckList = new ArrayList<>();
    List<PriceSettlementVO> priceSettlementList = new ArrayList<>();

    public BigDecimal getContractHigjFrequencyPrice() {
        return contractHigjFrequencyPrice;
    }

    public void setContractHigjFrequencyPrice(BigDecimal contractHigjFrequencyPrice) {
        this.contractHigjFrequencyPrice = contractHigjFrequencyPrice;
    }

    public BigDecimal getContractHigjFrequencyTaxPrice() {
        return contractHigjFrequencyTaxPrice;
    }

    public void setContractHigjFrequencyTaxPrice(BigDecimal contractHigjFrequencyTaxPrice) {
        this.contractHigjFrequencyTaxPrice = contractHigjFrequencyTaxPrice;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getCheckHigjFrequencyPrice() {
        return checkHigjFrequencyPrice;
    }

    public void setCheckHigjFrequencyPrice(BigDecimal checkHigjFrequencyPrice) {
        this.checkHigjFrequencyPrice = checkHigjFrequencyPrice;
    }

    public BigDecimal getCheckHigjFrequencyTaxPrice() {
        return checkHigjFrequencyTaxPrice;
    }

    public void setCheckHigjFrequencyTaxPrice(BigDecimal checkHigjFrequencyTaxPrice) {
        this.checkHigjFrequencyTaxPrice = checkHigjFrequencyTaxPrice;
    }

    public BigDecimal getCheckTax() {
        return checkTax;
    }

    public void setCheckTax(BigDecimal checkTax) {
        this.checkTax = checkTax;
    }

    public BigDecimal getSettleHigjFrequencyPrice() {
        return settleHigjFrequencyPrice;
    }

    public void setSettleHigjFrequencyPrice(BigDecimal settleHigjFrequencyPrice) {
        this.settleHigjFrequencyPrice = settleHigjFrequencyPrice;
    }

    public BigDecimal getSettleHigjFrequencyTaxPrice() {
        return settleHigjFrequencyTaxPrice;
    }

    public void setSettleHigjFrequencyTaxPrice(BigDecimal settleHigjFrequencyTaxPrice) {
        this.settleHigjFrequencyTaxPrice = settleHigjFrequencyTaxPrice;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public List<PriceContractVO> getPriceContractList() {
        return priceContractList;
    }

    public void setPriceContractList(List<PriceContractVO> priceContractList) {
        this.priceContractList = priceContractList;
    }

    public List<PriceCheckVO> getPriceCheckList() {
        return priceCheckList;
    }

    public void setPriceCheckList(List<PriceCheckVO> priceCheckList) {
        this.priceCheckList = priceCheckList;
    }

    public List<PriceSettlementVO> getPriceSettlementList() {
        return priceSettlementList;
    }

    public void setPriceSettlementList(List<PriceSettlementVO> priceSettlementList) {
        this.priceSettlementList = priceSettlementList;
    }


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getSettlementPayment() {
        return settlementPayment;
    }

    public void setSettlementPayment(String settlementPayment) {
        this.settlementPayment = settlementPayment;
    }
    public String getPriceFloatType() {
        return priceFloatType;
    }

    public void setPriceFloatType(String priceFloatType) {
        this.priceFloatType = priceFloatType;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractTaxPrice() {
        return contractTaxPrice;
    }

    public void setContractTaxPrice(BigDecimal contractTaxPrice) {
        this.contractTaxPrice = contractTaxPrice;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractPriceArea() {
        return contractPriceArea;
    }

    public void setContractPriceArea(String contractPriceArea) {
        this.contractPriceArea = contractPriceArea;
    }

    public BigDecimal getContractAvgPrice() {
        return contractAvgPrice;
    }

    public void setContractAvgPrice(BigDecimal contractAvgPrice) {
        this.contractAvgPrice = contractAvgPrice;
    }

    public BigDecimal getContractMaxPrice() {
        return contractMaxPrice;
    }

    public void setContractMaxPrice(BigDecimal contractMaxPrice) {
        this.contractMaxPrice = contractMaxPrice;
    }

    public BigDecimal getContractMinPrice() {
        return contractMinPrice;
    }

    public void setContractMinPrice(BigDecimal contractMinPrice) {
        this.contractMinPrice = contractMinPrice;
    }

    public String getContractTaxPriceArea() {
        return contractTaxPriceArea;
    }

    public void setContractTaxPriceArea(String contractTaxPriceArea) {
        this.contractTaxPriceArea = contractTaxPriceArea;
    }

    public BigDecimal getContractTaxAvgPrice() {
        return contractTaxAvgPrice;
    }

    public void setContractTaxAvgPrice(BigDecimal contractTaxAvgPrice) {
        this.contractTaxAvgPrice = contractTaxAvgPrice;
    }

    public BigDecimal getContractTaxMaxPrice() {
        return contractTaxMaxPrice;
    }

    public void setContractTaxMaxPrice(BigDecimal contractTaxMaxPrice) {
        this.contractTaxMaxPrice = contractTaxMaxPrice;
    }

    public BigDecimal getContractTaxMinPrice() {
        return contractTaxMinPrice;
    }

    public void setContractTaxMinPrice(BigDecimal contractTaxMinPrice) {
        this.contractTaxMinPrice = contractTaxMinPrice;
    }

    public String getMarketPriceArea() {
        return marketPriceArea;
    }

    public void setMarketPriceArea(String marketPriceArea) {
        this.marketPriceArea = marketPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getCheckPriceArea() {
        return checkPriceArea;
    }

    public void setCheckPriceArea(String checkPriceArea) {
        this.checkPriceArea = checkPriceArea;
    }

    public BigDecimal getCheckAvgPrice() {
        return checkAvgPrice;
    }

    public void setCheckAvgPrice(BigDecimal checkAvgPrice) {
        this.checkAvgPrice = checkAvgPrice;
    }

    public BigDecimal getCheckMaxPrice() {
        return checkMaxPrice;
    }

    public void setCheckMaxPrice(BigDecimal checkMaxPrice) {
        this.checkMaxPrice = checkMaxPrice;
    }

    public BigDecimal getCheckMinPrice() {
        return checkMinPrice;
    }

    public void setCheckMinPrice(BigDecimal checkMinPrice) {
        this.checkMinPrice = checkMinPrice;
    }

    public String getSettlePriceArea() {
        return settlePriceArea;
    }

    public void setSettlePriceArea(String settlePriceArea) {
        this.settlePriceArea = settlePriceArea;
    }

    public BigDecimal getSettleAvgPrice() {
        return settleAvgPrice;
    }

    public void setSettleAvgPrice(BigDecimal settleAvgPrice) {
        this.settleAvgPrice = settleAvgPrice;
    }

    public BigDecimal getSettleMaxPrice() {
        return settleMaxPrice;
    }

    public void setSettleMaxPrice(BigDecimal settleMaxPrice) {
        this.settleMaxPrice = settleMaxPrice;
    }

    public BigDecimal getSettleMinPrice() {
        return settleMinPrice;
    }

    public void setSettleMinPrice(BigDecimal settleMinPrice) {
        this.settleMinPrice = settleMinPrice;
    }

    public String getMarketTaxPriceArea() {
        return marketTaxPriceArea;
    }

    public void setMarketTaxPriceArea(String marketTaxPriceArea) {
        this.marketTaxPriceArea = marketTaxPriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public String getCheckTaxPriceArea() {
        return checkTaxPriceArea;
    }

    public void setCheckTaxPriceArea(String checkTaxPriceArea) {
        this.checkTaxPriceArea = checkTaxPriceArea;
    }

    public BigDecimal getCheckTaxAvgPrice() {
        return checkTaxAvgPrice;
    }

    public void setCheckTaxAvgPrice(BigDecimal checkTaxAvgPrice) {
        this.checkTaxAvgPrice = checkTaxAvgPrice;
    }

    public BigDecimal getCheckTaxMaxPrice() {
        return checkTaxMaxPrice;
    }

    public void setCheckTaxMaxPrice(BigDecimal checkTaxMaxPrice) {
        this.checkTaxMaxPrice = checkTaxMaxPrice;
    }

    public BigDecimal getCheckTaxMinPrice() {
        return checkTaxMinPrice;
    }

    public void setCheckTaxMinPrice(BigDecimal checkTaxMinPrice) {
        this.checkTaxMinPrice = checkTaxMinPrice;
    }

    public String getSettleTaxPriceArea() {
        return settleTaxPriceArea;
    }

    public void setSettleTaxPriceArea(String settleTaxPriceArea) {
        this.settleTaxPriceArea = settleTaxPriceArea;
    }

    public BigDecimal getSettleTaxAvgPrice() {
        return settleTaxAvgPrice;
    }

    public void setSettleTaxAvgPrice(BigDecimal settleTaxAvgPrice) {
        this.settleTaxAvgPrice = settleTaxAvgPrice;
    }

    public BigDecimal getSettleTaxMaxPrice() {
        return settleTaxMaxPrice;
    }

    public void setSettleTaxMaxPrice(BigDecimal settleTaxMaxPrice) {
        this.settleTaxMaxPrice = settleTaxMaxPrice;
    }

    public BigDecimal getSettleTaxMinPrice() {
        return settleTaxMinPrice;
    }

    public void setSettleTaxMinPrice(BigDecimal settleTaxMinPrice) {
        this.settleTaxMinPrice = settleTaxMinPrice;
    }

    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }

    public BigDecimal getCheckPrice() {
        return checkPrice;
    }

    public void setCheckPrice(BigDecimal checkPrice) {
        this.checkPrice = checkPrice;
    }

    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }

    public BigDecimal getCheckTaxRate() {
        return checkTaxRate;
    }

    public void setCheckTaxRate(BigDecimal checkTaxRate) {
        this.checkTaxRate = checkTaxRate;
    }

    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }

    public BigDecimal getCheckTaxPrice() {
        return checkTaxPrice;
    }

    public void setCheckTaxPrice(BigDecimal checkTaxPrice) {
        this.checkTaxPrice = checkTaxPrice;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }

    public BigDecimal getSettlePrice() {
        return settlePrice;
    }

    public void setSettlePrice(BigDecimal settlePrice) {
        this.settlePrice = settlePrice;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTaxRate() {
        return settleTaxRate;
    }

    public void setSettleTaxRate(BigDecimal settleTaxRate) {
        this.settleTaxRate = settleTaxRate;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleTaxPrice() {
        return settleTaxPrice;
    }

    public void setSettleTaxPrice(BigDecimal settleTaxPrice) {
        this.settleTaxPrice = settleTaxPrice;
    }
}
