package com.ejianc.business.promaterial.plan.api;

import com.ejianc.business.promaterial.plan.hystrix.BatPlanHystrix;
import com.ejianc.business.promaterial.plan.vo.SourceBliVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(
        name = "ejc-promaterial-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-promaterial-web",
        fallback = BatPlanHystrix.class
)
public interface IBatPlanApi {

    /**
     * 批量修改采购计划引用状态
     * 枚举类：BatPlanEnum
     *
     * @param idList    idList
     * @param planState 计划状态（0-待采购；1-采购中；2-采购完成）
     * @return 修改结果
     */
    @RequestMapping(
            value = {"/api/batPlan/updateBatPlanQuote"},
            method = {RequestMethod.GET}
    )
    CommonResponse<String> updateBatPlanQuote(@RequestParam("idList") List<String> idList,
                                              @RequestParam("planState") Integer planState,
                                             @RequestParam("establishType") Integer establishType);
    /**
     * 材料管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  验收单、对账单、结算单数量；
     * 2、协同单据数量：查该供应商在本下项目生效的  验收单（订单）、对账单（已签字）、结算单（已签字）的数量；
     * 3、比例：协同单据数量/累计单据数量；
     * 混凝土管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  验收单、对账单、结算单数量；
     * 2、协同单据数量：查该供应商在本下项目生效的  验收单（订单）、对账单（已签字）、结算单（已签字）的数量；
     * 3、比例：协同单据数量/累计单据数量；
     */
    @GetMapping(value = "/api/batPlan/getSourceBliVO")
    CommonResponse<List<SourceBliVO>> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId,@RequestParam(value = "dateIn",required = false) String dateIn);
}
