package com.ejianc.business.promaterial.check.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/check/")
public class CheckApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ICheckDetailService checkDetailService;

    /**
     * 根据物资明细id 获取验收单详情
     *
     * @param detailId 明细id
     * @return
     */
    @ApiOperation("根据物资明细id 获取验收单详情")
    @RequestMapping(value = "/queryCheckByDetailId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryCheckByDetailId(@RequestParam("detailId") Long detailId) {
        logger.info("物资明细id，查询参数：{}", detailId);
        CheckEntity checkEntity = new CheckEntity();
        CheckDetailEntity checkDetailEntity = checkDetailService.getById(detailId);
        if(null!=checkDetailEntity){
            checkEntity = checkService.selectById(checkDetailEntity.getCheckId());
        }
        logger.info("根据物资明细id 获取验收单详情，查询结果：{}", JSONObject.toJSONString(checkEntity));
        return CommonResponse.success("查询成功", BeanMapper.map(checkEntity,CheckVO.class));
    }


    /**
     * 根据 项目和收款单位 查询无合同 已生效的 材料验收入库单 验收金额之和
     *
     * @return
     */
    @ApiOperation("根据 项目和收款单位 查询无合同 已生效的 材料验收入库单 验收金额之和")
    @RequestMapping(value = "/querycheckMnyById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querycheckMnyById(@RequestParam("projectId") Long projectId,@RequestParam("supplierId") Long supplierId) {
        logger.info("查询项目参数：{} , 收款单位", projectId,supplierId);
        List<CheckEntity> list = checkService.list(new QueryWrapper<CheckEntity>().eq("project_id",projectId).eq("supplier_id",supplierId).in("bill_state",1,3).isNull("contract_id"));
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(list)){
            checkTaxMny = list.stream().map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("checkTaxMny",checkTaxMny);
        logger.info("查询结果：{}", jsonObject);
        return CommonResponse.success("查询成功", jsonObject);
    }


    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param jsonObject 参数
     *
     * @return CommonResponse<Map < String, Integer>>
     */
    @ApiOperation(value = "根据项目id、验收日期查询消耗材、混凝土单据数量")
    @PostMapping(value = "/countBillNum")
    public CommonResponse<Map<String, Integer>> countBillNum(@RequestBody JSONObject jsonObject) {
        if (!jsonObject.containsKey("projectId")) {
            throw new BusinessException("项目id不能为空！");
        }
        if (!jsonObject.containsKey("fillDate")) {
            throw new BusinessException("填报日期不能为空！");
        }
        return CommonResponse.success("查询成功！", checkService.countBillNum(jsonObject.getLong("projectId"), jsonObject.getDate("fillDate")));
    }


    /**
     * 根据 项目 查询无合同 已生效的 材料验收入库单
     *
     * @return
     */
    @ApiOperation("根据 项目 查询无合同 已生效的 材料验收入库单 ")
    @RequestMapping(value = "/querycheckListByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CheckVO>> querycheckListByProjectId(@RequestParam("projectId") Long projectId) {
        logger.info("查询项目参数：{} ", projectId);
        List<CheckEntity> list = checkService.list(new QueryWrapper<CheckEntity>().eq("project_id",projectId)
                .in("bill_state",1,3).isNull("contract_id"));
        List<CheckVO> checkVOS = BeanMapper.mapList(list, CheckVO.class);
        logger.info("查询结果：{}", checkVOS);
        return CommonResponse.success("查询成功", checkVOS);
    }

    /**
     * 根据 项目 查询无合同 已生效的 材料验收入库单 验收金额之和
     *
     * @return
     */
    @ApiOperation("根据 项目 查询无合同 已生效的 材料验收入库单 验收金额之和")
    @RequestMapping(value = "/querycheckMnyByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querycheckMnyByProjectId(@RequestParam("projectId") Long projectId) {
        logger.info("查询项目参数：{} ", projectId);
        List<CheckEntity> list = checkService.list(new QueryWrapper<CheckEntity>().eq("project_id",projectId).in("bill_state",1,3).isNull("contract_id"));
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(list)){
            checkTaxMny = list.stream().map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("checkTaxMny",checkTaxMny);
        logger.info("查询结果：{}", jsonObject);
        return CommonResponse.success("查询成功", jsonObject);
    }
}
