package com.ejianc.business.promaterial.check.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.CheckWeighTypeEnum;
import com.ejianc.business.promaterial.check.vo.WeighUnitEnum;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 消耗材-验收主表
 *
 * @author generator
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService {
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC-CHECK-CODE";//此处需要根据实际修改
    private final String OPERATE = "XHC_CHECK_SYNC";
    private static final String BILL_TYPE = "BT220215000000006";//此处需要根据实际修改

    @Override
    @Transactional
    public CheckVO saveOrUpdates(CheckVO saveOrUpdateVO, Boolean isControl) {
        //先删除目标成本
//        if (!isControl && saveOrUpdateVO.getId() != null) {
//            CheckEntity checkEntity = super.selectById(saveOrUpdateVO.getId());
//            //有合同
//            Boolean isOldPush = false;
//            if (checkEntity.getCheckType().equals("proMaterial-2")) {
//                isOldPush = true;
//            }
//            if (!checkEntity.getCheckType().equals("proMaterial-2") && checkEntity.getAttrFlag().equals(1)) {
//                isOldPush = true;
//            }
//            if (isOldPush) {
//                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
//                ExecutionVO executionDelVO = targetCost(checkEntity);
//                totalExecutionVOList.add(executionDelVO.getTotalVO());
//                CommonResponse<String> responses = executionApi.aggDel(totalExecutionVOList);
//                if (!responses.isSuccess()) {
//                    throw new BusinessException("目标成本删除推送失败" + responses.getMsg());
//                }
//            }
//        }

        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
            }
        }
        CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);
        if (!isControl) {
            if (entity.getId() == null || entity.getId() == 0) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                if(null==entity.getCheckWeighType()){
                    entity.setCheckWeighType(CheckWeighTypeEnum.否磅单验收.getCode());
                }
                if(null==entity.getAutomaticWeigh()){// 自动称重设置（0：自动称重，1非自动称重）
                    entity.setAutomaticWeigh(1);
                }
            }
        }
        entity.setSignStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        entity.setRelationFlag("0");//关联状态初始化
        entity.setProportionFlag("0");//分摊状态初始化
        if (!isControl) {
            super.saveOrUpdate(entity, false);
        }
        else {
            if (null == entity.getId()) {
                entity.setId(IdWorker.getId());
            }
            List<CheckDetailEntity> detailEntityList = entity.getCheckDetailList();
            List<CheckDetailEntity> detailEntityListNew = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                for (CheckDetailEntity cdEntity : detailEntityList) {
                    if (null == cdEntity.getId()) {
                        cdEntity.setId(IdWorker.getId());
                    }
                    if (!"del".equals(cdEntity.getRowState())) {
                        detailEntityListNew.add(cdEntity);
                    }
                }
                entity.setCheckDetailList(detailEntityListNew);
            }
        }

        //回写发货单数据
        if (entity.getSourceType() == 1 && !isControl) {
            Integer checkStatus = 0;
            DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryId());
            //查询出所有的验收单详情,算出验收数据
            LambdaQueryWrapper<CheckDetailEntity> lambdaCheckDetail = Wrappers.<CheckDetailEntity>lambdaQuery();
            lambdaCheckDetail.eq(CheckDetailEntity::getDeliveryId, entity.getDeliveryId());
            List<CheckDetailEntity> checkDetailEntityList = checkDetailService.list(lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty(checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper<DeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<DeliveryDetailEntity>lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, entity.getDeliveryId());
                List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailService.list(lambdaDeliveryDetail);
                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null == deliveryDetailEntity.getCheckNum()) {
                        deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                    }
                }

                //判断发货单的验收状态
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                        (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));

                if (allCheck) {
                    checkStatus = 2;
                }
                if (anyCheck) {
                    checkStatus = 1;
                }
                //更新发货验收状态和验收数量

                deliveryEntity.setCheckStatus(checkStatus);
                deliveryService.updateById(deliveryEntity);
                deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
        }

//        if (!isControl) {
//            //甲供材不推送目标成本,proMaterial-2周转材不区分是否甲供材,都推送目标成本
//            Long contractId = saveOrUpdateVO.getContractId();
//            Integer attrFlag = saveOrUpdateVO.getAttrFlag();
//            String checkType = saveOrUpdateVO.getCheckType();
//            Boolean isPush = false;
//            //有合同
//            if (checkType.equals("proMaterial-2")){
//                isPush = true;
//            }
//            if (!checkType.equals("proMaterial-2") && attrFlag.equals(1)){
//                isPush = true;
//            }
//
//            if (isPush) {
//                //目标成本推送
//                ExecutionVO executionVO = targetCost(entity);
//                logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
//                CommonResponse<String> response = executionApi.aggPush(executionVO);
//                if (!response.isSuccess()) {
//                    throw new BusinessException("目标成本推送失败:" + response.getMsg());
//                }
//            }
//        }

        //推送实际成本
        //仓库属性是甲供材的不推送实际成本
//        if (entity.getCheckType().equals("proMaterial-2")) {
//            saveOrUpdateVO.setAttrFlag(1);
//        }
//        if (saveOrUpdateVO.getAttrFlag().equals(1) && saveOrUpdateVO.getStoreType() == 1&&!isControl){
//            saveCost(entity,0);
//        }

        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return vo;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    @Transactional
    public void deletes(List<CheckVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1) {
            throw new BusinessException("验收单不允许批量删除!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = super.selectById(checkVO.getId());
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        DeliveryEntity deliveryEntity = deliveryService.selectById(checkEntity.getDeliveryId());
        if (deliveryEntity != null) {
            List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map<Long, CheckDetailEntity> checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) {
                    CheckDetailEntity checkDetailEntity = checkDetailEntityMap.get(deliveryDetailEntity.getId());
                    deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
                }
            }

            //判断发货单的验收状态
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                    (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));
            Integer checkStatus = 0;
            if (allCheck) {
                checkStatus = 2;
            }
            if (anyCheck) {
                checkStatus = 1;
            }
            //更新发货验收状态和验收数量
            deliveryEntity.setCheckStatus(checkStatus);
            deliveryService.updateById(deliveryEntity);
            deliveryDetailService.updateBatchById(deliveryDetailList);

        }
        super.removeByIds(vos.stream().map(CheckVO::getId).collect(Collectors.toList()), true);
        return;

    }



    @Override
    public CheckVO getRateAndPrice(CheckVO checkVO) {
        //根据合同主键查询合同信息,匹配对应的税率和单价
        ContractEntity contractEntity = contractService.selectById(checkVO.getContractId());
        LambdaQueryWrapper<ContractDetailEntity> lambdaContractDetail = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambdaContractDetail.eq(ContractDetailEntity::getContractId, checkVO.getContractId());
        lambdaContractDetail.eq(ContractDetailEntity::getMaterialId, checkVO.getMaterialId());
        ContractDetailEntity contractDetailEntity = contractDetailService.getOne(lambdaContractDetail);
        if (contractDetailEntity != null) {
            checkVO.setCheckPrice(contractDetailEntity.getPrice());
            checkVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractDetailEntity.getNum());
            checkVO.setMemo(contractDetailEntity.getMemo());
            return checkVO;
        }
        //取大类
        LambdaQueryWrapper<ContractDetailEntity> lambdaContractType = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambdaContractType.eq(ContractDetailEntity::getContractId, checkVO.getContractId());
        lambdaContractType.eq(ContractDetailEntity::getMaterialTypeId, checkVO.getMaterialTypeId());
        lambdaContractType.isNull(ContractDetailEntity::getMaterialId);
        ContractDetailEntity contractTypeEntity = contractDetailService.getOne(lambdaContractType);
        if (contractTypeEntity != null) {
            checkVO.setCheckPrice(contractTypeEntity.getPrice());
            checkVO.setCheckTaxPrice(contractTypeEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractTypeEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractTypeEntity.getNum());
            checkVO.setMemo(contractTypeEntity.getMemo());
            return checkVO;
        }
        //去合同主表税率
        checkVO.setTaxRate(contractEntity.getTaxRate());
        return checkVO;
    }

    public Map<String,BigDecimal> getCheckNum(String weighUnit,BigDecimal netWeight,BigDecimal coefficient){
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        Map<String,BigDecimal>  map = new HashMap<>();
        if(null==coefficient){
            coefficient = BigDecimal.ZERO;
        }
        if(null==netWeight){
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if(StringUtils.isNotEmpty(weighUnit)){
            billStateCode = WeighUnitEnum.getEnumByStateCode(weighUnit).getBillStateCode();
        }
        switch (billStateCode){
            case 0:
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient,coefficient); break;
            case 1:
                detailNetWeightCoefficient = ComputeUtil.safeMultiply(netWeight,new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient,coefficient);;break;
        }
        map.put("checkNum",checkNum);
        map.put("detailNetWeightCoefficient",detailNetWeightCoefficient);
        return map;
    }


    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     *
     * @return Map<String, Integer>
     */
    @Override
    public Map<String, Integer> countBillNum(Long projectId, Date checkDate) {
        HashMap<String, Integer> resultMap = new HashMap<>();

        LambdaQueryWrapper<CheckEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(CheckEntity::getProjectId, projectId)
                .eq(CheckEntity::getCheckDate, checkDate);
        int checkCount = super.count(lambdaQuery);
        resultMap.put("消耗材", checkCount);
        return resultMap;
    }
}
