package com.ejianc.business.promaterial.contract.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractFeeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractStageEntity;
import com.ejianc.business.promaterial.contract.bean.ContractClauseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 主合同实体
 *
 * @author generator
 *
 */
@TableName("ejc_promaterial_contract")
public class ContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="contract_content")
    private String contractContent; // 主要合同内容
    @TableField(value="purchase_type")
    private String purchaseType; // 采购类型 1-自采，2-集采
    @TableField(value="purchase_type_name")
    private String purchaseTypeName; // 集采/自采

    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_place")
    private String projectPlace; // 项目地点
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称


    @TableField(value="customer_id")
    private Long customerId; // 甲方Id
    @TableField(value="customer_name")
    private String customerName; // 甲方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方Id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="sign_date")
    private Date signDate; // 签订日期
    @TableField(value="sign_place")
    private String signPlace; // 签约地点

    @TableField(value="performance_status")
    private String performanceStatus; // 合同履约状态：合同履约状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="pay_scale")
    private BigDecimal payScale; // 合同支付比例
    @TableField(value="customer_employee_id")
    private Long customerEmployeeId; // 甲方经办人Id
    @TableField(value="customer_employee_name")
    private String customerEmployeeName; // 甲方经办人名称
    @TableField(value="customer_employee_mobile")
    private String customerEmployeeMobile; // 甲方经办人电话
    @TableField(value="supplier_employee_name")
    private String supplierEmployeeName; // 乙方经办人名称
    @TableField(value="supplier_employee_mobile")
    private String supplierEmployeeMobile; // 乙方经办人电话
    @TableField(value="pricing_type")
    private String pricingType; // 计价方式：1-固定单价、2-浮动单价、3-固定总价

    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="detail_tax_mny")
    private BigDecimal detailTaxMny; // 清单金额
    @TableField(value="detail_mny")
    private BigDecimal detailMny; // 清单金额（无税）
    @TableField(value="detail_tax")
    private BigDecimal detailTax; // 清单税额
    @TableField(value="free_tax_mny")
    private BigDecimal freeTaxMny; // 其他费用金额
    @TableField(value="free_mny")
    private BigDecimal freeMny; // 其他费用金额（无税）
    @TableField(value="free_tax")
    private BigDecimal freeTax; // 其他费用税额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value="base_money_with_tax")
    private BigDecimal baseMoneyWithTax; // 初始版本(含税)金额
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="before_change_mny_with_tax")
    private BigDecimal beforeChangeMnyWithTax; // 变更前金额（含税）
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="changing_mny_with_tax")
    private BigDecimal changingMnyWithTax; // 变更中金额（含税）
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同Id
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="supplement_describe")
    private String supplementDescribe; // 补充项描述
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="main_contract_create_date")
    private Date mainContractCreateDate; // 主合同创建日期(用于合同、补充协议排序)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="change_date")
    private Date changeDate; // 变更日期

    @TableField(value="change_contract_name")
    private String changeContractName; // 变更合同名称

    private BigDecimal totalPrepayMny; // 累计预付款金额
    @TableField(value="total_pay_mny")
    private BigDecimal totalPayMny; // 累计付款金额
    @TableField(value="total_offset_mny")
    private BigDecimal totalOffsetMny; // 累计冲抵金额
    @TableField(value="total_settlement_mny")
    private BigDecimal totalSettlementMny; // 累计结算金额(不含税)
    @TableField(value="total_settlement_tax_mny")
    private BigDecimal totalSettlementTaxMny; // 累计结算金额
    @TableField(value="total_invoice_mny")
    private BigDecimal totalInvoiceMny; // 累计收票金额(不含税)
    @TableField(value="total_invoice_tax_mny")
    private BigDecimal totalInvoiceTaxMny; // 累计收票金额
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value="contract_type")
    private Integer contractType; // 合同类型（1-材料合同, 2-安装合同）



    /**
     * 发票类型Id
     */
    @TableField(value = "invoice_type_id")
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    @TableField(value = "invoice_type_name")
    private String invoiceTypeName;


    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField("filing_status")
    private Integer filingStatus;//是否归档 1：是；0：否
    @TableField("filing_ref")
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否

    @TableField(exist=false)
    @SubEntity(serviceName="contractDetailService",pidName = "contractId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractDetailEntity> contractDetailList = new ArrayList<>(); // 主合同明细实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractFeeService",pidName = "contractId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractFeeEntity> contractFeeList = new ArrayList<>(); // 主合同其他费用实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractStageService",pidName = "contractId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractStageEntity> contractStageList = new ArrayList<>(); // 主合同付款阶段实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractClauseService",pidName = "contractId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractClauseEntity> contractClauseList = new ArrayList<>(); // 主合同条款实体

    @TableField(value="process_payment_ratio")
    private BigDecimal processPaymentRatio; // 过程付款比例

    public BigDecimal getProcessPaymentRatio() {
        return processPaymentRatio;
    }

    public void setProcessPaymentRatio(BigDecimal processPaymentRatio) {
        this.processPaymentRatio = processPaymentRatio;
    }

    @TableField(value="purchase_id")
    private String purchaseId; // 供货内容id
    @TableField(value="purchase_name")
    private String purchaseName; // 供货内容名称

    // CDGW-add
    @TableField(value="frame_contract_id")
    private Long frameContractId; // 框架协议主键ID
    @TableField(value="frame_contract_code")
    private String frameContractCode; // 框架协议编码
    @TableField(value="frame_contract_name")
    private String frameContractName; // 框架协议名称
    @TableField(value="frame_customer_id")
    private Long frameCustomerId; // 框架协议甲方Id
    @TableField(value="frame_customer_name")
    private String frameCustomerName; // 框架协议甲方名称
    @TableField(value="frame_supplier_id")
    private Long frameSupplierId; // 框架协议乙方Id
    @TableField(value="frame_supplier_name")
    private String frameSupplierName; // 框架协议乙方名称

    public Long getFrameContractId() {
        return frameContractId;
    }

    public void setFrameContractId(Long frameContractId) {
        this.frameContractId = frameContractId;
    }

    public String getFrameContractCode() {
        return frameContractCode;
    }

    public void setFrameContractCode(String frameContractCode) {
        this.frameContractCode = frameContractCode;
    }

    public String getFrameContractName() {
        return frameContractName;
    }

    public void setFrameContractName(String frameContractName) {
        this.frameContractName = frameContractName;
    }

    public Long getFrameCustomerId() {
        return frameCustomerId;
    }

    public void setFrameCustomerId(Long frameCustomerId) {
        this.frameCustomerId = frameCustomerId;
    }

    public String getFrameCustomerName() {
        return frameCustomerName;
    }

    public void setFrameCustomerName(String frameCustomerName) {
        this.frameCustomerName = frameCustomerName;
    }

    public Long getFrameSupplierId() {
        return frameSupplierId;
    }

    public void setFrameSupplierId(Long frameSupplierId) {
        this.frameSupplierId = frameSupplierId;
    }

    public String getFrameSupplierName() {
        return frameSupplierName;
    }

    public void setFrameSupplierName(String frameSupplierName) {
        this.frameSupplierName = frameSupplierName;
    }

    public String getContractContent() {
        return contractContent;
    }

    public void setContractContent(String contractContent) {
        this.contractContent = contractContent;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectPlace() {
        return projectPlace;
    }

    public void setProjectPlace(String projectPlace) {
        this.projectPlace = projectPlace;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }

    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }
    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }
    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }
    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }
    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }
    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public BigDecimal getFreeTaxMny() {
        return freeTaxMny;
    }

    public void setFreeTaxMny(BigDecimal freeTaxMny) {
        this.freeTaxMny = freeTaxMny;
    }
    public BigDecimal getFreeMny() {
        return freeMny;
    }

    public void setFreeMny(BigDecimal freeMny) {
        this.freeMny = freeMny;
    }
    public BigDecimal getFreeTax() {
        return freeTax;
    }

    public void setFreeTax(BigDecimal freeTax) {
        this.freeTax = freeTax;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBaseMoneyWithTax() {
        return baseMoneyWithTax;
    }

    public void setBaseMoneyWithTax(BigDecimal baseMoneyWithTax) {
        this.baseMoneyWithTax = baseMoneyWithTax;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeMnyWithTax() {
        return beforeChangeMnyWithTax;
    }

    public void setBeforeChangeMnyWithTax(BigDecimal beforeChangeMnyWithTax) {
        this.beforeChangeMnyWithTax = beforeChangeMnyWithTax;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingMnyWithTax() {
        return changingMnyWithTax;
    }

    public void setChangingMnyWithTax(BigDecimal changingMnyWithTax) {
        this.changingMnyWithTax = changingMnyWithTax;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    public BigDecimal getTotalPrepayMny() {
        return totalPrepayMny;
    }

    public void setTotalPrepayMny(BigDecimal totalPrepayMny) {
        this.totalPrepayMny = totalPrepayMny;
    }
    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }
    public BigDecimal getTotalOffsetMny() {
        return totalOffsetMny;
    }

    public void setTotalOffsetMny(BigDecimal totalOffsetMny) {
        this.totalOffsetMny = totalOffsetMny;
    }
    public BigDecimal getTotalSettlementMny() {
        return totalSettlementMny;
    }

    public void setTotalSettlementMny(BigDecimal totalSettlementMny) {
        this.totalSettlementMny = totalSettlementMny;
    }
    public BigDecimal getTotalSettlementTaxMny() {
        return totalSettlementTaxMny;
    }

    public void setTotalSettlementTaxMny(BigDecimal totalSettlementTaxMny) {
        this.totalSettlementTaxMny = totalSettlementTaxMny;
    }
    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }
    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ContractDetailEntity> getContractDetailList() {
        return contractDetailList;
    }

    public void setContractDetailList(List<ContractDetailEntity> contractDetailList) {
        this.contractDetailList = contractDetailList;
    }
    public List<ContractFeeEntity> getContractFeeList() {
        return contractFeeList;
    }

    public void setContractFeeList(List<ContractFeeEntity> contractFeeList) {
        this.contractFeeList = contractFeeList;
    }
    public List<ContractStageEntity> getContractStageList() {
        return contractStageList;
    }

    public void setContractStageList(List<ContractStageEntity> contractStageList) {
        this.contractStageList = contractStageList;
    }
    public List<ContractClauseEntity> getContractClauseList() {
        return contractClauseList;
    }

    public void setContractClauseList(List<ContractClauseEntity> contractClauseList) {
        this.contractClauseList = contractClauseList;
    }
}
