package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 主合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
@Api(value = "主合同实体", tags = {"主合同实体"})
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IContractService service;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractDetailService contractDetailService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return service.saveOrUpdate(saveorUpdateVO,authority,false);
    }

    /**
     * 新增或者修改补充协议
     *
     * @param supplement
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement, HttpServletRequest req) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        String authority = req.getHeader("authority");
        ContractVO vo = service.saveOrUpdateSupplement(supplement,authority,false);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag) {
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同无法新增补充协议！");
    }

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        // 物资采购合同合同类型
//        param.getParams().put("contract_type",new Parameter(QueryParam.EQ,0));
        return CommonResponse.success("查询列表数据成功！",this.queryContractList(param));
    }

    /**
     * 查询合同
     * @param param 查询参数
     * @return 查询结果
     */
    private JSONObject queryContractList(QueryParam param){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
//        param.getComplexParams().add(getPageQueryParam(null, false));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
//        orderMap.put("create_time", QueryParam.DESC);
        // 前端传入的排序
        orderMap.putAll(param.getOrderMap());
        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return page;
    }

    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        // 物资采购合同合同类型
        param.getParams().put("contract_type",new Parameter(QueryParam.EQ,0));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("proMaterialContract-export.xlsx", beans, response);
    }

    /**
     * 组织导出列表
     * @param param 查询条件
     * @param response 请求信息
     * @return 导出列表
     */
    private Map<String, Object> commonExcelExport(QueryParam param, HttpServletResponse response){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
//        param.getComplexParams().add(getPageQueryParam(null, false));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ContractEntity> list = service.queryList(param);
        List<ContractVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            voList = BeanMapper.mapList(list,ContractVO.class);
            voList.forEach(c -> {
                //流程状态
                c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        return beans;
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber,
                                                             @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        // 物资采购合同合同类型
        param.getParams().put("contract_type", new Parameter(QueryParam.EQ, 0));

        IPage<ContractEntity> page = this.queryContractListByRef(param, condition);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 查询参照
     *
     * @param param     查询参数
     * @param condition condition
     * @return 查询结果
     */
    private IPage<ContractEntity> queryContractListByRef(QueryParam param, String condition) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
//        // 获取合同归档控制参数
//        String valueData = service.getContractFilingCode();

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("orgId")) {
                param.getComplexParams().add(getPageQueryParam(Long.valueOf(String.valueOf(_con.get("orgId"))), true));
            }
            else {
                param.getComplexParams().add(getPageQueryParam(null, true));
            }
        }
        else {
            param.getComplexParams().add(getPageQueryParam(null, true));
        }

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        return service.queryPage(param, false);
    }

    /**
     * 获取合同查询复杂参数
     *
     * @param orgId 组织id
     * @param isRef 是否查询参照（true：查询参照，审批通过数据，false：包括自由态数据）
     * @return 复杂参数集合
     */
    public ComplexParam getPageQueryParam(Long orgId, boolean isRef) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        List<OrgVO> orgVOList = null;
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = iOrgApi.findParentsByOrgId(orgId);
        if (!orgResp.isSuccess() || !childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        parentOrgIds.remove(orgId);
        OrgVO orgVO = orgResp.getData();
        if (5 == orgVO.getOrgType()) {
            //说明是项目部   取自己本身和集采本上
            // 本下
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("org_id", new Parameter(QueryParam.EQ, orgId));
            if (isRef) {
                c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            }
            c1.getComplexParams().add(c2);

            // 本上集采+已生效
            if (CollectionUtils.isNotEmpty(parentOrgIds)) {
                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
                c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
                c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
                c1.getComplexParams().add(c3);

            }

        }
        else {
            //说明不是项目部，  取本下  和  集采本上
            // 本下
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
//            c2.getParams().put("parent_org_id", new Parameter(QueryParam.IN, childIds));
            c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
            // 参照查询审批通过的
            if (isRef) {
                c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            }
            c1.getComplexParams().add(c2);

            // 本上集采+已生效
            if (CollectionUtils.isNotEmpty(parentOrgIds)) {
                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
                c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
                c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
                c1.getComplexParams().add(c3);

            }
        }
        return c1;
    }

//    /**
//     * @Description saveOrUpdate 查询当前合同下付款申请单列表
//     * @param id
//     */
//    @RequestMapping(value = "/queryPaymentApplyList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<ContractPaymentResultVO> query(Long id) {
//        ContractPaymentResultVO vo = service.queryPaymentApplyList(id);
//        return CommonResponse.success("查询详情数据成功！", vo);
//    }

    /**
     * 校验合同能否新增变更、补充协议
     *
     * @param id 合同id
     * @return 校验结果
     */
    @RequestMapping(value = "/checkContractFiling", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkContractFiling(Long id) {
//        boolean filingFlag = service.checkContractFiling(id);
//        if (filingFlag) {
//            return CommonResponse.success("校验通过！");
//        }
        return CommonResponse.error("当前合同无法新增");
    }
}
