package com.ejianc.business.promaterial.contract.service;

import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Map;

/**
 * 主合同实体
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {

    /**
     * 保存或修改信息
     *
     * @param contractVo
     * @return
     */
    CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    ContractVO queryDetail(Long id);

    /**
     * 汇总合同原始金额--现合同金额
     *
     * @param queryParam
     */
    Map<String, Object> countContractAmount(QueryParam queryParam);

    ContractVO querySupplementRecord(Long id);

    ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO, String authority, Boolean isControl);

    ContractVO addConvertByConId(Long contractId);

    Boolean addSupplementFlag(Long id);


    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    boolean checkContract(Long id, Long otherId);

//    /**
//     * 查询合同付款申请列表
//     *
//     * @param id 合同id
//     * @return 查询结果
//     */
//    ContractPaymentResultVO queryPaymentApplyList(Long id);


}
