package com.ejianc.business.promaterial.contract.service.impl;

import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("contract") 
public class ContractBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IOrgApi orgApi;

	@Autowired
	private IContractService contractService;

	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success("审批处理成功！");
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success("合同审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		/*
			弃审逻辑：
			1、审批过程中，支持后台弃审；
			2、当审批通过，且没有走签章流程且没有下游业务时，支持后台弃审；
		 */
		ContractEntity contractEntity = contractService.selectById(billId);

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (res.isSuccess()) {
			//上级的集采合同不允许被撤回
			Long conorgid = contractEntity.getParentOrgId();//合同组织主键
			CommonResponse<OrgVO> conResp = orgApi.getOneById(conorgid);
			if (!conResp.isSuccess() || !conResp.isSuccess()) {
				return CommonResponse.error("查询合同组织信息失败！");
			}
			Long currentOrg = InvocationInfoProxy.getOrgId();
			String innerCode = conResp.getData().getInnerCode();
//			if(("2".equals(contractEntity.getPurchaseType()) || ("1".equals(contractEntity.getPurchaseType()) &&
//			contractEntity.getReplaceSignFlag() == 1))
			if ((PurchaseTypeEnum.公司集采.getCode().equals(contractEntity.getPurchaseType()))
					&& !innerCode.contains(String.valueOf(currentOrg))) {
				//说明-A组织innerCode包含了B主键，说明B是A的上级
				return CommonResponse.error("当前集采合同编制组织是【" + contractEntity.getParentOrgName() + "】，不可撤回！");
			}

			contractService.saveOrUpdate(contractEntity, false);
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		/**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		 if(!resp.isSuccess()){
		 return CommonResponse.error("无法撤回！"+resp.getMsg());
		 }*/
		return CommonResponse.success();
	}
}
