package com.ejianc.business.promaterial.check.service;

import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
public interface ICheckService extends IBaseService<CheckEntity> {

    CheckVO saveOrUpdates(CheckVO saveOrUpdateVO, Boolean isControl);

    void deletes(List<CheckVO> vos);

    CheckVO getRateAndPrice(CheckVO saveOrUpdateVO);

    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     * @return Map<String, Integer>
     */
    Map<String, Integer> countBillNum(Long projectId, Date checkDate);

}
