package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.mapper.DeliveryMapper;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryDetailVO;
import com.ejianc.business.promaterial.delivery.vo.DeliveryTypeEnum;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 消耗材-发货单
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService{
    @Autowired
    private IDeliveryService deliveryService;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_CODE = "XHC-DELIVERY-CODE";//此处需要根据实际修改
    private final String OPERATE = "XHC_DELIVERY_SYNC";
    private static final String BILL_TYPE_CODE = "BT220223000000002";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;

    @Override
    public CheckVO queryDetailToCheck(Long id) {
        DeliveryEntity deliveryEntity = deliveryService.selectById(id);

        //处理组合验收数据返回
        CheckVO checkVO = new CheckVO();
        checkVO.setOrderId(deliveryEntity.getOrderId());
        checkVO.setDeliveryId(deliveryEntity.getId());
        checkVO.setCheckState(0);
        checkVO.setContractId(deliveryEntity.getContractId());
        checkVO.setContractName(deliveryEntity.getContractName());
        checkVO.setContractCode(deliveryEntity.getContractCode());
        checkVO.setProjectCode(deliveryEntity.getProjectCode());
        checkVO.setProjectId(deliveryEntity.getProjectId());
        checkVO.setProjectName(deliveryEntity.getProjectName());
        checkVO.setSupplierId(deliveryEntity.getSupplierId());
        checkVO.setSupplierName(deliveryEntity.getSupplierName());
        checkVO.setDepartmentId(deliveryEntity.getDepartmentId());
        checkVO.setDepartmentName(deliveryEntity.getDepartmentName());
        checkVO.setLicensePlate(deliveryEntity.getLicensePlate());
        checkVO.setOrgId(deliveryEntity.getOrgId());
        checkVO.setOrgName(deliveryEntity.getOrgName());
        checkVO.setCheckType(deliveryEntity.getCheckType());
        checkVO.setCheckTypeName(deliveryEntity.getCheckTypeName());
        checkVO.setSourceType(1);
        checkVO.setParentOrgId(deliveryEntity.getParentOrgId());
        checkVO.setParentOrgName(deliveryEntity.getParentOrgName());
        checkVO.setDeliveryCode(deliveryEntity.getBillCode());
        ContractEntity contractEntity = contractService.selectById(deliveryEntity.getContractId());
        checkVO.setPricingType(contractEntity.getPricingType());
        checkVO.setAutomaticWeigh(deliveryEntity.getAutomaticWeigh());
        checkVO.setDeliveryType(deliveryEntity.getDeliveryType());
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        Map<Long, ContractDetailEntity> DetailMaterialIdMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
        Map<Long, ContractDetailEntity> DetailMaterialIdTypeMap = contractDetailList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
        //处理子表数据返回
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliveryNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1 )
                .collect(Collectors.toList());

        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)){
            List<Long> materialIDS = deliveryDetailEntityList.stream().map(DeliveryDetailEntity::getMaterialId)
                    .distinct().collect(Collectors.toList());
            List<MaterialPriceHistoryApiVO> priceHistoryApiVOS = priceHistoryService.getMaterialPriceHistoryApiVOS(materialIDS);
//            CommonResponse<List<MaterialVO>> commonResponse = shareMaterialApi.queryMaterialItemByIds(materialIDS);
//            logger.info("验收id：{}，查询成本科目信息：{}", id, JSONObject.toJSONString(commonResponse));
            Map<Long, MaterialVO> materialVOMap = new HashMap<>();
//            if (commonResponse.isSuccess()) {
//                List<MaterialVO> materialVOList = commonResponse.getData();
//                materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
//            }

            Map<Long, MaterialPriceHistoryApiVO> materialPriceMap = priceHistoryApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity()));
            ArrayList<CheckDetailVO> checkDetailVOS = new ArrayList<>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                CheckDetailVO checkDetailVO = new CheckDetailVO();
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(deliveryDetailEntity.getId());
                checkDetailVO.setOrderId(deliveryEntity.getOrderId());
                checkDetailVO.setOrderDetailId(deliveryDetailEntity.getOrderDetailId());
                checkDetailVO.setMaterialId(deliveryDetailEntity.getMaterialId());
                checkDetailVO.setMaterialName(deliveryDetailEntity.getMaterialName());
                checkDetailVO.setMaterialTypeId(deliveryDetailEntity.getMaterialTypeId());
                checkDetailVO.setMaterialTypeName(deliveryDetailEntity.getMaterialTypeName());
                checkDetailVO.setMaterialCode(deliveryDetailEntity.getMaterialCode());
                checkDetailVO.setUnit(deliveryDetailEntity.getUnit());
                checkDetailVO.setUnitId(deliveryDetailEntity.getUnitId());
                checkDetailVO.setSpec(deliveryDetailEntity.getSpec());
                checkDetailVO.setDetailAutomaticWeigh(deliveryDetailEntity.getDetailAutomaticWeigh());
                checkDetailVO.setDeliverNum(deliveryDetailEntity.getDeliveryNum());
                checkDetailVO.setCheckNum(deliveryDetailEntity.getDeliveryNum().subtract(deliveryDetailEntity.getCheckNum() == null ? BigDecimal.ZERO : deliveryDetailEntity.getCheckNum()));
                if (deliveryDetailEntity.getMaterialId() !=null && materialPriceMap.containsKey(deliveryDetailEntity.getMaterialId())){
                    checkDetailVO.setHistoryPriceArea(materialPriceMap.get(deliveryDetailEntity.getMaterialId()).getHistoryPriceArea());
                    checkDetailVO.setHistoryTaxPriceArea(materialPriceMap.get(deliveryDetailEntity.getMaterialId()).getHistoryTaxPriceArea());
                }

                if (deliveryDetailEntity.getMaterialId() !=null && materialVOMap.containsKey(checkDetailVO.getMaterialId())) {
                    MaterialVO materialVO = materialVOMap.get(checkDetailVO.getMaterialId());
//                    checkDetailVO.setSubjectId(materialVO.getSubjectId());
//                    checkDetailVO.setSubjectName(materialVO.getSubjectName());
                }

                checkDetailVO.setSourceId(deliveryDetailEntity.getSourceDetailId());
                if (DetailMaterialIdMap.containsKey(deliveryDetailEntity.getMaterialId())){//属于合同明细
                    ContractDetailEntity contractDetailEntity = DetailMaterialIdMap.get(deliveryDetailEntity.getMaterialId());
                    checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                    checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                    checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    checkDetailVO.setMemo(contractDetailEntity.getMemo());
                }
                if (!DetailMaterialIdMap.containsKey(deliveryDetailEntity.getMaterialId())){//不属于合同明细
                    if (DetailMaterialIdTypeMap.containsKey(deliveryDetailEntity.getMaterialTypeId())){//属于合同大类
                        ContractDetailEntity contractDetailEntity = DetailMaterialIdTypeMap.get(deliveryDetailEntity.getMaterialTypeId());
                        checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                        checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                        checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                        checkDetailVO.setMemo(contractDetailEntity.getMemo());
                    }
                    if (!DetailMaterialIdTypeMap.containsKey(deliveryDetailEntity.getMaterialTypeId())){//不属于合同大类
                        checkDetailVO.setTaxRate(contractEntity.getTaxRate());
                    }
                }
                //是否合同内 即是否合同明细或大类
                if (!DetailMaterialIdMap.containsKey(deliveryDetailEntity.getMaterialId()) && !DetailMaterialIdTypeMap.containsKey(deliveryDetailEntity.getMaterialTypeId())){
                    checkDetailVO.setContractFlag(2);
                }else {
                    checkDetailVO.setContractFlag(1);
                }
                checkDetailVOS.add(checkDetailVO);
            }
            checkVO.setCheckDetailList(checkDetailVOS);
        }
        return checkVO;
    }

    /**
     * type 0-关闭,1-新增和修改
     * @param id
     * @return
     */
    @Override
    @Transactional
    public DeliveryVO closeDelivery(Long id) {
        DeliveryEntity deliveryEntity = super.selectById(id);
        deliveryEntity.setCloseFlag(1);
        super.updateById(deliveryEntity);
        if(DeliveryTypeEnum.自制送货单.getCode().equals(deliveryEntity.getDeliveryType())){//自制发货单不推送供方
            return BeanMapper.map(deliveryEntity, DeliveryVO.class);
        }
        //推送供方数据
//        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//        if (!ejcCloudSystemCode.isSuccess()) {
//            throw new BusinessException("获取当前系统编码失败！");
//        }
//        Map<String,Object> map = new HashMap<>();
//        map.put("sourceId",deliveryEntity.getSourceId());
//        map.put("closeFlag",1);
//        map.put("systemId",ejcCloudSystemCode.getData());
//        String dataInfo = JSONObject.toJSONString(map);
//        Boolean updateSupplierStatus = updateSupplierStatus(deliveryEntity.getId(), dataInfo,PUSH_BILL_SERVER_URL,RequestMethod.POST,
//                deliveryEntity.getSupplierId().toString(),OPERATE,BILL_TYPE_CODE);
//        if (!updateSupplierStatus){
//            throw new BusinessException("单据推送失败！");
//        }
        return BeanMapper.map(deliveryEntity, DeliveryVO.class);
    }
    @Override
    public Boolean updateSupplierStatus(Long billId, String dataInfo, String url, RequestMethod method,String supplierId,String operate,String billTypeCode) {
        //推送供方
        //对单据进行加锁
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = jedisPool.getResource();
        try {
            locked = RedisTool.tryLock(jedis, key, operate, 600);
            if(!locked) {
                releaseLock(jedis, false, key, operate);
                logger.error("单据{}推送失败，单据锁获取失败-{}！", billId, locked);
                return false;
            }
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,method,dataInfo,supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, billPushResp.getMsg());
                }
            } else {
                logger.error("供方id-{}处理推送单据id-{}失败, {}", supplierId, billId, syncReqResp.getMsg());

            }
        } catch (Exception e) {
            logger.error("推送发货单单据id-{}给供方id-{} 异常，", billId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    @Override
    public DeliveryVO saveOrUpdates(DeliveryVO saveOrUpdateVO) {
        DeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, DeliveryEntity.class);
        List<DeliveryDetailVO> materialDeliveryDetailList = saveOrUpdateVO.getMaterialDeliveryDetailList();
        List<DeliveryDetailEntity> deliveryDetailEntityList = BeanMapper.mapList(materialDeliveryDetailList, DeliveryDetailEntity.class);
        entity.setDeliveryDetailList(deliveryDetailEntityList);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setCloseFlag(0);
        entity.setSourceType(1);
        entity.setDeliveryType(2);//发货类型  供方推送
        super.saveOrUpdate(entity, false);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return vo;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }


}
