package com.ejianc.business.promaterial.settlement.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/proMaterialSettle/")
public class ProMaterialSettleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlementService service;


    /**
     * 根据 项目无合同所有状态下材料、混凝土混凝土结算金额之和
     *
     * @return
     */
    @ApiOperation("根据 项目无合同所有状态下材料、混凝土结算金额之和")
    @RequestMapping(value = "/querySettleMnyProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querySettleMnyProjectId(@RequestParam("projectId") Long projectId) {
        logger.info("查询项目参数：{}", projectId);
        BigDecimal settleTaxMny = BigDecimal.ZERO;
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.isNull(SettlementEntity::getContractId);
        wrapper.eq(SettlementEntity::getProjectId,projectId);
        List<SettlementEntity> list = service.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            settleTaxMny = list.stream().map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("settleTaxMny",settleTaxMny);
        logger.info("查询结果：{}", jsonObject);
        return CommonResponse.success("查询成功", jsonObject);
    }
}
