package com.ejianc.business.promaterial.settlement.service;

import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 结算单主表
 * 
 * @author generator
 * 
 */
public interface ISettlementService extends IBaseService<SettlementEntity> {
    CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO);
    CommonResponse<Map> getDateMny(Long contractId);
    CommonResponse<String> delete(List<SettlementVO> vos);
    SettlementRecordVO querySettleRecord(Long contractId);

    /**
     * 根据合同id查询当前合同下结算列表
     * @param contractId 合同id
     * @return 查询结果
     */
    ContractSettlementRecordVO queryDetailRecord(Long contractId);

    /**
     * 根据合同id查询对应的结算列表
     *
     * @param settlementVO 合同id、结算类型
     * @return 查询结果
     */
    List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO);

    /**
     * 查询打印结算单材料明细，按子表材料+入库单价+结算单价  一致时合并；
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    List<PrintSettlementDetailVO> queryPrintSettlementDetail(SettlementVO settlementVO);

    /**
     * 查询打印结算单其他费用，当其他费用来源于合同同一清单时，合并
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    List<PrintSettlementFeeVO> queryPrintSettlementFee(SettlementVO settlementVO);
}
