package com.ejianc.business.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.settlement.bean.SettlementCollectEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementFeeEntity;
import com.ejianc.business.promaterial.settlement.mapper.SettlementMapper;
import com.ejianc.business.promaterial.settlement.service.ISettlementCollectService;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementFeeService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.*;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 结算单主表
 *
 * @author generator
 *
 */
@Service("settlementService")
public class SettlementServiceImpl extends BaseServiceImpl<SettlementMapper, SettlementEntity> implements ISettlementService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE_C = "JS_CODE";//此处需要根据实际修改
    private static final String BILL_CODE_H = "SHAHUN";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;//合同
    @Autowired
    private ISettlementCollectService settlementCollectService;//结算汇总
    @Autowired
    private IReconciliationDetailService reconciliationDetailService;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlementFeeService settlementFeeService; // 结算其他费用

    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private ISettlementDetailService settlementDetailService;

    @Autowired
    private IParamConfigApi paramConfigApi;

    private final String  OPERATE= "SETTLMENT_JS";
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private ICheckService checkService;

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settlement/saveSettlement";
    private static final String MBILL_TYPE = "BT220309000000003";//消耗
    private static final String CBILL_TYPE = "BT220316000000005";//混凝


    /*根据合同id查询*/
    @Override
    public SettlementRecordVO querySettleRecord(Long contractId) {
        SettlementRecordVO vo = new SettlementRecordVO();
        ContractEntity contractEntity = contractService.selectById(contractId);
        vo.setContractId(contractId);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, contractId);
        wrapper.eq(SettlementEntity::getDr, 0);
        wrapper.in(SettlementEntity::getBillState,1,3);
        wrapper.orderByAsc(SettlementEntity::getCreateTime);
        List<SettlementEntity> list = super.list(wrapper);
        List<SettlementVO> vos = BeanMapper.mapList(list, SettlementVO.class);
        if(CollectionUtils.isNotEmpty(vos)){
            BigDecimal totalSettlementTaxMny = vos.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementVO::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettlementTaxMny(totalSettlementTaxMny);
        }else{
            vo.setTotalSettlementTaxMny(BigDecimal.ZERO);
        }

        if(vo.getContractTaxMny()==null || BigDecimal.ZERO.compareTo(vo.getContractTaxMny()) == 0) {
            vo.setSettleRatio(BigDecimal.ZERO);
        } else {
            vo.setSettleRatio(vo.getTotalSettlementTaxMny().divide(vo.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        vo.setSettlementList(vos);
        //查询是否有最终结算单
        LambdaQueryWrapper<SettlementEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(SettlementEntity::getContractId, contractId);
        wrapper2.eq(SettlementEntity::getDr, 0);
        wrapper2.eq(SettlementEntity::getSignatureType, 1);//最终
        List<SettlementEntity> list2 = super.list(wrapper2);
        vo.setFlag(!CollectionUtils.isNotEmpty(list2));
        //查询是否有未生效的过程结算单
        LambdaQueryWrapper<SettlementEntity> wrapper3 = new LambdaQueryWrapper<>();
        wrapper3.eq(SettlementEntity::getContractId, contractId);
        wrapper3.eq(SettlementEntity::getDr, 0);
        wrapper3.notIn(SettlementEntity::getBillState, 1,3);
        wrapper3.eq(SettlementEntity::getSignatureType, 0);//过程
        List<SettlementEntity> list3 = super.list(wrapper3);
        vo.setFlagTwo(!CollectionUtils.isNotEmpty(list3));
        return vo;
    }

    @Override
    public CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO) {
        // 校验结算明细
        if(CollectionUtils.isEmpty(saveOrUpdateVO.getSettlementDetailList())){
            throw new BusinessException("检测到当前结算单的材料明细为空，无法保存！");
        }
        SettlementEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            String BILL_CODE = "";
            switch (entity.getSettlementType()){
                case 0:BILL_CODE = BILL_CODE_C;break;
                case 1:BILL_CODE = BILL_CODE_H;break;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (null!=entity.getContractId() && this.queryExist(entity.getContractId())){
                throw new BusinessException("该合同下有未生效的结算单！");
            }
        }else {
            this.delCollect(entity.getId());
            List<SettlementDetailEntity> detailDel = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(entity.getSettlementDetailList())){
                for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    if("del".equals(detail.getRowState())){
                        detailDel.add(detail);
                    }
                }
            }
            //删除结算状态
//            this.deleteAccount(detailDel,entity.getContractId());
        }
        //初始化签章，签字状态
        entity.setSignStatus(0);
        entity.setSignatureStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        entity.setProportionFlag("0");// 分摊状态(1:是，0：否)
        entity.setRelationFlag("0");// 关联状态(1:是，0：否)
        if(entity.getContractId()!=null){//有合同同保存
            if(CollectionUtils.isNotEmpty(entity.getSettlementDetailList())){
                ContractEntity contractEntity = contractService.selectById(entity.getContractId());
                List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
                if(CollectionUtils.isEmpty(contractDetailList)){
                    throw new BusinessException("结算明细在合同【"+entity.getContractName()+"】中不存在，请变更合同后再结算");
                }
                List<String> materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialId().toString()).collect(Collectors.toList());
                List<String> materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId()!=null &&!ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialTypeId().toString()).collect(Collectors.toList());
                for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    if(!"del".equals(detail.getRowState())){
                        boolean flag = true;
                        String materialTypeId = detail.getMaterialTypeId()==null?"":detail.getMaterialTypeId().toString();
                        String materialId = detail.getMaterialId()==null?"":detail.getMaterialId().toString();
                        if(materialTypeIds.contains(materialTypeId)){//结算明细有合同分类
                            flag = false;
                        }
                        if(materialIds.contains(materialId)){//结算明细有合同明细
                            flag = false;
                        }
                        if(flag){
                            throw new BusinessException("材料【"+detail.getMaterialName()+"】在合同【"+entity.getContractName()+"】中不存在，请变更合同后再结算");
                        }
                    }
                }
            }
        }
        super.saveOrUpdate(entity, false);
        // 推送目标成本
//        this.pushTargetCost2(entity.getId());
        //保存结算信息
//        this.updateAccount(entity);
        // 推送实际成本
//        this.saveCost(entity,0);

        SettlementVO vo = BeanMapper.map(entity, SettlementVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /*是否有为生效的结算单*/
    public boolean queryExist(Long contractId){
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, contractId);
        wrapper.notIn(SettlementEntity::getBillState, 1, 3);//未生效条件
        List<SettlementEntity> list = super.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {//有数据表示有未生效的结算单
            return true;
        }
        return false;
    }

    /*删除汇总*/
    public void delCollect(Long id) {
        LambdaQueryWrapper<SettlementCollectEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementCollectEntity::getSettlementId, id);
        List<SettlementCollectEntity> list = settlementCollectService.list(wrapper);
        List<Long> ids = list.stream().map(SettlementCollectEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            settlementCollectService.removeByIds(ids);
        }
    }

    /*修对账子表结算状态
       @param: ids 要修改对账子表id集合
       @param: flag 0-未引用 1-引用
       */
    private void uapdeRD(List ids,Integer flag){
        if(CollectionUtils.isNotEmpty(ids)){
            logger.info("子表键值:"+JSONObject.toJSONString(ids));
            LambdaQueryWrapper<ReconciliationDetailEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(ReconciliationDetailEntity::getId, ids);
            List<ReconciliationDetailEntity> list = reconciliationDetailService.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                logger.info("对账子表数据:"+JSONObject.toJSONString(list));
                list.forEach(item->{
                    item.setReconciliationState(flag);
                });
                reconciliationDetailService.saveOrUpdateBatch(list, list.size(), false);
                logger.info("修改状态成功--"+JSONObject.toJSONString(list));
            }
        }
    }

    /*获取最近一次含本期结算金额和结算日期 ，结算次数*/
    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        Map<String, Object> map = new HashMap<>();
        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)
        String sTDate  = null;
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(SettlementEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(SettlementEntity::getDr, 0);
        wrapper.eq(SettlementEntity::getContractId, contractId);
        List<SettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            SettlementEntity settlementEntity = list.get(0);
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny  = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            sTDate = DateFormatUtil.formatDate("yyyy-MM-dd", settlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny",currentTaxMny);
        map.put("currentMny",currentMny);
        map.put("sTDate",sTDate);
        map.put("settlementNum",list.size());
        return CommonResponse.success("获取金额和时间、结算次数成功,！",map);
    }


    /*更新无合同合同id态*/
    public void updateContractId(List<Long> ids,Long contractId,String contractName) {
        logger.info("合同id更新信息，更新ids:{}--合同id:{}",JSONObject.toJSONString(ids),contractId);
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id",new Parameter(QueryParam.IN,ids));
        List<CheckEntity> checkEntities = checkService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(checkEntities)){
            List<CheckEntity> collect = checkEntities.stream().map(item -> {
                item.setContractId(contractId);
                item.setCheckerName(contractName);
                return item;
            }).collect(Collectors.toList());
            checkService.updateBatchById(collect);
            logger.info("合同id更新信息，材料更新信息:{}",JSONObject.toJSONString(collect));
        }
    }

    /*删除*/
    @Override
    public CommonResponse<String> delete(List<SettlementVO> vos) {
        //目标成本推送
//        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        for(SettlementVO vo:vos){
            //修改 入库 结算状态
            SettlementEntity settlementEntity = super.selectById(vo.getId());
//            this.deleteAccount(settlementEntity.getSettlementDetailList(),settlementEntity.getContractId());
//            ExecutionVO executionVO = this.targetCost2(BeanMapper.map(settlementEntity, SettlementVO.class),"",settlementEntity.getSettlementType());
//            totalExecutionVOList.add(executionVO.getTotalVO());
//            //删除 实际成本池数据
//            CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(vo.getId());
//            logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
//            if(!stringCommonResponse.isSuccess()){
//                throw new BusinessException(stringCommonResponse.getMsg());
//            }
        }
//        if(CollectionUtils.isNotEmpty(totalExecutionVOList)){
//            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
//            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
//            if (!response.isSuccess()){
//                throw new BusinessException("目标成本推送失败,"+response.getMsg());
//            }
//        }
        super.removeByIds(vos.stream().map(SettlementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    /**
     * 根据合同id查询当前合同下结算列表
     *
     * @param contractId 合同id
     * @return 查询结果
     */
    @Override
    public ContractSettlementRecordVO queryDetailRecord(Long contractId) {
        ContractSettlementRecordVO settleRecordVO = new ContractSettlementRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettlementEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE
                .getBillStateCode());
        listQuery.orderByDesc("settlement_date");
        List<SettlementEntity> list = super.list(listQuery);
        List<SettlementVO> rentSettlementVOS = BeanMapper.mapList(list, SettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);

        //累计结算金额
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            contractSettleMny = list.stream().map(SettlementEntity::getSettlementTaxMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);

        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        }
        else {
            settleRecordVO.setSettleRate((settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100)))
                    .divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    /**
     * 根据合同id查询对应的结算列表
     *
     * @param settlementVO 合同id、结算类型
     * @return 查询结果
     */
    @Override
    public List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO) {
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        List<SettlementVO> rtnList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            rtnList = BeanMapper.mapList(list, SettlementVO.class);
            for (SettlementVO vo : rtnList) {
                vo.setSettlementDateStr(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSettlementDate()));
                vo.setBillCodeLink(vo.getBillCode());
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        return rtnList;
    }

    /**
     * 根据项目+供应商查询所有状态的无合同材料结算+无合同混凝土结算金额+本期金额
     *
     * @param vo 结算信息
     * @return 查询结果
     */
    private BigDecimal getNoContractSupplierMny(SettlementVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, vo.getProjectId()));
        queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, vo.getSupplierId()));
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, null));
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        List<SettlementEntity> entityList = super.queryList(queryParam, false);
        BigDecimal sum = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
        if (CollectionUtils.isEmpty(entityList)) return sum;
        for (SettlementEntity entity : entityList) {
            sum = sum.add(CommonUtils.setBigDecimalDefaultValue(entity.getSettlementTaxMny()));
        }
        return sum;
    }

    /**
     * 查询打印结算单材料明细，按子表材料+入库单价+结算单价  一致时合并；
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    @Override
    public List<PrintSettlementDetailVO> queryPrintSettlementDetail(SettlementVO settlementVO) {
        List<PrintSettlementDetailVO> rtnList = new ArrayList<>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List<Long> idList = list.stream().map(SettlementEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter(QueryParam.IN, idList));
        List<SettlementDetailEntity> detailEntityList = settlementDetailService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(detailEntityList)) return rtnList;
        // 查找本期数据
        Map<Long, List<SettlementDetailEntity>> thisMap = new HashMap<>();
        if (settlementVO.getId() != null) {
            List<SettlementDetailEntity> thisDetailList = detailEntityList.stream()
                    .filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
        }
        // 组装数据，相同的合同
        Map<String, PrintSettlementDetailVO> map = new HashMap<>();
        String key;
        for (SettlementDetailEntity detailEntity : detailEntityList) {
            key = "" + detailEntity.getMaterialId() + detailEntity.getStoreTaxPrice() + detailEntity.getTaxPrice();
            PrintSettlementDetailVO printVo;
            if (map.containsKey(key)) {
                printVo = map.get(key);
                BigDecimal storeSum = CommonUtils.addBigDecimal(printVo.getStoreNum(), detailEntity.getStoreNum());
                BigDecimal sum = CommonUtils.addBigDecimal(printVo.getNum(), detailEntity.getNum());
                BigDecimal storeTaxMny = CommonUtils.addBigDecimal(printVo.getStoreTaxMny(), detailEntity.getStoreTaxMny());
                BigDecimal taxMny = CommonUtils.addBigDecimal(printVo.getTaxMny(), detailEntity.getTaxMny());

                printVo.setStoreNum(storeSum);
                printVo.setNum(sum);
                printVo.setStoreTaxMny(storeTaxMny);
                printVo.setTaxMny(taxMny);
                printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
            }
            else {
                printVo = BeanMapper.map(detailEntity, PrintSettlementDetailVO.class);
                List<SettlementDetailEntity> thisMaterialList = thisMap.get(detailEntity.getMaterialId());
                BigDecimal thisSettleNum = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(thisMaterialList)) {
                    for (SettlementDetailEntity settlementDetailEntity : thisMaterialList) {
                        thisSettleNum = thisSettleNum.add(CommonUtils.setBigDecimalDefaultValue(settlementDetailEntity.getNum()));
                    }
                }
                printVo.setThisSettleNum(thisSettleNum);
                printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
                map.put(key, printVo);
            }
        }
        rtnList = new ArrayList<>(map.values());
        // 排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator
                    .comparing(PrintSettlementDetailVO::getThisSettleNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed()
                    .thenComparing(PrintSettlementDetailVO::getNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    /**
     * 查询打印结算单其他费用，当其他费用来源于合同同一清单时，合并
     *
     * @param settlementVO 结算单信息
     * @return 查询结果
     */
    @Override
    public List<PrintSettlementFeeVO> queryPrintSettlementFee(SettlementVO settlementVO) {
        List<PrintSettlementFeeVO> rtnList = new ArrayList<>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List<Long> idList = list.stream().map(SettlementEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter(QueryParam.IN, idList));
        List<SettlementFeeEntity> feeEntityList = settlementFeeService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(feeEntityList)) return rtnList;
        // 查找本期数据
        Map<Long, List<SettlementFeeEntity>> thisMap = new HashMap<>();
        Map<Long, SettlementFeeEntity> thisNoContractMap = new HashMap<>();
        if (settlementVO.getId() != null) {
            List<SettlementFeeEntity> thisDetailList = feeEntityList.stream()
                    .filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            // 来源合同的sourceId不为空，sourceId=contractId，sourceDetailId=对应合同其他费用id
            thisMap = thisDetailList.stream().filter(t -> t.getSourceId() != null)
                    .collect(Collectors.groupingBy(SettlementFeeEntity::getSourceDetailId));
            // 无合同处理 不进行合同
            thisNoContractMap = thisDetailList.stream().filter(t -> t.getSourceId() == null)
                    .collect(Collectors.toMap(SettlementFeeEntity::getId, Function.identity(), (key1, key2) -> key2));
        }
        // 组装数据，相同的合同
        Map<String, PrintSettlementFeeVO> map = new HashMap<>();
        for (SettlementFeeEntity feeEntity : feeEntityList) {
            // 来源不是合同的跳过处理
            PrintSettlementFeeVO printFeeVo;
            if (feeEntity.getSourceId() == null) {
                printFeeVo = BeanMapper.map(feeEntity, PrintSettlementFeeVO.class);
                SettlementFeeEntity thisFeeEntity = thisNoContractMap.get(feeEntity.getId());
                if (thisFeeEntity != null) {
                    printFeeVo.setThisFeeNum(CommonUtils.setBigDecimalDefaultValue(thisFeeEntity.getFeeNum()));
                }
                rtnList.add(printFeeVo);
                continue;
            }
            String key = "" + feeEntity.getSourceId() + feeEntity.getSourceDetailId();
            if (map.containsKey(key)) {
                printFeeVo = map.get(key);
                BigDecimal feeNum = CommonUtils.addBigDecimal(printFeeVo.getFeeNum(), feeEntity.getFeeNum());
                BigDecimal feeTaxMny = CommonUtils.addBigDecimal(printFeeVo.getFeeTaxMny(), feeEntity.getFeeTaxMny());

                printFeeVo.setFeeNum(feeNum);
                printFeeVo.setFeeTaxMny(feeTaxMny);
            }
            else {
                printFeeVo = BeanMapper.map(feeEntity,PrintSettlementFeeVO.class);
                List<SettlementFeeEntity> thisFeeList = thisMap.get(feeEntity.getSourceDetailId());
                BigDecimal thisNum = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(thisFeeList)) {
                    for (SettlementFeeEntity feeEntity1 : thisFeeList) {
                        thisNum = thisNum.add(CommonUtils.setBigDecimalDefaultValue(feeEntity1.getFeeNum()));
                    }
                }
                printFeeVo.setThisFeeNum(thisNum);
                map.put(key, printFeeVo);
            }
        }
        rtnList.addAll(new ArrayList<>(map.values()));
        // 排序 默认按其中本期数量 从 大到小排序，当本期数量一致或为空时，按结算数量从大到小排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator
                    .comparing(PrintSettlementFeeVO::getThisFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed()
                    .thenComparing(PrintSettlementFeeVO::getFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    /**
     * 根据合同id查询结算单列表
     *
     * @param settlementVO 合同id、结算单类型
     * @return 查询结果
     */
    private List<SettlementEntity> queryListByContractId(SettlementVO settlementVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, settlementVO.getContractId()));
        queryParam.getParams().put("settlementType", new Parameter(QueryParam.EQ, settlementVO.getSettlementType()));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
//        if(settlementVO.getId() != null){
//            queryParam.getParams().put("id", new Parameter(QueryParam.NE, settlementVO.getId()));
//        }
        queryParam.getOrderMap().put("settlementDate", QueryParam.DESC);
        return super.queryList(queryParam, false);
    }

}
