package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 主合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
@Api(value = "主合同实体", tags = {"主合同实体"})
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractService service;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;

    @Autowired
    private ISupplierApi supplierApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return service.saveOrUpdate(saveorUpdateVO,authority,false);
    }

    @ApiOperation("框架协议新增或者修改")
    @RequestMapping(value = "/saveOrUpdateFrame", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateFrame(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        return service.saveOrUpdateFrame(saveorUpdateVO);
    }

    /**
     * 新增或者修改补充协议
     *
     * @param supplement
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement, HttpServletRequest req) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        String authority = req.getHeader("authority");
        ContractVO vo = service.saveOrUpdateSupplement(supplement,authority,false);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag) {
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同无法新增补充协议！");
    }

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        param.getParams().put("frame_flag",new Parameter(QueryParam.EQ,0));
        return CommonResponse.success("查询列表数据成功！",this.queryContractList(param));
    }

    @RequestMapping(value = "/pageFrameList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageFrameList(@RequestBody QueryParam param) {
        param.getParams().put("frame_flag",new Parameter(QueryParam.EQ,1));
        return CommonResponse.success("查询列表数据成功！",this.queryContractList(param));
    }

    @RequestMapping(value = "/pageGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageGFList(@RequestBody QueryParam param) {
        //todo frame_flag 需要前端传
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        //供方我的框架协议
        //1, 先根据供方租户主键查询到合作的企业(采购租户的租户主键)
        // 查询合作企业的租户主键
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
            logger.info("合作企业信息：{}",systemIdList);
            if(CollectionUtils.isNotEmpty(systemIdList)){
                param.getParams().put("tenant_id", new Parameter("in",systemIdList));
        }
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState",new Parameter(QueryParam.IN,billStateList));
        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        // 前端传入的排序
        orderMap.putAll(param.getOrderMap());
        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(param,false);

        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 合同状态修改
     *
     * @param contractVO
     * @return
     */
    @RequestMapping(value = "/changeState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ContractVO contractVO) {
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ContractEntity::getId,contractVO.getId());
        updateWrapper.set(ContractEntity::getPerformanceStatus, contractVO.getPerformanceStatus());
        service.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 查询合同
     * @param param 查询参数
     * @return 查询结果
     */
    private JSONObject queryContractList(QueryParam param){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
//        orderMap.put("create_time", QueryParam.DESC);
        // 前端传入的排序
        orderMap.putAll(param.getOrderMap());
        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return page;
    }

    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("frame_flag",new Parameter(QueryParam.EQ,0));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("proMaterialContract-export.xlsx", beans, response);
    }

    @ApiOperation("导出")
    @RequestMapping(value = "/excelFrameExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelFrameExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("frame_flag",new Parameter(QueryParam.EQ,1));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("frameContract-export.xlsx", beans, response);
    }

    /**
     * 组织导出列表
     * @param param 查询条件
     * @param response 请求信息
     * @return 导出列表
     */
    private Map<String, Object> commonExcelExport(QueryParam param, HttpServletResponse response){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ContractEntity> list = service.queryList(param);
        List<ContractVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            voList = BeanMapper.mapList(list,ContractVO.class);
            voList.forEach(c -> {
                if(org.apache.commons.lang.StringUtils.isBlank(c.getPerformanceStatus())) {
                    c.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                } else {
                    c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                }
                //流程状态
                c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        return beans;
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber,
                                                             @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        IPage<ContractEntity> page = this.queryContractListByRef(param, condition);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 查询参照
     *
     * @param param     查询参数
     * @param condition condition
     * @return 查询结果
     */
    private IPage<ContractEntity> queryContractListByRef(QueryParam param, String condition) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("frame_flag", new Parameter(QueryParam.EQ, 0));//默认查合同参照
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("frameFlag")) {
                param.getParams().put("frame_flag", new Parameter(QueryParam.EQ, 1));
            }
        }
        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        return service.queryPage(param, false);
    }


//    /**
//     * @Description saveOrUpdate 查询当前合同下付款申请单列表
//     * @param id
//     */
//    @RequestMapping(value = "/queryPaymentApplyList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<ContractPaymentResultVO> query(Long id) {
//        ContractPaymentResultVO vo = service.queryPaymentApplyList(id);
//        return CommonResponse.success("查询详情数据成功！", vo);
//    }

}
