package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.bean.ContractChangeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.*;
import com.ejianc.business.promaterial.contract.mapper.ContractMapper;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 主合同实体
 *
 * @author generator
 *
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** 物资合同 */
    private static final String PURCHASE_CONTRACT_BILL_CODE = "CONTRACT_MATERIAL";

    private static final String FRAME_CONTRACT_BILL_CODE = "CONTRACT_FRAME";
//    /** 合同类型（0-物资采购合同，1-混凝土合同） */
//    private static final Integer CONTRACT_TYPE_0 = 0;
//    /** 合同类型（0-物资采购合同，1-混凝土合同） */
//    private static final Integer CONTRACT_TYPE_1 = 1;

    @Autowired
    private IContractChangeService contractChangeService;

    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractService service;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        if (contractVo.getOrgId() != null && (StringUtils.isEmpty(contractVo.getOrgCode())
                || StringUtils.isEmpty(contractVo.getParentOrgCode()) || StringUtils.isEmpty(contractVo.getOrgName()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVo.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                contractVo.setOrgCode(orgVO.getCode());
                if(StringUtils.isEmpty(contractVo.getOrgName())){
                    contractVo.setOrgName(orgVO.getName());
                }
                // 项目部
                if(5 == orgVO.getOrgType()){
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        contractVo.setParentOrgId(parentOrgVO.getId());
                        contractVo.setParentOrgCode(parentOrgVO.getCode());
                        contractVo.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    contractVo.setParentOrgId(contractVo.getOrgId());
                    contractVo.setParentOrgCode(contractVo.getOrgCode());
                    contractVo.setParentOrgName(contractVo.getOrgName());
                }
            }
        }
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        if (!isControl){
            if (StringUtils.isEmpty(contractVo.getBillCode())) {
                // 合同编码生成
                entity.setBillCode(this.getContractBillCode(contractVo));
            }
        }
        if (entity.getId() == null) {
            //设置归档状态
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(0);
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("frame_flag", new Parameter("eq", 0));//过滤框架协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("frame_flag", new Parameter("eq", 0));//过滤框架协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setId(IdWorker.getId());

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());

        if (!isControl) {
            boolean saveFlag = super.saveOrUpdate(entity, false);
            if (!saveFlag) {
                throw new BusinessException("保存失败！");
            }
        }

        return CommonResponse.success(BeanMapper.map(entity, ContractVO.class));
    }

    @Override
    public CommonResponse<ContractVO> saveOrUpdateFrame(ContractVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(FRAME_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid(),contractVo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置归档状态
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(0);
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("frame_flag", new Parameter("eq", 1));//只查框架协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("frame_flag", new Parameter("eq", 1));//只查框架协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setId(IdWorker.getId());

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());

        boolean saveFlag = super.saveOrUpdate(entity, false);
        if (!saveFlag) {
            throw new BusinessException("保存失败！");
        }

        return CommonResponse.success(BeanMapper.map(entity, ContractVO.class));
    }

    /**
     * 生成合同编码规则
     *
     * @param contractVo 合同vo
     * @return 生成结果
     */
    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
        BillCodeParam billCodeParam = BillCodeParam
                .build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            contractBillCode = billCode.getData();
        }
        else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return contractBillCode;
    }


    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        //主合同
        ContractEntity mainContract = service.selectById(contractVo.getMainContractId());
        if(null == mainContract) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }
        if (!isControl) {
            if (StringUtils.isEmpty(contractVo.getBillCode())) {
                QueryParam billCodeParam = new QueryParam();
                billCodeParam.getParams().put("main_contract_id", new Parameter("eq", contractVo.getMainContractId()));
                List<Integer> billStateList = new ArrayList<>();
                billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                billCodeParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
                List<ContractEntity> billCOdeSupplementList = service.queryList(billCodeParam, false);
                String supplementNum = "";
                if (billCOdeSupplementList.size() < 9) {
                    supplementNum += "0" + (billCOdeSupplementList.size() + 1);
                }else {
                    supplementNum += (billCOdeSupplementList.size() + 1);
                }
                //设置补充协议编码
                entity.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {

            //校验：补充协议只能存在一条未生效的
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", contractVo.getMainContractId()));
            List<ContractEntity> supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!((e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });

            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        // 校验其他单据
        this.checkContract(contractVo.getMainContractId(), contractVo.getId());
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if ("1".equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        if (!isControl){
            super.saveOrUpdate(entity, false);
        }
        return BeanMapper.map(entity, ContractVO.class);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = super.selectById(contractId);
        ContractVO supplementVO = new ContractVO();


        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());

//        supplementVO.setTargetResultId(contractVO.getTargetResultId());
//        supplementVO.setTargetResultName(contractVO.getTargetResultName());
        supplementVO.setSignPlace(contractVO.getSignPlace());
        supplementVO.setCustomerEmployeeId(contractVO.getCustomerEmployeeId());
        supplementVO.setCustomerEmployeeName(contractVO.getCustomerEmployeeName());
        supplementVO.setCustomerEmployeeMobile(contractVO.getCustomerEmployeeMobile());
        supplementVO.setSupplierEmployeeName(contractVO.getSupplierEmployeeName());
        supplementVO.setSupplierEmployeeMobile(contractVO.getSupplierEmployeeMobile());
        supplementVO.setPricingType(contractVO.getPricingType());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectPlace(contractVO.getProjectPlace());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setSignDate(new Date());
        supplementVO.setSupplementFlag(1);
        supplementVO.setFrameFlag(0);
        supplementVO.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");
        supplementVO.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        supplementVO.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        supplementVO.setMainContractCreateDate(contractVO.getMainContractCreateDate());
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setFilingStatus(0);
        supplementVO.setPurchaseId(contractVO.getPurchaseId());
        supplementVO.setPurchaseName(contractVO.getPurchaseName());

        return supplementVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = super.selectById(id);
        entity.setContractDetailList(null);
        ContractVO contractVo = BeanMapper.map(entity, ContractVO.class);
        List<ContractDetailEntity> details = null;
        LambdaQueryWrapper<ContractDetailEntity> lambda = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, id);
        lambda.ne(ContractDetailEntity::getChangeType, ChangeTypeEnum.中止项);
        details = contractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setContractDetailList(BeanMapper.mapList(details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_money_with_tax) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
//
        return resp;
    }

    /**
     * 查询当前合同下补充协议列表
     *
     * @param id
     * @return
     */
    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO recordVO = new ContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        recordVO.setId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());

        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.orderByDesc("create_time");
        List<ContractEntity> supplementEntities = super.list(query);

        recordVO.setSupplementList(BeanMapper.mapList(supplementEntities, ContractVO.class));
        //补充协议次数
        recordVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementEntities)) {
            allSupplementAmt = supplementEntities.stream().map(e -> e.getContractTaxMny() == null ? BigDecimal.ZERO : e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        //设置补充金额比例
        recordVO.setSupplementAmtRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if ((BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        // 非履约中合同不允许新增补充协议
        if(!PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())){
            return false;
        }
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, 1);
        lambda.and((c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }


    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    @Override
    public boolean checkContract(Long id, Long otherId) {
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        // 存在非审批通过或非签章通过的补充协议，不允许做其他业务
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        supplementQueryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<ContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        // 存在未生效的补充协议，则抛出异常
        if (CollectionUtils.isNotEmpty(supplementContractList)) {
            throw new BusinessException("存在未生效的补充协议！");
        }

        // 校验变更合同
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        // 做修改时，排除当前单据的id
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        List<ContractChangeEntity> contractChangeEntityList = contractChangeService.queryList(queryParam, false);
        // 存在未生效的变更合同，则抛出异常
        if (CollectionUtils.isNotEmpty(contractChangeEntityList)) {
            throw new BusinessException("存在未生效的变更合同！");
        }

        return true;
    }

}
