package com.ejianc.business.promaterial.delivery.service.impl;

import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.enums.DeliverCheckStateEnum;
import com.ejianc.business.promaterial.delivery.mapper.DeliveryMapper;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryDetailVO;
import com.ejianc.business.promaterial.delivery.vo.DeliveryVO;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材-发货单
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService{
    @Autowired
    private IDeliveryService deliveryService;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IOrderService orderService;


    /**
     * type 0-关闭,1-新增和修改
     * @param id
     * @return
     */
    @Override
    @Transactional
    public DeliveryVO closeDelivery(Long id) {
        DeliveryEntity deliveryEntity = super.selectById(id);
        deliveryEntity.setOrderFlag(1);
        super.updateById(deliveryEntity);
        return BeanMapper.map(deliveryEntity, DeliveryVO.class);
    }


    @Override
    public DeliveryVO queryInitDelivery(DeliveryVO deliveryVO) {
        OrderEntity orderEntity = orderService.selectById(deliveryVO.getId());
        List<Long> detailIdList = deliveryVO.getDeliveryDetailList().stream().map(DeliveryDetailVO::getId).collect(Collectors.toList());
        DeliveryVO vo = BeanMapper.map(orderEntity, DeliveryVO.class);
        vo.setOrderFlag(0);
        vo.setOrderId(orderEntity.getId());
        vo.setOrderBillCode(orderEntity.getBillCode());
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setCheckState(DeliverCheckStateEnum.WAIT_CHECK.getCode());

        List<DeliveryDetailVO> list = new ArrayList<>();
        for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
            if (detailIdList.contains(orderDetailEntity.getId())){
                DeliveryDetailVO detailVO = BeanMapper.map(orderDetailEntity,DeliveryDetailVO.class);
                detailVO.setOrderId(orderDetailEntity.getOrderId());
                detailVO.setOrderDetailId(orderDetailEntity.getId());
                // 订单发货数量默认未发货数量
                detailVO.setUnDeliverNum(orderDetailEntity.getOrderNum());
                detailVO.setId(null);
                list.add(detailVO);
            }
        }
        vo.setDeliveryDetailList(list);
        return vo;
    }

    @Override
    public CheckVO queryDetailToCheck(Long id) {
        DeliveryEntity deliveryEntity = deliveryService.selectById(id);

        //处理组合验收数据返回
        CheckVO vo = BeanMapper.map(deliveryEntity, CheckVO.class);
        vo.setDeliverId(deliveryEntity.getId());
        vo.setDeliveryBillCode(deliveryEntity.getBillCode());
        vo.setDeliveryType(1);
        vo.setId(null);
        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);


        //处理子表数据返回
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliverNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1 ).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)){
            ArrayList<CheckDetailVO> checkDetailVOS = new ArrayList<>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                CheckDetailVO checkDetailVO = BeanMapper.map(deliveryDetailEntity, CheckDetailVO.class);
                checkDetailVO.setRowState("add");
                checkDetailVO.setBillSourceType(1);
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(checkDetailVO.getId());

                checkDetailVOS.add(checkDetailVO);
            }
            vo.setCheckDetailList(checkDetailVOS);
        }
        return vo;
    }



}
