package com.ejianc.business.promaterial.pricelib.service.impl;

import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.pricelib.bean.PriceSettlementEntity;
import com.ejianc.business.promaterial.pricelib.mapper.PriceSettlementMapper;
import com.ejianc.business.promaterial.pricelib.service.IPriceSettlementService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 价格库-结算明细
 * 
 * @author generator
 * 
 */
@Service("priceSettlementService")
public class PriceSettlementServiceImpl extends BaseServiceImpl<PriceSettlementMapper, PriceSettlementEntity> implements IPriceSettlementService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IContractService contractService;

    /**
     * 定时处理合同价格库明细
     * 如果传入日期为空，则为初始化，处理全部合同（已提交、审批通过）明细
     *
     * @param date 日期
     */
    @Override
    public void savePriceSettleByTiming(Date date) {
//        QueryParam queryParam = new QueryParam();
//        List<SettlementEntity> settlementEntityList;
//        if (date != null) {
//            // 日期不为空，则取大于上日日期数据
//            Date qDate = DateUtils.calculationDay(date, -1);
//            settlementEntityList = baseMapper.getSettlementListByTime(qDate);
//        }
//        else {
//            // 日期为空，默认为初始化，取提交后的数据
//            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
//            settlementEntityList = settlementService.queryList(queryParam, false);
//        }
//        // 结算列表为空，不处理
//        if (CollectionUtils.isEmpty(settlementEntityList)) return;
//        //查询合同
//        List<Long> contractIds = settlementEntityList.stream().filter(t->t.getContractId()!=null).map(SettlementEntity::getContractId).collect(Collectors.toList());
//        List<ContractEntity> contractListByIds = baseMapper.getContractListByIds(contractIds);
//        Map<Long, ContractEntity> contractEntityMap = contractListByIds.stream().filter(t->t.getId()!=null)
//                .collect(Collectors.toMap(ContractEntity::getId, Function.identity(),
//                        (key1, key2) -> key2));
//        // 查询结算明细
//        List<Long> settlementIdList = settlementEntityList.stream().map(SettlementEntity::getId).collect(Collectors.toList());
//        List<SettlementDetailEntity> detailEntityList = baseMapper.getSettlementDetailListBySettlementId(settlementIdList);
//        // 结算明细列表为空，不处理
//        if (CollectionUtils.isEmpty(detailEntityList)) return;
//        // 查询材料内码
//        List<Long> materialTypeIdList = detailEntityList.stream().map(SettlementDetailEntity::getMaterialTypeId)
//                .distinct().collect(Collectors.toList());
//        CommonResponse<List<MaterialCategoryVO>> materialResponse = materialApi
//                .queryCategoryListByIds(materialTypeIdList);
//        Map<Long, String> materialCategoryMap = new HashMap<>();
//        logger.info("查询材料内码，查询结果：{}", JSONObject.toJSONString(materialResponse));
//        if (materialResponse.isSuccess()) {
//            List<MaterialCategoryVO> materialCategoryVOList = materialResponse.getData();
//            materialCategoryMap = materialCategoryVOList.stream()
//                    .collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode,
//                            (key1, key2) -> key2));
//        }
//        logger.info("查询材料内码转map，转换结果：{}", JSONObject.toJSONString(materialCategoryMap));
//        // 查询项目信息
//        List<Long> projectIdList = settlementEntityList.stream().map(SettlementEntity::getProjectId)
//                .distinct().collect(Collectors.toList());
//        CommonResponse<List<ProjectPoolDTO>> projectResponse = projectSetApi.getProjectListIds(projectIdList);
//        logger.info("查询项目地址，查询结果：{}", JSONObject.toJSONString(projectResponse));
//        Map<Long, String> projectAreaMap = new HashMap<>();
//        Map<Long, String> projectAreaNameMap = new HashMap<>();
//        if (projectResponse.isSuccess()) {
//            List<ProjectPoolDTO> projectPoolList = projectResponse.getData();
//            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getArea()))
//                    .collect(Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
//            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getAreaName()))
//                    .collect(Collectors
//                            .toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
//        }
//        // 材料明细按结算id分组
//        Map<Long, List<SettlementDetailEntity>> detailMap = detailEntityList.stream()
//                .collect(Collectors.groupingBy(SettlementDetailEntity::getSettlementId));
//        // 处理结算及结算明细
////        for (SettlementEntity entity : settlementEntityList) {
////            entity.setSettlementDetailList(detailMap.get(entity.getId()));
////        }
//        // 进行插入数据组装
//        List<PriceSettlementEntity> saveEntityList = new ArrayList<>();
//        for (SettlementEntity entity : settlementEntityList) {
//            List<SettlementDetailEntity> entityDetailList = detailMap.get(entity.getId());
//            if (CollectionUtils.isEmpty(entityDetailList)) continue;
//            for (SettlementDetailEntity detailEntity : entityDetailList) {
//                PriceSettlementEntity priceSettlementEntity = BeanMapper.map(entity, PriceSettlementEntity.class);
//                if(null!=entity.getContractId()&&contractEntityMap.containsKey(entity.getContractId())){
//                    ContractEntity contractEntity = contractEntityMap.get(entity.getContractId());
//                }
//                priceSettlementEntity.setArea(projectAreaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
//                priceSettlementEntity.setAreaName(projectAreaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取
//                priceSettlementEntity.setSourceId(entity.getId());
//                priceSettlementEntity.setSourceCode(entity.getBillCode());
//                priceSettlementEntity.setSourceDetailId(detailEntity.getId());
//                // 子表信息
//                priceSettlementEntity.setMaterialId(detailEntity.getMaterialId());
//                priceSettlementEntity.setMaterialCode(detailEntity.getMaterialCode());
//                priceSettlementEntity.setMaterialName(detailEntity.getMaterialName());
//                priceSettlementEntity.setMaterialTypeId(detailEntity.getMaterialTypeId());
//                priceSettlementEntity.setMaterialTypeName(detailEntity.getMaterialTypeName());
//                priceSettlementEntity
//                        .setInnerCode(materialCategoryMap.get(detailEntity.getMaterialTypeId())); // 分类内码，查询获取
//                priceSettlementEntity.setSpec(detailEntity.getSpec());
//                priceSettlementEntity.setUnitId(detailEntity.getUnitId());
//                priceSettlementEntity.setUnitName(detailEntity.getUnit());
//                priceSettlementEntity.setSettleNum(detailEntity.getNum());
//                priceSettlementEntity.setSettlePrice(detailEntity.getPrice());
//                priceSettlementEntity.setSettleMny(detailEntity.getMny());
//                priceSettlementEntity.setSettleTaxRate(detailEntity.getTaxRate());
//                priceSettlementEntity.setSettleTaxMny(detailEntity.getTaxMny());
//                priceSettlementEntity.setSettleTaxPrice(detailEntity.getTaxPrice());
//                priceSettlementEntity.setMemo(detailEntity.getMemo());
//
//                priceSettlementEntity.setOutFlag(OutFlagEnum.未移除.getCode());
//                priceSettlementEntity.setId(null);
//                priceSettlementEntity.setCreateTime(null);
//                priceSettlementEntity.setCreateUserCode(null);
//                priceSettlementEntity.setUpdateTime(null);
//                priceSettlementEntity.setUpdateUserCode(null);
//                priceSettlementEntity.setDr(detailEntity.getDr());
//                saveEntityList.add(priceSettlementEntity);
//            }
//        }
//        // 查询是否为修改
//        if (CollectionUtils.isEmpty(saveEntityList)) return;
//        List<Long> sourceDetailIdList = saveEntityList.stream().map(PriceSettlementEntity::getSourceDetailId)
//                .collect(Collectors.toList());
//        // 查询数据库
//        QueryParam priceParam = new QueryParam();
//        priceParam.getParams().put("sourceDetailId", new Parameter(QueryParam.IN, sourceDetailIdList));
//        List<PriceSettlementEntity> queryPriceList = super.queryList(priceParam, false);
//        if (CollectionUtils.isNotEmpty(queryPriceList)) {
//            // sourceDetailId,id
//            Map<Long, PriceSettlementEntity> queryPriceMap = queryPriceList.stream()
//                    .collect(Collectors.toMap(PriceSettlementEntity::getSourceDetailId, Function.identity(),
//                            (key1, key2) -> key2));
//            for (PriceSettlementEntity entity : saveEntityList) {
//                PriceSettlementEntity queryEntity = queryPriceMap.get(entity.getSourceDetailId());
//                if (queryEntity != null) {
//                    entity.setId(queryEntity.getId());
//                    entity.setOutFlag(queryEntity.getOutFlag());
//                }
//            }
//        }
//        // 批量变更保存数据
//        super.saveOrUpdateBatch(saveEntityList);
//        // 删除bill_state非1和3的数据
//        QueryWrapper<PriceSettlementEntity> wrapper = new QueryWrapper<>();
//        wrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
//                BillStateEnum.PASSED_STATE.getBillStateCode()));
//        super.remove(wrapper, false);
////        baseMapper.delPriceContractByBillState();
//        // 删除dr!=0的数据
//        // 删除的id
//        List<Long> delIdList = saveEntityList.stream().filter(t -> t.getDr() != 0).map(PriceSettlementEntity::getId)
//                .collect(Collectors.toList());
//        if (CollectionUtils.isNotEmpty(delIdList)) {
//            super.removeByIds(delIdList, false);
//        }
    }
}
