package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
@Api(value = "消耗材-验收主表", tags = {"消耗材-验收主表"})
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC-CHECK-CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "BT220215000000006";//此处需要根据实际修改
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/check/card";
    ;

    @Autowired
    private ICheckService service;
    @Autowired
    private CheckBpmServiceImpl checkBpmService;

    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    ICommonBusinessService check;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {

        CheckVO vo = service.saveOrUpdates(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
    	CheckEntity entity = service.selectById(id);
    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        service.deletes(vos);
        return CommonResponse.success("删除成功！");
    }

//    @ApiOperation("批量删除单据")
//    @RequestMapping(value = "/deletssse", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<String> deletesss(@RequestParam Long billId) {
//        checkBpmService.afterApprovalProcessor(billId,null,"BILL_TYPE");
//        return null;
//    }



    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    @ApiOperation("参照")
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        if (StringUtils.isNotEmpty(condition)&&JSONObject.parseObject(condition).containsKey("gfSupplierId")) {
            //说明是供方参照合同  只根据供应商主键查询
            /** 租户隔离 */
            CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
            if (!commonResponse.isSuccess()) {
                logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
                throw new BusinessException("获取供应商信息失败！");
            }
            Long supplierId = commonResponse.getData().getId();
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
        }else{
            //说明是采购端
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        }
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contract_id", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            if (_con.containsKey("accountFlag")) {
                param.getParams().put("account_flag", new Parameter(QueryParam.EQ, _con.get("accountFlag")));
            }
            if (_con.containsKey("settleFlag")) {
                param.getParams().put("settle_flag", new Parameter(QueryParam.EQ, _con.get("settleFlag")));
            }
        }

        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




     //供方

    @RequestMapping(value = "/pageGFList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageGFList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        //供方我的框架协议
        //1, 先根据供方租户主键查询到合作的企业(采购租户的租户主键)
        // 查询合作企业的租户主键
        CommonResponse<List<String>> response = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!response.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",response.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = response.getData();
        logger.info("合作企业信息：{}",systemIdList);
        if(CollectionUtils.isNotEmpty(systemIdList)){
            param.getParams().put("tenant_id", new Parameter("in",systemIdList));
        }
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
        param.getComplexParams().add(getGFPageQueryParam());
        IPage<CheckEntity> pageData= service.queryPage(param,false);

        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), CheckVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelGFExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelGFExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("linkName");
        //供方我的框架协议
        //1, 先根据供方租户主键查询到合作的企业(采购租户的租户主键)
        // 查询合作企业的租户主键
        CommonResponse<List<String>> cooperResponse = cooperateEnterpriseApi
                .getCooperateEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
        if (!cooperResponse.isSuccess()) {
            logger.error("获取合作企业信息失败！失败原因：{}",cooperResponse.getMsg());
            throw new BusinessException("获取合作企业信息失败");
        }
        List<String> systemIdList = cooperResponse.getData();
        logger.info("合作企业信息：{}",systemIdList);
        if(CollectionUtils.isNotEmpty(systemIdList)){
            param.getParams().put("tenant_id", new Parameter("in",systemIdList));
        }
        // 2，先根据供方租户主键查询到自己在采购方对应的供应商主键
        CommonResponse<SupplierDTO> commonResponse = supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            logger.error("获取供应商信息失败！失败原因：{}",commonResponse.getMsg());
            throw new BusinessException("获取供应商信息失败！");
        }
        Long supplierId = commonResponse.getData().getId();

        param.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
        param.getComplexParams().add(getGFPageQueryParam());

        List<CheckEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<CheckVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            voList = BeanMapper.mapList(list,CheckVO.class);

        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("CheckGF-export.xlsx", beans, response);
    }


    @ApiOperation("更新供应商自己状态")
    @RequestMapping(value = "/updateChangState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> close(@RequestParam Long id, @RequestParam String changState){
        // 供应商自己状态：未生效free、审核中checking、已生效pass，审核驳回returned
        service.update(new UpdateWrapper<CheckEntity>().eq("id", id).set("chang_state", changState));
        return CommonResponse.success("成功");
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deleteGF", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteGF(@RequestBody List<CheckVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1) {
            throw new BusinessException("验收单不允许批量删除!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = service.selectById(checkVO.getId());
        if ("1".equals(checkEntity.getSourceType())){
            throw new BusinessException("采购方验收单不允许删除!");
        }
        if (!"free".equals(checkEntity.getChangState())){
            throw new BusinessException("只能删除未生效的验收单!");
        }
        service.deletes(vos);
        return CommonResponse.success("删除成功！");
    }

    public ComplexParam getGFPageQueryParam() {
        //1 供方数据 - - 供应商主键是自己的  or  采购端数据 - - 供应商主键是自己的 审批通过的数据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));//数据来源-采购端
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));//审批通过
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("sourceType",new Parameter(QueryParam.EQ,2));//数据来源-供方
        c1.getComplexParams().add(c3);
        return c1;
    }


    @ApiOperation("供方提交或者采购方驳回")
    @RequestMapping(value = "/submitGF", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody CheckVO saveOrUpdateVO) {
        LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(CheckEntity::getId,saveOrUpdateVO.getId());
        updateWrapper.set(CheckEntity::getChangState, saveOrUpdateVO.getChangState());
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getReturnReason())){
            updateWrapper.set(CheckEntity::getReturnReason, saveOrUpdateVO.getReturnReason());
        }
        service.update(updateWrapper);
        return  CommonResponse.success();
    }
}
