package com.ejianc.business.promaterial.reconciliation.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationCollectService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationDetailVO;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

//import com.ejianc.business.promaterial.out.bean.OutStoreEntity;


/**
 * 对账单主表
 *
 * @author generator
 */
@Controller
@RequestMapping("reconciliation")
@Api(value = "对账单主表", tags = {"对账单主表"})
public class ReconciliationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DZ_CODE";//此处需要根据实际修改

    @Autowired
    private IReconciliationService service;
    @Autowired
    private IReconciliationDetailService detailService;
    @Autowired
    private IReconciliationCollectService collectService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReconciliationVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody ReconciliationVO saveOrUpdateVO) {
        ReconciliationEntity entity = BeanMapper.map(saveOrUpdateVO, ReconciliationEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //合同校验
        service.checkContract(entity);
        List<ReconciliationDetailVO> detailList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            for (ReconciliationDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                if (detailVO.getId() != null) {
                    if ("del".equals(detailVO.getRowState())) {//删除
                        detailList.add(detailVO);
                    }
                }
            }
        }
        List<ReconciliationEntity> list;
        if (null == saveOrUpdateVO.getId() || saveOrUpdateVO.getId() == 0) {
            list = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", saveOrUpdateVO.getContractId()).in("bill_state", 0, 2, 4, 5).eq("dr", 0));
        }
        else {
            list = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", saveOrUpdateVO.getContractId()).in("bill_state", 0, 2, 4, 5).eq("dr", 0).ne("id", saveOrUpdateVO.getId()));
        }
        if (list.size() > 0) {
            throw new BusinessException(" 一个合同下只能有一张未生效的对账单");
        }

        //删除对账
//        service.updateAccount(0, BeanMapper.map(saveOrUpdateVO, ReconciliationEntity.class), BeanMapper.mapList(detailList, ReconciliationDetailEntity.class));
        Map<String, Object> hashMap = new HashMap<>();
        hashMap.put("reconciliation_id", entity.getId());
        collectService.removeByMap(hashMap);
        entity.setMaterialName(entity.getDetailList().stream().map(ReconciliationDetailEntity::getMaterialName).collect(Collectors.joining(",")));
        service.saveOrUpdate(entity, false);
        //更新对账信息
//        service.updateAccount(1, entity, entity.getDetailList());
        ReconciliationVO vo = BeanMapper.map(entity, ReconciliationVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryDetail(@RequestParam Long id) {
        ReconciliationEntity entity = service.selectById(id);
        ReconciliationVO vo = BeanMapper.map(entity, ReconciliationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }



    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReconciliationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReconciliationVO vo : vos) {
                ReconciliationEntity entity = service.selectById(vo.getId());
//                service.updateAccount(0, entity, entity.getDetailList());
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReconciliationVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
//        String msg = service.updateBillSupSignSyncInfo(request);
//        if (StringUtils.isNotBlank(msg)) {
//            return CommonResponse.error(msg);
//        }
        return CommonResponse.success("签字状态回写成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ReconciliationEntity> page = service.queryPage(param, false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReconciliationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReconciliationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ReconciliationVO> vos = BeanMapper.mapList(list, ReconciliationVO.class);
//        vos.forEach(t -> t.setSignStatusName(t.getSignStatus() == 0 ? "未签字" : "已签字"));
        vos.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Reconciliation-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refReconciliationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> refReconciliationData(@RequestParam Integer
                                                                                 pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
            if (null != conditionMap.get("reconciliationType")) {
                Integer reconciliationType = Integer.valueOf(conditionMap.get("reconciliationType").toString());
                param.getParams().put("reconciliationType", new Parameter(QueryParam.EQ, reconciliationType));
            }
//            if(conditionMap.containsKey("effectiveDate")){
//                String effectiveDate =conditionMap.get("effectiveDate").toString();
//                param.getParams().put("DATE_FORMAT(reconciliation_date,\"%Y-%m-%d\")", new Parameter(QueryParam.LE, effectiveDate));
//            }
        }
        IPage<ReconciliationVO> page = service.queryData(param);
//        IPage<ReconciliationEntity> page = service.queryPage(param, false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ReconciliationVO> reconciliationVOS = BeanMapper.mapList(page.getRecords(), ReconciliationVO.class);
        for (ReconciliationVO vo : reconciliationVOS) {
            LambdaQueryWrapper<ReconciliationDetailEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(ReconciliationDetailEntity::getDr, 0);
            lambd.eq(ReconciliationDetailEntity::getReconciliationId, vo.getId());
            List<ReconciliationDetailEntity> list = detailService.list(lambd);
            List<ReconciliationDetailVO> batchPlanDetailVOS = BeanMapper.mapList(list, ReconciliationDetailVO.class);
            vo.setDetailList(batchPlanDetailVOS);
        }
        pageData.setRecords(reconciliationVOS);


        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    @ApiOperation("查询合同累计对账数量")
    @RequestMapping(value = "/queryReconciliationNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryReconciliationNum(@RequestParam Long id) {
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        Integer size = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", id).in("bill_state",Arrays.asList(1,3)).eq("dr",0)).size();
        reconciliationVO.setTotalReconciliationNum(size);
        return CommonResponse.success("查询详情数据成功！", reconciliationVO);
    }
}
