package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.enums.CloseFlagEnum;
import com.ejianc.business.promaterial.delivery.enums.DeliverCheckStateEnum;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.enums.DeliverStateEnum;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service("delivery") 
public class DeliveryBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IContractService contractService;
	@Autowired
	private IOrderService orderService;

	@Autowired
	private IDeliveryService service;
	private final Logger logger = LoggerFactory.getLogger(getClass());
//	@Autowired
//	private IPushThirdDataApi pushThirdDataApi;



	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("进入推送送货单方法>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
		// 状态修改为待验收
		DeliveryEntity deliveryEntity = service.selectById(billId);
		Long orderId = deliveryEntity.getOrderId();
		OrderEntity orderEntity = orderService.selectById(orderId);
		if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
			throw new BusinessException("订单已关闭，提交失败！");
		}
		deliveryEntity.setCheckState(DeliverCheckStateEnum.WAIT_CHECK.getCode());
		deliveryEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
		service.saveOrUpdate(deliveryEntity, false);

		// 校验订单下的所有送货单数量，是否已经送完
		// 查询订单
		Map<Long, BigDecimal> map = service.sumDeliveredGroupByDetailId(orderId);
		logger.info("已送货材料信息：{}", JSONObject.toJSONString(map));
		Integer orderDeliverState = DeliverStateEnum.部分送货.getCode();
		// 全部送货的材料数量
		int fullFlag = 0;
		// 对订单明细计算
		for (OrderDetailEntity entity : orderEntity.getOrderDetailList()) {
			// 如果未发货数量是0，则不用送货，此条材料计算为已送货的材料
			if (BigDecimal.ZERO.compareTo(entity.getUnDeliverNum()) == 0) {
				fullFlag++;
				continue;
			}
			BigDecimal delivery = map.get(entity.getId());
			// 送货单送货数量为空，代表该材料没有送，则肯定是部分送货
			if (delivery == null) continue;
			entity.setDeliverNum(delivery); // 送货数量
			// a > b，代表该材料送货数量大于等于订单数量
			if (delivery.compareTo(entity.getOrderNum()) > -1) {
				fullFlag++;
				entity.setUnDeliverNum(BigDecimal.ZERO); // 未送货数量
			}
			// a < b，代表有材料未送完
			else {
				entity.setUnDeliverNum(entity.getOrderNum().subtract(delivery)); // 未送货数量
			}
		}
		// 如果全部送货的材料数量 = 接收的材料数量，则全部送货
		if (fullFlag > 0 && fullFlag == orderEntity.getOrderDetailList().size()) {
			orderDeliverState = DeliverStateEnum.全部送货.getCode();
		}
		// 状态不同切订单状态不为已送货
		if (!orderDeliverState.equals(orderEntity.getDeliverState())
				&& !DeliverStateEnum.全部送货.getCode().equals(orderEntity.getDeliverState())) {
			orderEntity.setDeliverState(orderDeliverState);
		}
		orderService.saveOrUpdate(orderEntity, false);

		logger.info("剩余订单信息：{}", JSONObject.toJSONString(orderEntity));
		logger.info("推送送货单方法结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("发货单暂时不支持撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
