/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.mapper.ContractMapper;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PURCHASE_CONTRACT_BILL_CODE = "CONTRACT_MATERIAL";
    private static final String FRAME_CONTRACT_BILL_CODE = "CONTRACT_FRAME";
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl) {
        boolean saveFlag;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        CommonResponse orgResponse;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        List entitiesc = null;
        if (contractVo.getOrgId() != null && (StringUtils.isEmpty((String)contractVo.getOrgCode()) || StringUtils.isEmpty((String)contractVo.getParentOrgCode()) || StringUtils.isEmpty((String)contractVo.getOrgName())) && (orgResponse = this.iOrgApi.getOneById(contractVo.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            contractVo.setOrgCode(orgVO.getCode());
            if (StringUtils.isEmpty((String)contractVo.getOrgName())) {
                contractVo.setOrgName(orgVO.getName());
            }
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    contractVo.setParentOrgId(parentOrgVO.getId());
                    contractVo.setParentOrgCode(parentOrgVO.getCode());
                    contractVo.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                contractVo.setParentOrgId(contractVo.getOrgId());
                contractVo.setParentOrgCode(contractVo.getOrgCode());
                contractVo.setParentOrgName(contractVo.getOrgName());
            }
        }
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        if (!isControl.booleanValue() && StringUtils.isEmpty((String)contractVo.getBillCode())) {
            entity.setBillCode(this.getContractBillCode(contractVo));
        }
        if (entity.getId() == null) {
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(0);
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("frame_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("frame_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if (!isControl.booleanValue() && !(saveFlag = super.saveOrUpdate((Object)entity, false))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class));
    }

    @Override
    public CommonResponse<ContractVO> saveOrUpdateFrame(ContractVO contractVo) {
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        List entitiesc = null;
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)FRAME_CONTRACT_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(0);
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("frame_flag", new Parameter("eq", (Object)1));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("frame_flag", new Parameter("eq", (Object)1));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        boolean saveFlag = super.saveOrUpdate((Object)entity, false);
        if (!saveFlag) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class));
    }

    private String getContractBillCode(ContractVO contractVo) {
        String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
        BillCodeParam billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String contractBillCode = (String)billCode.getData();
        return contractBillCode;
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        List entities = null;
        List entitiesc = null;
        ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(contractVo.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        if (!isControl.booleanValue() && StringUtils.isEmpty((String)contractVo.getBillCode())) {
            QueryParam billCodeParam = new QueryParam();
            billCodeParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVo.getMainContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            billCodeParam.getParams().put("bill_state", new Parameter("in", billStateList));
            List billCOdeSupplementList = this.service.queryList(billCodeParam, false);
            String supplementNum = "";
            supplementNum = billCOdeSupplementList.size() < 9 ? supplementNum + "0" + (billCOdeSupplementList.size() + 1) : supplementNum + (billCOdeSupplementList.size() + 1);
            entity.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVo.getMainContractId()));
            List supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        this.checkContract(contractVo.getMainContractId(), contractVo.getId());
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if ("1".equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity, false);
        }
        return (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());
        supplementVO.setSignPlace(contractVO.getSignPlace());
        supplementVO.setCustomerEmployeeId(contractVO.getCustomerEmployeeId());
        supplementVO.setCustomerEmployeeName(contractVO.getCustomerEmployeeName());
        supplementVO.setCustomerEmployeeMobile(contractVO.getCustomerEmployeeMobile());
        supplementVO.setSupplierEmployeeName(contractVO.getSupplierEmployeeName());
        supplementVO.setSupplierEmployeeMobile(contractVO.getSupplierEmployeeMobile());
        supplementVO.setPricingType(contractVO.getPricingType());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectPlace(contractVO.getProjectPlace());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setSignDate(new Date());
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setFrameFlag(Integer.valueOf(0));
        supplementVO.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        supplementVO.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        supplementVO.setMainContractCreateDate(contractVO.getMainContractCreateDate());
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setFilingStatus(Integer.valueOf(0));
        supplementVO.setPurchaseId(contractVO.getPurchaseId());
        supplementVO.setPurchaseName(contractVO.getPurchaseName());
        supplementVO.setFrameContractId(contractVO.getFrameContractId());
        supplementVO.setFrameFlag(Integer.valueOf(0));
        supplementVO.setFrameContractCode(contractVO.getFrameContractCode());
        supplementVO.setFrameContractName(contractVO.getFrameContractName());
        supplementVO.setFrameCustomerId(contractVO.getFrameCustomerId());
        supplementVO.setFrameCustomerName(contractVO.getFrameCustomerName());
        supplementVO.setFrameSupplierId(contractVO.getFrameSupplierId());
        supplementVO.setFrameSupplierName(contractVO.getFrameSupplierName());
        return supplementVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)super.selectById((Serializable)id));
        entity.setContractDetailList(null);
        ContractVO contractVo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, (Object)id);
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879);
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            contractVo.setContractDetailList(BeanMapper.mapList((Iterable)details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_money_with_tax) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO recordVO = new ContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        recordVO.setId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        recordVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        recordVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            allSupplementAmt = supplementEntities.stream().map(e -> e.getContractTaxMny() == null ? BigDecimal.ZERO : e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        recordVO.setSupplementAmtRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)1);
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List contractChangeEntityList;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("billState", new Parameter("in", billStateList));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractChangeEntityList = this.contractChangeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        return true;
    }
}

