/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.settlement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.ContractSettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.ExportSettlementVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlement"})
@Api(value="\u7ed3\u7b97\u5355\u4e3b\u8868", tags={"\u7ed3\u7b97\u5355\u4e3b\u8868"})
public class SettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettlementService service;
    @Autowired
    private ISupplierApi supplierApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SettlementVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementVO> queryDetail(@RequestParam Long id) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(id));
        SettlementVO vo = (SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u8fd1\u4e00\u6b21\u7ed3\u7b97\u65e5\u671f\u548c\u7ed3\u7b97\u91d1\u989d\uff0c\u7ed3\u7b97\u6b21\u6570")
    @RequestMapping(value={"/getDateMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> getDateMny(@RequestParam Long contractId) {
        return this.service.getDateMny(contractId);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementVO> vos) {
        return this.service.delete(vos);
    }

    @ApiOperation(value="\u4f9b\u65b9\u63d0\u4ea4\u6216\u8005\u91c7\u8d2d\u65b9\u9a73\u56de")
    @RequestMapping(value={"/submitGF"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> submitGF(@RequestBody SettlementVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        updateWrapper.set(SettlementEntity::getChangState, (Object)saveOrUpdateVO.getChangState());
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getReturnReason())) {
            updateWrapper.set(SettlementEntity::getReturnReason, (Object)saveOrUpdateVO.getReturnReason());
        }
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    @ApiOperation(value="\u6839\u636e\u5408\u540cid\u67e5\u8be2\u7ed3\u7b97\u8bb0\u5f55")
    @RequestMapping(value={"/querySettleRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementRecordVO> querySettleRecord(@RequestParam Long id) {
        SettlementRecordVO vo = this.service.querySettleRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u7ed3\u7b97\u5355\u6210\u529f", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        param.getComplexParams().add(this.getPageQueryParam(supState));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getPageQueryParam(List<String> supState) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c3.getParams().put("changState", new Parameter("in", supState));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @ApiOperation(value="\u4f9b\u65b9\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryGFList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> queryGFList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        CommonResponse commonResponse = this.supplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.getMsg());
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierId = ((SupplierDTO)commonResponse.getData()).getId();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getComplexParams().add(this.getGFPageQueryParam());
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getGFPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sourceType", new Parameter("eq", (Object)1));
        c2.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("sourceType", new Parameter("eq", (Object)2));
        c1.getComplexParams().add(c3);
        return c1;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void ConcreteExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<String> supState = new ArrayList<String>();
        supState.add("checking");
        supState.add("pass");
        param.getComplexParams().add(this.getPageQueryParam(supState));
        List list = this.service.queryList(param);
        ArrayList<ExportSettlementVO> settlementVOS = new ArrayList<ExportSettlementVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (SettlementEntity entity : list) {
                ExportSettlementVO map = (ExportSettlementVO)BeanMapper.map((Object)((Object)entity), ExportSettlementVO.class);
                if (entity.getSettlementDate() != null) {
                    map.setSettlementDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getSettlementDate()));
                }
                switch (entity.getBillState()) {
                    case 0: {
                        map.setBillState("\u81ea\u7531\u6001");
                        break;
                    }
                    case 1: {
                        map.setBillState("\u5df2\u63d0\u4ea4");
                        break;
                    }
                    case 2: {
                        map.setBillState("\u5ba1\u6279\u4e2d");
                        break;
                    }
                    case 3: {
                        map.setBillState("\u5ba1\u6279\u901a\u8fc7");
                        break;
                    }
                    case 4: {
                        map.setBillState("\u5ba1\u6279\u9a73\u56de");
                        break;
                    }
                    case 5: {
                        map.setBillState("\u5ba1\u6279\u4e2d");
                    }
                }
                settlementVOS.add(map);
            }
        }
        HashMap<String, ArrayList<ExportSettlementVO>> beans = new HashMap<String, ArrayList<ExportSettlementVO>>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("Settlement-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> refSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/queryDetailRecord"})
    @ResponseBody
    public CommonResponse<ContractSettlementRecordVO> queryDetailRecord(Long id) {
        ContractSettlementRecordVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/querySettlementByContractId"})
    @ResponseBody
    public CommonResponse<List<SettlementVO>> querySettlementByContractId(@RequestBody SettlementVO settlementVO) {
        List<SettlementVO> list = this.service.querySettlementByContractId(settlementVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }
}

