package com.ejianc.business.promaterial.check.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材-验收主表
 *
 * @author generator
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC-CHECK-CODE";//此处需要根据实际修改

    @Override
    @Transactional
    public CheckVO saveOrUpdates(CheckVO saveOrUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);

        //保存校验
        QueryWrapper<CheckEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("delivery_id", saveOrUpdateVO.getDeliveryId()).eq("chang_state", "free");
        if (null != saveOrUpdateVO.getId()){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<CheckEntity> checkEntityList = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(checkEntityList) && checkEntityList.size() > 0){
            throw new BusinessException("保存失败，当前送货单有未生效的验收单");
        }

        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setSettleFlag(0);
        entity.setAccountFlag(0);

        super.saveOrUpdate(entity, false);

        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return vo;
    }

    @Override
    @Transactional
    public void deletes(List<CheckVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1) {
            throw new BusinessException("验收单不允许批量删除!");
        }
        super.removeByIds(vos.stream().map(CheckVO::getId).collect(Collectors.toList()), true);
        return;

    }




    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     *
     * @return Map<String, Integer>
     */
    @Override
    public Map<String, Integer> countBillNum(Long projectId, Date checkDate) {
        HashMap<String, Integer> resultMap = new HashMap<>();

        LambdaQueryWrapper<CheckEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(CheckEntity::getProjectId, projectId)
                .eq(CheckEntity::getCheckDate, checkDate);
        int checkCount = super.count(lambdaQuery);
        resultMap.put("消耗材", checkCount);
        return resultMap;
    }


    @Override
    public List<CheckDetailVO> getCheckDetails(Page<CheckDetailVO> page, QueryWrapper wrapper) {
        return baseMapper.getCheckDetails(page,wrapper);
    }

    @Override
    public List<CheckVO> getCheckReturns(Page<CheckVO> page, QueryWrapper wrapper) {
        return baseMapper.getCheckReturns(page,wrapper);
    }

    @Override
    public List<CheckDetailVO> getReturnDetails(List<Long> returnIds) {
        return baseMapper.getReturnDetails(returnIds);
    }
}
