package com.ejianc.business.promaterial.order.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 材料订单主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_order")
public class OrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="commit_id")
    private Long commitId; // 提交人
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="order_name")
    private String orderName; // 订单名称
    @TableField(value="customer_id")
    private Long customerId; // 甲方Id（采购方）
    @TableField(value="customer_name")
    private String customerName; // 甲方名称（采购方）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="contract_type")
    private Long contractType; // 合同类型 1-材料合同, 2-安装合同
    @TableField(value="link_id")
    private Long linkId; // 联系人
    @TableField(value="link_name")
    private String linkName; // 联系人名称
    @TableField(value="link_telephone")
    private String linkTelephone; // 联系人电话
    @TableField(value="order_expiry_date")
    private Date orderExpiryDate; // 要求到货日期
    @TableField(value="order_address")
    private String orderAddress; // 收货地址
    @TableField(value="order_note")
    private String orderNote; // 送货要求
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="contract_order_tax_mny")
    private BigDecimal contractOrderTaxMny; // 合同含本次累计下单金额
    @TableField(value="contract_order_mny")
    private BigDecimal contractOrderMny; // 合同含本次累计下单金额(不含税)
    @TableField(value="contract_no_order_tax_mny")
    private BigDecimal contractNoOrderTaxMny; // 合同不含本次累计下单金额
    @TableField(value="contract_no_order_mny")
    private BigDecimal contractNoOrderMny; // 合同不含本次累计下单金额(不含税)
    @TableField(value="order_tax_mny")
    private BigDecimal orderTaxMny; // 本次下单金额
    @TableField(value="order_mny")
    private BigDecimal orderMny; // 本次下单(不含税)
    @TableField(value="receive_state")
    private Integer receiveState; // 接收状态（0-待接收,1-部分接收，2-全部接收，3-不予接收）
    @TableField(value="deliver_state")
    private Integer deliverState; // 送货状态（0-待送货，1-部分送货，2-已送货）
    @TableField(value="order_flag")
    private Integer orderFlag; // 关闭状态 0-正常，1-已关闭
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    
    @TableField(exist=false)
    @SubEntity(serviceName="orderDetailService", pidName = "orderId")
    private List<OrderDetailEntity> orderDetailList = new ArrayList<>(); // 材料订单子表

    public BigDecimal getContractNoOrderTaxMny() {
        return contractNoOrderTaxMny;
    }

    public void setContractNoOrderTaxMny(BigDecimal contractNoOrderTaxMny) {
        this.contractNoOrderTaxMny = contractNoOrderTaxMny;
    }

    public BigDecimal getContractNoOrderMny() {
        return contractNoOrderMny;
    }

    public void setContractNoOrderMny(BigDecimal contractNoOrderMny) {
        this.contractNoOrderMny = contractNoOrderMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    public String getOrderAddress() {
        return orderAddress;
    }

    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    public String getOrderNote() {
        return orderNote;
    }

    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractOrderTaxMny() {
        return contractOrderTaxMny;
    }

    public void setContractOrderTaxMny(BigDecimal contractOrderTaxMny) {
        this.contractOrderTaxMny = contractOrderTaxMny;
    }
    public BigDecimal getContractOrderMny() {
        return contractOrderMny;
    }

    public void setContractOrderMny(BigDecimal contractOrderMny) {
        this.contractOrderMny = contractOrderMny;
    }
    public BigDecimal getOrderTaxMny() {
        return orderTaxMny;
    }

    public void setOrderTaxMny(BigDecimal orderTaxMny) {
        this.orderTaxMny = orderTaxMny;
    }
    public BigDecimal getOrderMny() {
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny) {
        this.orderMny = orderMny;
    }
    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    public Integer getDeliverState() {
        return deliverState;
    }

    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    public Integer getOrderFlag() {
        return orderFlag;
    }

    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }
    

    public List<OrderDetailEntity> getOrderDetailList() {
        return orderDetailList;
    }

    public void setOrderDetailList(List<OrderDetailEntity> orderDetailList) {
        this.orderDetailList = orderDetailList;
    }
}
