package com.ejianc.business.promaterial.check.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
/**
 * 消耗材-验收主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_check")
public class CheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="commit_id")
    private Long commitId; // 提交人
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="order_name")
    private String orderName; // 订单名称
    @TableField(value="customer_id")
    private Long customerId; // 甲方Id（采购方）
    @TableField(value="customer_name")
    private String customerName; // 甲方名称（采购方）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="contract_type")
    private Long contractType; // 合同类型 1-材料合同, 2-安装合同
    @TableField(value="link_id")
    private Long linkId; // 联系人
    @TableField(value="link_name")
    private String linkName; // 联系人名称
    @TableField(value="link_telephone")
    private String linkTelephone; // 联系人电话
    @TableField(value="order_expiry_date")
    private Date orderExpiryDate; // 要求到货日期
    @TableField(value="order_address")
    private String orderAddress; // 收货地址
    @TableField(value="order_note")
    private String orderNote; // 送货要求
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="contract_order_tax_mny")
    private BigDecimal contractOrderTaxMny; // 合同含本次累计下单金额
    @TableField(value="contract_order_mny")
    private BigDecimal contractOrderMny; // 合同含本次累计下单金额(不含税)
    @TableField(value="contract_no_order_tax_mny")
    private BigDecimal contractNoOrderTaxMny; // 合同不含本次累计下单金额
    @TableField(value="contract_no_order_mny")
    private BigDecimal contractNoOrderMny; // 合同不含本次累计下单金额
    @TableField(value="order_tax_mny")
    private BigDecimal orderTaxMny; // 本次下单金额
    @TableField(value="order_mny")
    private BigDecimal orderMny; // 本次下单(不含税)
    @TableField(value="receive_state")
    private Integer receiveState; // 接收状态（0-待接收,1-部分接收，2-全部接收，3-不予接收）
    @TableField(value="deliver_state")
    private Integer deliverState; // 送货状态（0-待送货，1-部分送货，2-已送货）
    @TableField(value="order_flag")
    private Integer orderFlag; // 关闭状态 0-正常，1-已关闭
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="order_id")
    private Long orderId; // 订单主键
    @TableField(value="order_bill_code")
    private String orderBillCode; // 订单单据编号
    @TableField(value="check_state")
    private Integer checkState; // 验收状态（0-未验收，1--已验收）
    @TableField(value="license_plate")
    private String licensePlate; // 车牌号
    @TableField(value="deliver_id")
    private Long deliverId; // 送货人id
    @TableField(value="deliver_name")
    private String deliverName; // 送货人名称
    @TableField(value="deliver_link_telephone")
    private String deliverLinkTelephone; // 送货人联系电话
    @TableField(value="delivery_date")
    private Date deliveryDate; // 送货日期
    @TableField(value="delivery_expiry_date")
    private Date deliveryExpiryDate; // 预计到货日期
    @TableField(value="delivery_num")
    private String deliveryNum; // 运单号

    @TableField(value="delivery_id")
    private Long deliveryId; // 发货主键
    @TableField(value="delivery_bill_code")
    private String deliveryBillCode; // 发货单据编号
    @TableField(value="receive_type_id")
    private Long receiveTypeId; // 收料方式id
    @TableField(value="receive_type_name")
    private String receiveTypeName; // 收料方式名称
    @TableField(value="checker_id")
    private Long checkerId; // 验收人id
    @TableField(value="checker_name")
    private String checkerName; // 验收人名称
    @TableField(value="check_date")
    private Date checkDate; // 验收时间
    @TableField(value="check_tax_mny")
    private BigDecimal checkTaxMny; // 验收金额
    @TableField(value="check_mny")
    private BigDecimal checkMny; // 验收金额（不含税）
    @TableField(value="delivery_type")
    private Integer deliveryType; // 验收单来源 0-自制，1-送货单，2-供应商
    @TableField(value="supplier_employee_id")
    private Long supplierEmployeeId; // 供方经办人
    @TableField(value="supplier_employee_name")
    private String supplierEmployeeName; // 供方经办人名称
    @TableField(value="check_memo")
    private String checkMemo; // 验收备注
    @TableField(value="confirm_state")
    private Integer confirmState; // 确认状态（0-待甲方验收,1-甲方已确认，2-审核驳回）
    @TableField(value="evaluate_score")
    private Integer evaluateScore; // 评价总分
    @TableField(value="supply_score")
    private Integer supplyScore; // 供货及时性
    @TableField(value="goods_score")
    private Integer goodsScore; // 货源准确性
    @TableField(value="quality_score")
    private Integer qualityScore; // 产品质量
    @TableField(value="service_score")
    private Integer serviceScore; // （供货）服务配合度
    @TableField(value="evaluate_goods")
    private String evaluateGoods; // 评价货品
    @TableField(value="evaluate_service")
    private String evaluateService; // 评价服务
    @TableField(value="source_type")
    private String sourceType; // 数据来源1-采购方 2-供方
    @TableField(value="chang_state")
    private String changState; // 供应商自己状态：未生效free、审核中checking、已生效pass，审核驳回returned
    @TableField(value="return_reason")
    private String returnReason; // 驳回原因


    @TableField(value = "account_flag")
    private Integer accountFlag; // 是否对账1是0否
    @TableField(value = "account_id")
    private Long accountId; // 对账主表id
    @TableField(value = "account_date")
    private Date accountDate; // 对账时间
    @TableField(value = "account_code")
    private String accountCode; // 对账单号
    @TableField(value = "settle_flag")
    private Integer settleFlag; // 是否结算1是0否
    @TableField(value = "settle_id")
    private Long settleId; // 结算主表id
    @TableField(value = "settle_date")
    private Date settleDate; // 结算时间
    @TableField(value = "settle_code")
    private String settleCode; // 结算单号

    @TableField(exist=false)
    @SubEntity(serviceName="checkDetailService", pidName = "checkId")
    private List<CheckDetailEntity> checkDetailList = new ArrayList<>(); // 消耗材-验收明细子表

    public Integer getAccountFlag() {
        return accountFlag;
    }

    public void setAccountFlag(Integer accountFlag) {
        this.accountFlag = accountFlag;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Date getAccountDate() {
        return accountDate;
    }

    public void setAccountDate(Date accountDate) {
        this.accountDate = accountDate;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getChangState() {
        return changState;
    }

    public void setChangState(String changState) {
        this.changState = changState;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    public String getOrderAddress() {
        return orderAddress;
    }

    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    public String getOrderNote() {
        return orderNote;
    }

    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractOrderTaxMny() {
        return contractOrderTaxMny;
    }

    public void setContractOrderTaxMny(BigDecimal contractOrderTaxMny) {
        this.contractOrderTaxMny = contractOrderTaxMny;
    }
    public BigDecimal getContractOrderMny() {
        return contractOrderMny;
    }

    public void setContractOrderMny(BigDecimal contractOrderMny) {
        this.contractOrderMny = contractOrderMny;
    }
    public BigDecimal getContractNoOrderTaxMny() {
        return contractNoOrderTaxMny;
    }

    public void setContractNoOrderTaxMny(BigDecimal contractNoOrderTaxMny) {
        this.contractNoOrderTaxMny = contractNoOrderTaxMny;
    }
    public BigDecimal getContractNoOrderMny() {
        return contractNoOrderMny;
    }

    public void setContractNoOrderMny(BigDecimal contractNoOrderMny) {
        this.contractNoOrderMny = contractNoOrderMny;
    }
    public BigDecimal getOrderTaxMny() {
        return orderTaxMny;
    }

    public void setOrderTaxMny(BigDecimal orderTaxMny) {
        this.orderTaxMny = orderTaxMny;
    }
    public BigDecimal getOrderMny() {
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny) {
        this.orderMny = orderMny;
    }
    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    public Integer getDeliverState() {
        return deliverState;
    }

    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    public Integer getOrderFlag() {
        return orderFlag;
    }

    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    public Integer getCheckState() {
        return checkState;
    }

    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }
    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    public Long getDeliverId() {
        return deliverId;
    }

    public void setDeliverId(Long deliverId) {
        this.deliverId = deliverId;
    }
    public String getDeliverName() {
        return deliverName;
    }

    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    public String getDeliverLinkTelephone() {
        return deliverLinkTelephone;
    }

    public void setDeliverLinkTelephone(String deliverLinkTelephone) {
        this.deliverLinkTelephone = deliverLinkTelephone;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public Date getDeliveryExpiryDate() {
        return deliveryExpiryDate;
    }

    public void setDeliveryExpiryDate(Date deliveryExpiryDate) {
        this.deliveryExpiryDate = deliveryExpiryDate;
    }
    public String getDeliveryNum() {
        return deliveryNum;
    }

    public void setDeliveryNum(String deliveryNum) {
        this.deliveryNum = deliveryNum;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public String getDeliveryBillCode() {
        return deliveryBillCode;
    }

    public void setDeliveryBillCode(String deliveryBillCode) {
        this.deliveryBillCode = deliveryBillCode;
    }
    public Long getReceiveTypeId() {
        return receiveTypeId;
    }

    public void setReceiveTypeId(Long receiveTypeId) {
        this.receiveTypeId = receiveTypeId;
    }
    public String getReceiveTypeName() {
        return receiveTypeName;
    }

    public void setReceiveTypeName(String receiveTypeName) {
        this.receiveTypeName = receiveTypeName;
    }
    public Long getCheckerId() {
        return checkerId;
    }

    public void setCheckerId(Long checkerId) {
        this.checkerId = checkerId;
    }
    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }
    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }
    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }
    public String getCheckMemo() {
        return checkMemo;
    }

    public void setCheckMemo(String checkMemo) {
        this.checkMemo = checkMemo;
    }
    public Integer getConfirmState() {
        return confirmState;
    }

    public void setConfirmState(Integer confirmState) {
        this.confirmState = confirmState;
    }
    public Integer getEvaluateScore() {
        return evaluateScore;
    }

    public void setEvaluateScore(Integer evaluateScore) {
        this.evaluateScore = evaluateScore;
    }
    public Integer getSupplyScore() {
        return supplyScore;
    }

    public void setSupplyScore(Integer supplyScore) {
        this.supplyScore = supplyScore;
    }
    public Integer getGoodsScore() {
        return goodsScore;
    }

    public void setGoodsScore(Integer goodsScore) {
        this.goodsScore = goodsScore;
    }
    public Integer getQualityScore() {
        return qualityScore;
    }

    public void setQualityScore(Integer qualityScore) {
        this.qualityScore = qualityScore;
    }
    public Integer getServiceScore() {
        return serviceScore;
    }

    public void setServiceScore(Integer serviceScore) {
        this.serviceScore = serviceScore;
    }
    public String getEvaluateGoods() {
        return evaluateGoods;
    }

    public void setEvaluateGoods(String evaluateGoods) {
        this.evaluateGoods = evaluateGoods;
    }
    public String getEvaluateService() {
        return evaluateService;
    }

    public void setEvaluateService(String evaluateService) {
        this.evaluateService = evaluateService;
    }
    

    public List<CheckDetailEntity> getCheckDetailList() {
        return checkDetailList;
    }

    public void setCheckDetailList(List<CheckDetailEntity> checkDetailList) {
        this.checkDetailList = checkDetailList;
    }
}
